package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.SettleApplyDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyDetailsVO;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.purchase.repo.SettleApplyRepo;
import com.elitesland.tw.tw5.server.prd.purchase.dao.SettleApplyDAO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.SettleApplyConvert;
import com.elitesland.tw.tw5.api.prd.purchase.service.SettleApplyService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyPayload;
import com.elitesland.tw.tw5.server.prd.purchase.entity.SettleApplyDO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyVO;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyQuery;
import com.elitesland.tw.tw5.server.prd.purchase.convert.SettleApplyConvert;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 结算申请
 *
 * @author wangly
 * @date 2024-08-21
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SettleApplyServiceImpl extends BaseServiceImpl implements SettleApplyService {

    private final SettleApplyRepo settleApplyRepo;
    private final SettleApplyDAO settleApplyDAO;
    private final FileUtil fileUtil;
    private final SettleApplyDetailsService settleApplyDetailsService;
    @Override
    public PagingVO<SettleApplyVO> queryPaging(SettleApplyQuery query){
        return settleApplyDAO.queryPaging(query);
    }

    @Override
    public List<SettleApplyVO> queryListDynamic(SettleApplyQuery query){
        return settleApplyDAO.queryListDynamic(query);
    }

    @Override
    public SettleApplyVO queryByKey(Long key) {
        SettleApplyDO entity = settleApplyRepo.findById(key).orElseGet(SettleApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        SettleApplyVO vo = SettleApplyConvert.INSTANCE.toVo(entity);
        // 查询明细
        SettleApplyDetailsQuery settleApplyDetailsQuery = new SettleApplyDetailsQuery();
        settleApplyDetailsQuery.setSettleApplyId(entity.getId());
        List<SettleApplyDetailsVO> settleApplyDetailsVOList = settleApplyDetailsService.queryListDynamic(settleApplyDetailsQuery);
        vo.setSettleApplyDetailsVOList(settleApplyDetailsVOList);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SettleApplyVO insert(SettleApplyPayload payload) {
        SettleApplyDO entityDo = SettleApplyConvert.INSTANCE.toDo(payload);
        return SettleApplyConvert.INSTANCE.toVo(settleApplyRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SettleApplyVO update(SettleApplyPayload payload) {
        SettleApplyDO entity = settleApplyRepo.findById(payload.getId()).orElseGet(SettleApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        SettleApplyDO entityDo = SettleApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SettleApplyConvert.INSTANCE.toVo(settleApplyRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(SettleApplyPayload payload) {
        SettleApplyDO entity = settleApplyRepo.findById(payload.getId()).orElseGet(SettleApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = settleApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            settleApplyDAO.deleteSoft(keys);
        }
    }

}
