package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.TPurchaseContractOverPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.TPurchaseContractOverQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.TPurchaseContractOverService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.TPurchaseContractOverVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowRoleCodeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.purchase.convert.TPurchaseContractOverConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractManagerDAO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.TPurchaseContractOverDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.TPurchaseContractOverDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractStatusEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.TPurchaseContractOverRepo;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;

/**
 * 采购合同终止
 *
 * @author lemon
 * @date 2023-10-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TPurchaseContractOverServiceImpl extends BaseServiceImpl implements TPurchaseContractOverService {

    private final TPurchaseContractOverRepo tPurchaseContractOverRepo;
    private final TPurchaseContractOverDAO tPurchaseContractOverDAO;

    private final WorkflowUtil workflowUtil;

    private final PurchaseContractManagerDAO purchaseContractManagerDAO;

    private final PrdOrgOrganizationDAO daoOrg;

    private final SaleConContractDAO saleConContractDAO;

    private final PmsProjectDAO pmsProjectDAO;

    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    @Value("${tw5.workflow.orgId}")
    private Long workflow_orgId;

    private final TransactionUtilService transactionUtilService;

    @Override
    public PagingVO<TPurchaseContractOverVO> queryPaging(TPurchaseContractOverQuery query){
        return tPurchaseContractOverDAO.queryPaging(query);
    }

    @Override
    public List<TPurchaseContractOverVO> queryListDynamic(TPurchaseContractOverQuery query){
        return tPurchaseContractOverDAO.queryListDynamic(query);
    }

    @Override
    public TPurchaseContractOverVO queryByKey(Long key) {
        TPurchaseContractOverDO entity = tPurchaseContractOverRepo.findById(key).orElseGet(TPurchaseContractOverDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TPurchaseContractOverVO vo = TPurchaseContractOverConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TPurchaseContractOverVO insert(TPurchaseContractOverPayload payload) {
        payload.setOverTime(LocalDate.now());
        payload.setOverStatus(PurchaseContractStatusEnum.NOT_ACTIVE.getCode());
        TPurchaseContractOverDO entityDo = TPurchaseContractOverConvert.INSTANCE.toDo(payload);
        TPurchaseContractOverDO save = tPurchaseContractOverRepo.save(entityDo);
        purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(payload.getContractId()), PurchaseContractStatusEnum.BREAK.getCode());
        return TPurchaseContractOverConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TPurchaseContractOverVO insertWithWorkFlow(TPurchaseContractOverPayload payload) {
        payload.setOverTime(LocalDate.now());
        TPurchaseContractOverDO entityDo = TPurchaseContractOverConvert.INSTANCE.toDo(payload);
        TPurchaseContractOverDO save = tPurchaseContractOverRepo.save(entityDo);
        if (payload.getSubmit()) {
            purchaseContractOverProc(save);
        }
        return TPurchaseContractOverConvert.INSTANCE.toVo(save);
    }
    @Override
    @Transactional(rollbackFor = Exception.class)
    public TPurchaseContractOverVO update(TPurchaseContractOverPayload payload) {
        TPurchaseContractOverDO entity = tPurchaseContractOverRepo.findById(payload.getId()).orElseGet(TPurchaseContractOverDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TPurchaseContractOverDO entityDo = TPurchaseContractOverConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TPurchaseContractOverConvert.INSTANCE.toVo(tPurchaseContractOverRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TPurchaseContractOverPayload payload) {
        TPurchaseContractOverDO entity = tPurchaseContractOverRepo.findById(payload.getId()).orElseGet(TPurchaseContractOverDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tPurchaseContractOverDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tPurchaseContractOverDAO.deleteSoft(keys);
        }
    }

    /**
     * 发起合同终止审批流程
     *
     * @param
     */
    private void purchaseContractOverProc(TPurchaseContractOverDO contractOverDO) {
        // 查询采购合同
        Long purchaseContractId = contractOverDO.getContractId();
        PurchaseContractManagerVO purchaseContractManagerVO = purchaseContractManagerDAO.queryByKey(purchaseContractId);
        Long relatedSalesContract = purchaseContractManagerVO.getRelatedSalesContract();
        Long relatedProjectId = purchaseContractManagerVO.getRelatedProjectId();
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            String businessType = purchaseContractManagerVO.getBusinessType();
            String purchaseContractType = purchaseContractManagerVO.getPurchaseContractType();
            variables.put("businessType", businessType);
            variables.put("purchaseContractType", purchaseContractType);

            // 资源管理BU负责人
            PrdOrgRoleVO resBuManager = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.RES_BU_MANAGER.getCode());
            if (ObjectUtils.isEmpty(resBuManager)) {
                throw TwException.error("","资源管理Bu负责人角色不存在");
            }
            String[] splitByResBuManager = resBuManager.getRoleEmployees().split(",");
            variables.put("Activity_138ljdk", Arrays.asList(splitByResBuManager));
            variables.put("Activity_1o07m1g", Arrays.asList(splitByResBuManager));
            // 总经理
            PrdOrgRoleVO generalManager = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_MANAGER.getCode());
            if (ObjectUtils.isEmpty(generalManager)) {
                throw TwException.error("","总经理角色不存在");
            }
            String[] splitByGeneralManager = generalManager.getRoleEmployees().split(",");
            variables.put("Activity_09e07og", Arrays.asList(splitByGeneralManager));
            // 平台总体负责人
            PrdOrgRoleVO generalResponsiblePerson = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
            if (ObjectUtils.isEmpty(generalResponsiblePerson)) {
                throw TwException.error("","平台总体负责人不存在");
            }
            String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
            variables.put("Activity_0p1j24y",Arrays.asList(splitByGeneralResponsiblePerson));
            // 没项目，采购合同中的采购bu的负责人，有项目，项目的交付负责人
            if (ObjectUtils.isEmpty(relatedProjectId)){
                Long purchaseBuId = purchaseContractManagerVO.getPurchaseBuId();
                Long purchaseBuManageUserId = daoOrg.queryManageIdById(purchaseBuId);
                variables.put("Activity_05ghdlz", purchaseBuManageUserId);
                // todo 产品贸易，项目交付负责人，必须有值要不报错
                variables.put("Activity_1fg7xlt", 0);
            } else {
                PmsProjectVO pmsProjectVO = pmsProjectDAO.queryByKey(relatedProjectId);
                Long deliUserId = pmsProjectVO.getDeliUserId();
//                Long deliBuId = pmsProjectVO.getDeliBuId();
//                Long deliBuIdManageUserId = daoOrg.queryManageIdById(deliBuId);
                // todo 项目的交付负责人
                variables.put("Activity_05ghdlz", deliUserId);
                // todo 项目交付负责人
                variables.put("Activity_1fg7xlt", deliUserId);
            }
            // 根据合同类型,业务类型确定流程
//            if("con_purchase".equals(purchaseContractManagerVO.getPurchaseContractType())){
//                // 服务贸易
//                if("trade_services".equals(purchaseContractManagerVO.getBusinessType())){
//                    // 资源管理BU负责人
//                    PrdOrgRoleVO resBuManager = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.RES_BU_MANAGER.getCode());
//                    if (ObjectUtils.isEmpty(resBuManager)) {
//                        throw TwException.error("","资源管理Bu负责人角色不存在");
//                    }
//                    String[] splitByResBuManager = resBuManager.getRoleEmployees().split(",");
//                    variables.put("Activity_138ljdk", Arrays.asList(splitByResBuManager));
//                }
//                // 产品贸易
//                if("trade_product".equals(purchaseContractManagerVO.getBusinessType())){
//                    // 项目交付负责人
//                    variables.put("Activity_1fg7xlt", Arrays.asList(11));
//                }
//                // 外包费用(渠道)
//                if("outsourcing".equals(purchaseContractManagerVO.getBusinessType())){
//                    // 总经理
//                    PrdOrgRoleVO generalManager = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_MANAGER.getCode());
//                    if (ObjectUtils.isEmpty(generalManager)) {
//                        throw TwException.error("","总经理角色不存在");
//                    }
//                    String[] splitByGeneralManager = generalManager.getRoleEmployees().split(",");
//                    variables.put("Activity_09e07og", Arrays.asList(splitByGeneralManager));
//                }
//            }
////            // 项目采购
////            if("project_purchase".equals(purchaseContractManagerVO.getPurchaseContractType())){
////                // 杂项采购
////                if("mis_purchase".equals(purchaseContractManagerVO.getBusinessType())){
////
////                }
////                // 房屋租赁
////                if("house_rental".equals(purchaseContractManagerVO.getBusinessType())){
////
////                }
////            }
//            // 采购合同市场渠道/公司采购
//            if(("market".equals(purchaseContractManagerVO.getPurchaseContractType()) || "company".equals(purchaseContractManagerVO.getPurchaseContractType())) && "empty".equals(purchaseContractManagerVO.getBusinessType())){
//                // 资源管理BU负责人
//                PrdOrgRoleVO resBuManager = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.RES_BU_MANAGER.getCode());
//                if (ObjectUtils.isEmpty(resBuManager)) {
//                    throw TwException.error("","资源管理Bu负责人角色不存在");
//                }
//                String[] splitByResBuManager = resBuManager.getRoleEmployees().split(",");
//                variables.put("Activity_1o07m1g", Arrays.asList(splitByResBuManager));
//                // 平台总体负责人
//                PrdOrgRoleVO generalResponsiblePerson = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
//                if (ObjectUtils.isEmpty(generalResponsiblePerson)) {
//                    throw TwException.error("","平台总体负责人不存在");
//                }
//                String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
//                variables.put("Activity_0p1j24y",Arrays.asList(splitByGeneralResponsiblePerson));
//            }
            // 研发类采购
//            if("research".equals(purchaseContractManagerVO.getPurchaseContractType()) && "empty".equals(purchaseContractManagerVO.getBusinessType())){
//                if (ObjectUtils.isEmpty(relatedSalesContract)) {
//                    throw TwException.error("","关联销售合同为空，无法查询到交付BU负责人");
//                }
//                SaleConContractVO saleConContractVO = saleConContractDAO.queryByKey(relatedSalesContract);
//                // 交付bu负责人
//                Long deliBuId = saleConContractVO.getDeliBuId();
//                Long deliBuManageUserId = daoOrg.queryManageIdById(deliBuId);
//                variables.put("Activity_05ghdlz",deliBuManageUserId);
                // 平台总体负责人
//                PrdOrgRoleVO generalResponsiblePerson = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
//                if (ObjectUtils.isEmpty(generalResponsiblePerson)) {
//                    throw TwException.error("","平台总体负责人不存在");
//                }
//                String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
//                variables.put("Activity_0p1j24y",Arrays.asList(splitByGeneralResponsiblePerson));
//            }
//            // 行政运营类采购/资源赋能类采购
//            if(("operate".equals(purchaseContractManagerVO.getPurchaseContractType()) || "resources".equals(purchaseContractManagerVO.getPurchaseContractType())) && "empty".equals(purchaseContractManagerVO.getBusinessType())){
//                // 平台总体负责人
//                PrdOrgRoleVO generalResponsiblePerson = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, WorkFlowRoleCodeEnum.GENERAL_RESPONSIBLE_PERSON.getCode());
//                if (ObjectUtils.isEmpty(generalResponsiblePerson)) {
//                    throw TwException.error("","平台总体负责人不存在");
//                }
//                String[] splitByGeneralResponsiblePerson = generalResponsiblePerson.getRoleEmployees().split(",");
//                variables.put("Activity_0p1j24y",Arrays.asList(splitByGeneralResponsiblePerson));
//            }
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.PUR_CON_OVER.name(),
                    purchaseContractManagerVO.getPurchaseContractName() + "-采购合同终止",
                    contractOverDO.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        TPurchaseContractOverPayload payload = new TPurchaseContractOverPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(contractOverDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setOverStatus(status);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            tPurchaseContractOverDAO.updateByKeyDynamic(payload);
            // 修改合同状态
            purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.APPROVING.getCode());
        });
    }

}
