package com.elitesland.tw.tw5.server.prd.sale.service;

import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractCategoryPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractCategoryQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractCategoryService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractCategoryVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.sale.convert.SaleContractCategoryConvert;
import com.elitesland.tw.tw5.server.prd.sale.entity.SaleContractCategoryDO;
import com.elitesland.tw.tw5.server.prd.sale.repo.SaleContractCategoryRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 合同类别服务impl
 *
 * @author duwh
 * @date 2022/09/27
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SaleContractCategoryServiceImpl implements SaleContractCategoryService {

    private final SaleContractCategoryRepo repo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaleContractCategoryVO insert(SaleContractCategoryPayload payload) {
        SaleContractCategoryDO entityDo = SaleContractCategoryConvert.INSTANCE.toDo(payload);
        repo.save(entityDo);
        return SaleContractCategoryConvert.INSTANCE.toVo(entityDo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaleContractCategoryVO update(SaleContractCategoryPayload payload) {
        SaleContractCategoryDO entity = repo.findById(payload.getId()).orElseGet(SaleContractCategoryDO::new);
        Assert.notNull(entity.getId(), "不存在");
        SaleContractCategoryDO entityDo = SaleContractCategoryConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SaleContractCategoryConvert.INSTANCE.toVo(repo.save(entity));
    }

    @Override
    public SaleContractCategoryVO queryByKey(Long key) {
        SaleContractCategoryDO entity = repo.findById(key).orElseGet(SaleContractCategoryDO::new);
        Assert.notNull(entity.getId(), "不存在");
        return SaleContractCategoryConvert.INSTANCE.toVo(entity);
    }

    @Override
    public List<SaleContractCategoryVO> queryList(SaleContractCategoryQuery query) {
        return SaleContractCategoryConvert.INSTANCE.toVoList(repo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public PagingVO<SaleContractCategoryVO> paging(SaleContractCategoryQuery query) {
        Page<SaleContractCategoryDO> page = repo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(SaleContractCategoryConvert.INSTANCE::toVo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            repo.deleteSoft(keys);
        }
    }


}
