package com.elitesland.tw.tw5.server.prd.sale.service;

import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.sale.convert.SaleContractConvert;
import com.elitesland.tw.tw5.server.prd.sale.entity.SaleContractDO;
import com.elitesland.tw.tw5.server.prd.sale.repo.SaleContractRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;


/**
 * 合同服务impl
 *
 * @author duwh
 * @date 2022/09/27
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SaleContractServiceImpl implements SaleContractService {

    private final SaleContractRepo saleContractRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaleContractVO insert(SaleContractPayload payload) {
        SaleContractDO entityDo = SaleContractConvert.INSTANCE.toDo(payload);
        saleContractRepo.save(entityDo);
        return SaleContractConvert.INSTANCE.toVo(entityDo);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public SaleContractVO update(SaleContractPayload payload) {
        SaleContractDO entity = saleContractRepo.findById(payload.getId()).orElseGet(SaleContractDO::new);
        Assert.notNull(entity.getId(), "合同不存在");
        SaleContractDO entityDo = SaleContractConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SaleContractConvert.INSTANCE.toVo(saleContractRepo.save(entity));
    }

    @Override
    public SaleContractVO queryByKey(Long key) {
        SaleContractDO entity = saleContractRepo.findById(key).orElseGet(SaleContractDO::new);
        Assert.notNull(entity.getId(), "合同不存在");
        return SaleContractConvert.INSTANCE.toVo(entity);
    }

    @Override
    public List<SaleContractVO> queryList(SaleContractQuery query) {
        return SaleContractConvert.INSTANCE.toVoList(saleContractRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Override
    public PagingVO<SaleContractVO> paging(SaleContractQuery query) {
        Page<SaleContractDO> page = saleContractRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(SaleContractConvert.INSTANCE::toVo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            saleContractRepo.deleteSoft(keys);
        }
    }


}
