package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConAchievePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConAchieveQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConAchieveService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Arrays;

/**
 * 业绩统计
 *
 * @author likunpeng
 * @date 2023-04-24
 */
@Api(tags = "业绩统计")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/contract/conAchieve")
@Slf4j
public class ConAchieveController {

    private final ConAchieveService conAchieveService;

    /**
     * 保存
     * @param payload
     * @return r
     */
    @PutMapping("/save")
    @ApiOperation("保存")
    public TwOutputUtil saveAchieve(@RequestBody ConAchievePayload payload){
        return TwOutputUtil.ok(conAchieveService.saveAchieve(payload));
    }

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("新增")
    public TwOutputUtil insert(@RequestBody ConAchievePayload payload){
        return TwOutputUtil.ok(conAchieveService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("更新")
    public TwOutputUtil update(@RequestBody ConAchievePayload payload){
        return TwOutputUtil.ok(conAchieveService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(conAchieveService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ConAchieveQuery query) {
        return TwOutputUtil.ok(conAchieveService.queryPaging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("查询列表")
    public TwOutputUtil queryList(ConAchieveQuery query) {
        return TwOutputUtil.ok(conAchieveService.queryListDynamic(query));
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        conAchieveService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 根据合同ID查询业绩统计
     * @param contractId
     * @return result
     */
    @GetMapping("/achieve/{contractId}")
    @UdcNameClass
    @ApiOperation("根据合同ID查询业绩统计")
    public TwOutputUtil queryByContractId(@PathVariable Long contractId) {
        return TwOutputUtil.ok(conAchieveService.queryByContractId(contractId));
    }

    /**
     * 初始化加载业绩统计
     * @param contractId
     * @return result
     */
    @GetMapping("/initSignAndDeli/{contractId}")
    @UdcNameClass
    @ApiOperation("初始化加载业绩统计")
    public TwOutputUtil initSignAndDeli(@PathVariable Long contractId) {
        return TwOutputUtil.ok(conAchieveService.initSignAndDeli(contractId));
    }

    @PostMapping("/initSignAndDeliDib/{contractId}")
    @UdcNameClass
    @ApiOperation("初始化加载业绩统计迪博")
    public TwOutputUtil initSignAndDeliDib(@PathVariable Long contractId, BigDecimal obversionEffectiveAmt) {
        return TwOutputUtil.ok(conAchieveService.initSignAndDeliDib(contractId,obversionEffectiveAmt));
    }
}
