package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitesland.tw.tw5.api.prd.salecon.query.ConRecvplanChangeLogQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConRecvplanChangeLogService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 收款计划日期变更历史
 */
@Api(tags = "收款计划日期变更历史")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/contract/receivablePlan/changeLog")
@Slf4j
public class ConRecvplanChangeLogController {
    private final ConRecvplanChangeLogService service;

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("分页")
    public TwOutputUtil paging(ConRecvplanChangeLogQuery query) {
        return TwOutputUtil.ok(service.queryPaging(query));
    }
}
