package com.elitesland.tw.tw5.server.prd.salecon.repo;

import com.elitesland.tw.tw5.server.prd.salecon.entity.ConEpibolyCostConDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConEpibolyCostConDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 外包费用确认明细
 *
 * @author likunpeng
 * @date 2023-04-17
 */
public interface ConEpibolyCostConDRepo extends JpaRepository<ConEpibolyCostConDDO, Long>, JpaSpecificationExecutor<ConEpibolyCostConDDO> {

    @Query(value = " select * from con_epiboly_cost_con_d e where e.epiboly_cost_con_id = ?1 and e.doc_type is null and e.document_number is null ", nativeQuery = true)
    List<ConEpibolyCostConDDO> findCostConDDOByID(Long id);

    @Query(value = " select e.id from con_epiboly_cost_con_d e where e.epiboly_cost_con_id = ?1  " +
            " and e.parent_id is not null and e.doc_type is null and e.document_number is null  ", nativeQuery = true)
    List<Long> ifSyncDetail(Long id);

    @Transactional
    @Modifying
    @Query(value = "update ConEpibolyCostConDDO set documentNumber = ?3,docType= ?2 where  id =?1")
    void updateDocTypeAndNo(Long costConDIdV5, String docType, String documentNo);


    ConEpibolyCostConDDO findByCostCondIdV4(Long idV4);
}
