package com.elitesland.tw.tw5.server.prd.schedule.dao;

import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleAttendeesVO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdScheduleAttendeesDO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.QPrdScheduleAttendeesDO;
import com.elitesland.tw.tw5.server.prd.schedule.repo.PrdScheduleAttendeesRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/4/21 - 14:22
 */
@Repository
@RequiredArgsConstructor
public class PrdScheduleAttendeesDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdScheduleAttendeesRepo repo;
    private final QPrdScheduleAttendeesDO qdo = QPrdScheduleAttendeesDO.prdScheduleAttendeesDO;

    /**
     * 拼装查询字段
     * @return  jpaQuery对象
     */
    private JPAQuery<PrdScheduleAttendeesVO> getJpaQuerySelect() {
        JPAQuery<PrdScheduleAttendeesVO> jpaQuery=jpaQueryFactory.select(Projections.bean(PrdScheduleAttendeesVO.class,
                qdo.id,
                qdo.userId,
                qdo.secheduleId
        )).from(qdo);
        return jpaQuery;
    }


    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdScheduleAttendeesDO save(PrdScheduleAttendeesDO ado) {
        return repo.save(ado);
    }

    public List<PrdScheduleAttendeesVO> queryByScheduleId(Long scheduleId) {
        JPAQuery<PrdScheduleAttendeesVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.secheduleId.eq(scheduleId));
        return jpaQuery.fetch();
    }


    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }

}
