package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 数据权限字段
 *
 * @Author Bill
 * @Date 2023/9/25 13:34
 **/
@Entity
@Table(name = "prd_system_permission_field")
@org.hibernate.annotations.Table(appliesTo = "prd_system_permission_field", comment = "数据权限字段")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdSystemPermissionFieldDO extends BaseModel {

    private static final long serialVersionUID = -319231920420774799L;

    @Comment("业务对象主键")
    @Column(name = "object_id")
    private Long objectId;

    @Comment("数据字段")
    @Column()
    private String field;

    @Comment("字段类型")
    @Column(name = "field_type")
    private String fieldType;

    @Comment("字段名称")
    @Column(name = "field_name")
    private String fieldName;

    @Comment("功能对象主键")
    @Column(name = "function_object_id")
    private Long functionObjectId;

    @Comment("属性类型名称")
    @Column(name = "field_type_name")
    private String fieldTypeName;

    @Comment("业务类型")
    @Column(name = "show_type")
    private String showType;

    @Comment("业务类型名称")
    @Column(name = "show_type_name")
    private String showTypeName;

    @Comment("业务属性KEY")
    @Column(name = "show_attr")
    private String showAttr;

    private String mappingField;

}
