package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemGrossMarginPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemGrossMarginQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemGrossMarginService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemGrossMarginVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemGrossMarginConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemGrossMarginDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemGrossMarginDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemGrossMarginRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * 阶梯毛利率设置
 *
 * @author likunpeng
 * @date 2023-04-03
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemGrossMarginServiceImpl extends BaseServiceImpl implements PrdSystemGrossMarginService {

    private final PrdSystemGrossMarginRepo prdSystemGrossMarginRepo;
    private final PrdSystemGrossMarginDAO prdSystemGrossMarginDAO;

    @Override
    public PagingVO<PrdSystemGrossMarginVO> paging(PrdSystemGrossMarginQuery query) {
        Page<PrdSystemGrossMarginDO> page = prdSystemGrossMarginRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(PrdSystemGrossMarginConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<PrdSystemGrossMarginVO> queryPaging(PrdSystemGrossMarginQuery query) {
        return prdSystemGrossMarginDAO.queryPaging(query);
    }

    @Override
    public List<PrdSystemGrossMarginVO> queryList(PrdSystemGrossMarginQuery query) {
        return PrdSystemGrossMarginConvert.INSTANCE.toVoList(
                prdSystemGrossMarginRepo.findAll(
                        (root, criteriaQuery, criteriaBuilder)
                                -> QueryHelp.getPredicate(root, query, criteriaBuilder)
                        , query.getPageRequest().getSort()
                )
        );
    }

    @Override
    public List<PrdSystemGrossMarginVO> queryListDynamic(PrdSystemGrossMarginQuery query) {
        return prdSystemGrossMarginDAO.queryListDynamic(query);
    }

    @Override
    public PrdSystemGrossMarginVO queryByKey(Long key) {
        PrdSystemGrossMarginDO entity = prdSystemGrossMarginRepo.findById(key).orElseGet(PrdSystemGrossMarginDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemGrossMarginVO vo = PrdSystemGrossMarginConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemGrossMarginVO insert(PrdSystemGrossMarginPayload payload) {
        PrdSystemGrossMarginDO entityDo = PrdSystemGrossMarginConvert.INSTANCE.toDo(payload);
        //毛利率大小判断
        judge(payload);
        judgeNull(payload);
        //该BU在该年度已设置合同金额及毛利率！
        PrdSystemGrossMarginQuery query = new PrdSystemGrossMarginQuery();
        query.setBuId(payload.getBuId());
        query.setYearly(payload.getYearly());
        List<PrdSystemGrossMarginVO> vos = this.queryListDynamic(query);
        if (vos.size() != 0) {
            throw TwException.error("", "该BU在该年度已设置合同金额及毛利率！");
        }
        return PrdSystemGrossMarginConvert.INSTANCE.toVo(prdSystemGrossMarginRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdSystemGrossMarginVO update(PrdSystemGrossMarginPayload payload) {
        PrdSystemGrossMarginDO entity = prdSystemGrossMarginRepo.findById(payload.getId()).orElseGet(PrdSystemGrossMarginDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdSystemGrossMarginDO entityDo = PrdSystemGrossMarginConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        //毛利率大小判断
        judge(payload);
        judgeNull(payload);
        //该BU在该年度已设置合同金额及毛利率！
        PrdSystemGrossMarginQuery query = new PrdSystemGrossMarginQuery();
        query.setBuId(payload.getBuId());
        query.setYearly(payload.getYearly());
        List<PrdSystemGrossMarginVO> vos = this.queryListDynamic(query);
        if (vos.size() != 0) {
            if (vos.get(0).getId().equals(payload.getId())) {
                return PrdSystemGrossMarginConvert.INSTANCE.toVo(prdSystemGrossMarginRepo.save(entity));
            }
            throw TwException.error("", "该BU在该年度已设置合同金额及毛利率！");
        }
        return PrdSystemGrossMarginConvert.INSTANCE.toVo(prdSystemGrossMarginRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdSystemGrossMarginDAO.deleteSoft(keys);
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(Long key) {
        prdSystemGrossMarginDAO.deleteSoft(Collections.singletonList(key));
    }

    //非空校验
    public void judgeNull(PrdSystemGrossMarginPayload payload) {
        if (payload.getYearly() == null || payload.getBuGrossMargin() == null || payload.getLadderGrossMargin1() == null || payload.getLadderGrossMargin2() == null || payload.getAmt() == null || payload.getBuDirectorId() == null || payload.getBuId() == null || payload.getLadderDirectorId1() == null || payload.getLadderDirectorId2() == null) {
            throw TwException.error("", "请检查是否有字段为空！");
        }
    }

    //毛利率大小判断
    public void judge(PrdSystemGrossMarginPayload payload) {
        Optional.ofNullable(payload.getBuGrossMargin()).ifPresent(m -> {
            Optional.ofNullable(payload.getLadderGrossMargin1()).ifPresent(m1 -> {
                if (m < m1)
                    throw TwException.warn("", "BU毛利率应大于阶梯毛利率1");
                Optional.ofNullable(payload.getLadderGrossMargin2()).ifPresent(m2 -> {
                    if (m1 < m2)
                        throw TwException.warn("", "阶梯毛利率1应大于阶梯毛利率2");
                });
            });
        });
    }
}
