package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemTagPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemTagQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemTagService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdSystemTagConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemTagDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemTagDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 系统选择项service
 *
 * @author wangding
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemTagServiceImpl implements PrdSystemTagService {
    private final PrdSystemTagDAO dao;
    private final CacheUtil cacheUtil;

    @Transactional
    @Override
    public PrdSystemTagVO insert(PrdSystemTagPayload payload) {
        payload.setTagKey(payload.getTagKey().trim());

        // 检查编码不能重复
        PrdSystemTagQuery query = new PrdSystemTagQuery();
        query.setTagKey(payload.getTagKey());
        int count = dao.queryListDynamic(query).size();
        if (count > 0) {
            throw TwException.error("", "编号不可重复");
        }
        PrdSystemTagDO ado = PrdSystemTagConvert.INSTANCE.toDo(payload);
        dao.save(ado);
        cacheUtil.loadSystemTagCache();
        return PrdSystemTagConvert.INSTANCE.toVo(ado);
    }

    @Transactional
    @Override
    public Long update(PrdSystemTagPayload payload) {
        if (payload.getTagKey() != null) {
            payload.setTagKey(payload.getTagKey().trim());
            PrdSystemTagQuery query = new PrdSystemTagQuery();
            query.setTagKey(payload.getTagKey());
            query.setId(payload.getId());
            int count = dao.queryListDynamic(query).size();
            if (count > 0) {
                throw TwException.error("", "编号不可重复");
            }
        }

        dao.updateByKeyDynamic(payload);
        cacheUtil.loadSystemTagCache();
        return 0L;
    }

    @Transactional
    @Override
    public boolean delete(List<Long> keys) {
        dao.delete(keys);
        cacheUtil.loadSystemTagCache();
        return true;
    }

    @Transactional
    @Override
    public boolean deleteSoft(List<Long> keys) {
        dao.deleteSoft(keys);
        cacheUtil.loadSystemTagCache();
        return true;
    }

    @Override
    public PrdSystemTagVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    public PagingVO<PrdSystemTagVO> paging(PrdSystemTagQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public void clearCache() {
        cacheUtil.loadSystemTagCache();
    }

    @Override
    public List<PrdSystemTagVO> queryList(PrdSystemTagQuery query) {
        List<PrdSystemTagVO> tagVOS = new ArrayList<>();
        cacheUtil.getSystemTag(null).forEach(tagVO -> {
            boolean isData = tagVO.getEnabled();
            if (isData && query.getFunctionId() != null) {
                if (query.getFunctionId().longValue() != tagVO.getFunctionId().longValue()) {
                    isData = false;
                }
            }
            if (isData && query.getSceneNo() != null) {
                if (!query.getSceneNo().equals(tagVO.getSceneNo())) {
                    isData = false;
                }
            }
            if (isData && query.getTagColor() != null) {
                if (!query.getTagColor().equals(tagVO.getTagColor())) {
                    isData = false;
                }
            }
            if (isData) {
                tagVOS.add(tagVO);
            }
        });
        return tagVOS;
    }
}
