package com.elitesland.tw.tw5.server.prd.ts.dao;


import com.elitesland.tw.tw5.api.prd.ts.payload.TsNotaskApprovalConfigPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsNotaskApprovalConfigQuery;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsNotaskApprovalConfigVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.ts.entity.QTsNotaskApprovalConfigDO;
import com.elitesland.tw.tw5.server.prd.ts.entity.TsNotaskApprovalConfigDO;
import com.elitesland.tw.tw5.server.prd.ts.repo.TsNotaskApprovalConfigRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * notask_config
 *
 * @author zoey
 * @date 2024-04-30
 */
@Repository
@RequiredArgsConstructor
public class TsNotaskApprovalConfigDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final TsNotaskApprovalConfigRepo repo;
    private final QTsNotaskApprovalConfigDO qdo = QTsNotaskApprovalConfigDO.tsNotaskApprovalConfigDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<TsNotaskApprovalConfigVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(TsNotaskApprovalConfigVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 工时年度
                qdo.tsYear,
                // 事业部id
                qdo.deliBuId,
                // 状态:1 有效；0 无效
                qdo.effective
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<TsNotaskApprovalConfigVO> getJpaQueryWhere(TsNotaskApprovalConfigQuery query) {
        JPAQuery<TsNotaskApprovalConfigVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(TsNotaskApprovalConfigQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(TsNotaskApprovalConfigQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 工时年度 精确 */
        if (!ObjectUtils.isEmpty(query.getTsYear())) {
            list.add(qdo.tsYear.eq(query.getTsYear()));
        }
        /** 事业部id 精确 */
        if (!ObjectUtils.isEmpty(query.getDeliBuId())) {
            list.add(qdo.deliBuId.eq(query.getDeliBuId()));
        }
        /** 状态:1 有效；0 无效 精确 */
        if (!ObjectUtils.isEmpty(query.getEffective())) {
            list.add(qdo.effective.eq(query.getEffective()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public TsNotaskApprovalConfigVO queryByKey(Long id) {
        JPAQuery<TsNotaskApprovalConfigVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<TsNotaskApprovalConfigVO> queryListDynamic(TsNotaskApprovalConfigQuery query) {
        JPAQuery<TsNotaskApprovalConfigVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<TsNotaskApprovalConfigVO> queryPaging(TsNotaskApprovalConfigQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<TsNotaskApprovalConfigVO> jpaQuery = getJpaQueryWhere(query);
        List<TsNotaskApprovalConfigVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<TsNotaskApprovalConfigVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public TsNotaskApprovalConfigDO save(TsNotaskApprovalConfigDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<TsNotaskApprovalConfigDO> saveAll(List<TsNotaskApprovalConfigDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(TsNotaskApprovalConfigPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 工时年度
        if (payload.getTsYear() != null) {
            update.set(qdo.tsYear, payload.getTsYear());
        }
        // 事业部id
        if (payload.getDeliBuId() != null) {
            update.set(qdo.deliBuId, payload.getDeliBuId());
        }
        // 状态:1 有效；0 无效
        if (payload.getEffective() != null) {
            update.set(qdo.effective, payload.getEffective());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 工时年度
            if (nullFields.contains("tsYear")) {
                update.setNull(qdo.tsYear);
            }
            // 事业部id
            if (nullFields.contains("deliBuId")) {
                update.setNull(qdo.deliBuId);
            }
            // 状态:1 有效；0 无效
            if (nullFields.contains("effective")) {
                update.setNull(qdo.effective);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

