package com.elitesland.tw.tw5.server.prd.work.service;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentHistoryPayload;
import com.elitesland.tw.tw5.api.prd.work.payload.PrdWorkAssignmentPayload;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentHistoryQuery;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.work.service.PrdWorkAssignmentHistoryService;
import com.elitesland.tw.tw5.api.prd.work.service.PrdWorkAssignmentService;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentHistoryVO;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentVO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.work.convert.PrdWorkAssignmentConvert;
import com.elitesland.tw.tw5.server.prd.work.dao.PrdWorkAssignmentDAO;
import com.elitesland.tw.tw5.server.prd.work.entity.PrdWorkAssignmentDO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Lemon
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdWorkAssignmentServiceImpl extends BaseServiceImpl implements PrdWorkAssignmentService {
    private final PrdWorkAssignmentDAO dao;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdWorkAssignmentHistoryService historyService;
    private final CacheUtil cacheUtil;
    private final FileUtil fileUtil;
//    // @DubboReference(version = "${provider.service.version}")
//    private SysUserRpcService sysUserService;

    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
    //private SysNumberRuleService numberRuleService;

    @Override
    @Transactional
    public PrdWorkAssignmentVO insert(PrdWorkAssignmentPayload payload) {
        payload.setAssignmentStatus("create");
        // 生成编号
        payload.setAssignmentNo(generateSeqNum("AS"));
        PrdWorkAssignmentDO ado = PrdWorkAssignmentConvert.INSTANCE.toDo(payload);
        ado = dao.save(ado);
        // ------------指派记录--------
        // 获取当前登录用户
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
        historyPayload.setAssignmentId(ado.getId());
        historyPayload.setOperationTitle("由" + current.getFirstName() + "创建。");
        historyService.insert(historyPayload);
        return PrdWorkAssignmentConvert.INSTANCE.toVo(ado);
    }

    @Override
    @Transactional
    public Long updateByKeyDynamic(PrdWorkAssignmentPayload payload) {

        // ------------指派记录--------
        PrdWorkAssignmentVO oldWorkAssignment = queryByKey(payload.getId());
        PrdWorkAssignmentVO newWorkAssignment = PrdWorkAssignmentConvert.INSTANCE.toVo(payload);
        transaction(Collections.singletonList(newWorkAssignment));
        PrdWorkAssignmentHistoryPayload historyPayload = getUpdateHistory(oldWorkAssignment, newWorkAssignment);
        long result = dao.updateByKeyDynamic(payload);
        // 保存
        historyService.insert(historyPayload);
        return result;
    }

    /**
     * 对比数据，添加记录
     *
     * @param oldWorkAssignment
     * @param newWorkAssignment
     * @return
     */
    private PrdWorkAssignmentHistoryPayload getUpdateHistory(PrdWorkAssignmentVO oldWorkAssignment, PrdWorkAssignmentVO newWorkAssignment) {

        // 获取当前登录用户
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
        historyPayload.setAssignmentId(oldWorkAssignment.getId());
        StringBuilder sb = new StringBuilder();
//        if (!ObjectUtils.isEmpty(payload.getAssignmentNo())) {
//            sb.append()
//        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getAssignmentName())) {
            String oldAssignmentName = StringUtils.hasText(oldWorkAssignment.getAssignmentName()) ? oldWorkAssignment.getAssignmentName() : "";
            sb.append("修改了名称，旧值为”" + oldAssignmentName + "”，新值为“" + newWorkAssignment.getAssignmentName() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getPriority())) {
            String oldPriorityDesc = StringUtils.hasText(oldWorkAssignment.getPriorityDesc()) ? oldWorkAssignment.getPriorityDesc() : "";

            sb.append("修改了优先级，旧值为”" + oldPriorityDesc + "”，新值为“" + newWorkAssignment.getPriorityDesc() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getAssignUserId())) {
            String oldAssignUserIdDesc = StringUtils.hasText(oldWorkAssignment.getAssignUserIdDesc()) ? oldWorkAssignment.getAssignUserIdDesc() : "";
            sb.append("修改了指派人，旧值为”" + oldAssignUserIdDesc + "”，新值为“" + newWorkAssignment.getAssignUserIdDesc() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getAssistUserIds())) {
            String oldAssistUserIdsDesc = StringUtils.hasText(oldWorkAssignment.getAssistUserIdsDesc()) ? oldWorkAssignment.getAssistUserIdsDesc() : "";
            sb.append("修改了协助人，旧值为”" + oldAssistUserIdsDesc + "”，新值为“" + newWorkAssignment.getAssistUserIdsDesc() + "”;");
        }
        if (StringUtils.hasText(newWorkAssignment.getAssignmentType())) {
            String oldAssignmentTypeDesc = StringUtils.hasText(oldWorkAssignment.getAssignmentTypeDesc()) ? oldWorkAssignment.getAssignmentTypeDesc() : "";
            sb.append("修改了类型，旧值为”" + oldAssignmentTypeDesc + "”，新值为“" + newWorkAssignment.getAssignmentTypeDesc() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getStartDate())) {
            String oldStartDate = ObjectUtils.isEmpty(oldWorkAssignment.getStartDate()) ? "" : oldWorkAssignment.getStartDate().toString();
            sb.append("修改了开始时间，旧值为”" + oldStartDate + "”，新值为“" + newWorkAssignment.getStartDate() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getFinishDate())) {
            String oldFinishDate = ObjectUtils.isEmpty(oldWorkAssignment.getFinishDate()) ? "" : oldWorkAssignment.getFinishDate().toString();
            sb.append("修改了完成时间，旧值为”" + oldFinishDate + "”，新值为“" + newWorkAssignment.getFinishDate() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getActualStartDate())) {
            String oldActualStartDate = ObjectUtils.isEmpty(oldWorkAssignment.getActualStartDate()) ? "" : oldWorkAssignment.getActualStartDate().toString();
            sb.append("修改了实际开始时间，旧值为”" + oldActualStartDate + "”，新值为“" + newWorkAssignment.getActualStartDate() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getAssignmentStatus())) {

            sb.append("修改了状态，旧值为”" + oldWorkAssignment.getAssignmentStatusDesc() + "”，新值为“" + newWorkAssignment.getAssignmentStatusDesc() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getActualFinishDate())) {
            String oldActualFinishDate = ObjectUtils.isEmpty(oldWorkAssignment.getActualFinishDate()) ? "" : oldWorkAssignment.getActualFinishDate().toString();
            sb.append("修改了实际完成时间，旧值为”" + oldActualFinishDate + "”，新值为“" + newWorkAssignment.getActualFinishDate() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getFinishUserId())) {
            String oldFinishUserIdDesc = StringUtils.hasText(oldWorkAssignment.getFinishUserIdDesc()) ? oldWorkAssignment.getFinishUserIdDesc() : "";
            sb.append("修改了完成人，旧值为”" + oldFinishUserIdDesc + "”，新值为“" + newWorkAssignment.getFinishUserIdDesc() + "”;");
        }

        if (!ObjectUtils.isEmpty(newWorkAssignment.getProgress())) {
            String oldProgressDesc = ObjectUtils.isEmpty(oldWorkAssignment.getProgress()) ? "" : oldWorkAssignment.getProgress().toString();
            sb.append("修改了进度，旧值为”" + oldProgressDesc + "”，新值为“" + newWorkAssignment.getProgress() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getAssignmentDesc())) {
            String oldAssignmentDesc = ObjectUtils.isEmpty(oldWorkAssignment.getAssignmentDesc()) ? "" : oldWorkAssignment.getAssignmentDesc();
            sb.append("修改了任务描述，旧值为”" + oldAssignmentDesc + "”，新值为“" + newWorkAssignment.getAssignmentDesc() + "”;");
        }
        if (!ObjectUtils.isEmpty(newWorkAssignment.getFileCodes())) {
            sb.append("修改了附件;");
        }
        if (StringUtils.hasText(String.valueOf(sb))) {
            historyPayload.setOperationTitle("由" + current.getFirstName() + "编辑。");
            historyPayload.setRemark(String.valueOf(sb));
        }

        return historyPayload;
    }


    @Override
    public PagingVO<PrdWorkAssignmentVO> paging(PrdWorkAssignmentQuery query) {
        PagingVO<PrdWorkAssignmentVO> pagingVO = dao.queryPaging(query);
        List<PrdWorkAssignmentVO> assignmentVOS = pagingVO.getRecords();
        transaction(assignmentVOS);
        return pagingVO;
    }

    @Override
    public PrdWorkAssignmentVO queryByKey(Long key) {
        PrdWorkAssignmentVO prdWorkAssignmentVO = dao.queryByKey(key);
        PrdWorkAssignmentHistoryQuery query = new PrdWorkAssignmentHistoryQuery();
        query.setAssignmentId(key);
        OrderItem orderItem = new OrderItem();
        orderItem.setColumn("createTime");
        orderItem.setAsc(true);
        query.setOrders(Collections.singletonList(orderItem));
        List<PrdWorkAssignmentHistoryVO> historyVOS = historyService.queryList(query);
        prdWorkAssignmentVO.setAssignmentHistoryList(historyVOS);
        transaction(Collections.singletonList(prdWorkAssignmentVO));
        prdWorkAssignmentVO.setFileDatas(fileUtil.getFileDatas(prdWorkAssignmentVO.getFileCodes()));
        return prdWorkAssignmentVO;
    }

    @Override
    @Transactional
    public Boolean pending(List<Long> keys) {
        dao.updateAssignmentStatusByIds(keys, "pending");
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        List saveHistoryList = new ArrayList<>();
        for (Long key : keys) {
            PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
            historyPayload.setAssignmentId(key);
            historyPayload.setOperationTitle("由" + current.getFirstName() + "暂挂。");
            saveHistoryList.add(historyPayload);
        }
        historyService.insertAll(saveHistoryList);
        return true;
    }

    @Override
    @Transactional
    public Boolean start(List<Long> keys) {
        dao.updateAssignmentStatusByIds(keys, "execution");
        dao.updateActualStartDateByIds(keys, LocalDate.now());
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        List saveHistoryList = new ArrayList<>();
        for (Long key : keys) {
            PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
            historyPayload.setAssignmentId(key);
            historyPayload.setOperationTitle("由" + current.getFirstName() + "启动。");
            saveHistoryList.add(historyPayload);
        }
        historyService.insertAll(saveHistoryList);
        return true;
    }

    @Override
    @Transactional
    public Boolean finish(List<Long> keys) {
        dao.updateAssignmentStatusByIds(keys, "finish");
        dao.updateActualFinishDateByIds(keys, LocalDate.now());
        dao.updateProgressByIds(keys, 100);
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        dao.updateFinishUserById(keys, current.getId());
        List saveHistoryList = new ArrayList<>();
        for (Long key : keys) {
            PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
            historyPayload.setAssignmentId(key);
            historyPayload.setOperationTitle("由" + current.getFirstName() + "完成。");
            saveHistoryList.add(historyPayload);
        }
        historyService.insertAll(saveHistoryList);
        return true;
    }

    @Override
    @Transactional
    public Boolean close(List<Long> keys) {
        dao.updateAssignmentStatusByIds(keys, "close");
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        SysUserDTO current = user.getUser();
        List saveHistoryList = new ArrayList<>();
        for (Long key : keys) {
            PrdWorkAssignmentHistoryPayload historyPayload = new PrdWorkAssignmentHistoryPayload();
            historyPayload.setAssignmentId(key);
            historyPayload.setOperationTitle("由" + current.getFirstName() + "关闭。");
            saveHistoryList.add(historyPayload);
        }
        historyService.insertAll(saveHistoryList);
        return true;
    }

    @Override
    public List<PrdWorkAssignmentVO> queryList(PrdWorkAssignmentQuery query) {
        List<PrdWorkAssignmentVO> voList = dao.queryListDynamic(query);
        transaction(voList);
        return voList;
    }

    @Override
    @Transactional
    public boolean deleteSoft(List<Long> keys) {
        dao.deleteSoft(keys);
        return true;
    }

    private void transaction(List<PrdWorkAssignmentVO> list) {
        // 查询人员信息
        List<Long> userIdList = new ArrayList<>();
        list.stream().forEach(e -> {
            if (!ObjectUtils.isEmpty(e.getFinishUserId())) {
                userIdList.add(e.getFinishUserId());
            }
            if (!ObjectUtils.isEmpty(e.getAssignUserId())) {
                userIdList.add(e.getAssignUserId());
            }
            if (StringUtils.hasText(e.getAssistUserIds())) {
                String[] assistUserIdsSplit = e.getAssistUserIds().split(",");
                for (String userId : assistUserIdsSplit) {
                    userIdList.add(Long.valueOf(userId));
                }
            }
            if (!ObjectUtils.isEmpty(e.getCreateUserId())) {
                e.setCreateUserName(cacheUtil.getUserName(e.getCreateUserId()));
            }
        });
        List<PrdOrgEmployeeVO> employeeVOS = employeeDAO.queryMobileList(userIdList);
        //     List<SysUserVO> sysUserVOS = sysUserService.getByIds(userIdList);
        Map<Long, PrdOrgEmployeeVO> sysUserVOMap = employeeVOS.stream().collect(Collectors.toMap(PrdOrgEmployeeVO::getUserId, Function.identity()));

        for (PrdWorkAssignmentVO vo : list) {
            // 状态
            vo.setAssignmentStatusDesc(cacheUtil.transferSystemSelection("work:assignment:assignment_status", vo.getAssignmentStatus()));
            // 优先级
            vo.setPriorityDesc(cacheUtil.transferSystemSelection("work:assignment:priority", vo.getPriority()));
            //类型
            vo.setAssignmentTypeDesc(cacheUtil.transferSystemSelection("work:assignment:assignment_type", vo.getAssignmentType()));
            // 完成人
            if (!ObjectUtils.isEmpty(vo.getFinishUserId())) {
                PrdOrgEmployeeVO sysUser = sysUserVOMap.get(vo.getFinishUserId());
                if (!ObjectUtils.isEmpty(sysUser)) {
                    vo.setFinishUserIdDesc(sysUser.getEmployeeName());
                }
            }
            // 指派人
            if (!ObjectUtils.isEmpty(vo.getAssignUserId())) {
                PrdOrgEmployeeVO sysUser = sysUserVOMap.get(vo.getAssignUserId());
                if (!ObjectUtils.isEmpty(sysUser)) {
                    vo.setAssignUserIdDesc(sysUser.getEmployeeName());
                }
            }
            // 协助人
            String assistUserIds = vo.getAssistUserIds();
            if (StringUtils.hasText(assistUserIds)) {
                String[] assistUserIdsSplit = assistUserIds.split(",");
                Set<String> assistUserIdsDesc = new HashSet<>();
                for (String userId : assistUserIdsSplit) {
                    PrdOrgEmployeeVO sysUser = sysUserVOMap.get(Long.valueOf(userId));
                    if (!ObjectUtils.isEmpty(sysUser)) {
                        assistUserIdsDesc.add(sysUser.getEmployeeName());
                    }
                }
                vo.setAssistUserIdsDesc(String.join(",", assistUserIdsDesc));
            }
        }
    }
}
