package com.elitesland.tw.tw5.server.prd.workflow;

import com.alibaba.fastjson.JSON;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActActivityConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.OvertimeApplicationDO;
import com.elitesland.tw.tw5.server.prd.work.dao.OvertimeApplicationDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/**
 * @author yangzhibin
 * @date 2022/12/16
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "OVERTIME_APPLICATION" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class OvertimeApplicationWorkflowCallBackController implements WorkflowCallBack {

    private final OvertimeApplicationDAO overtimeApplicationDAO;

    /**
     * 动态指定任务负责人
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     *
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     *
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();

        String approve_status = null;
        switch (procInstStatus) {
            case NOTSUBMIT://创建人提交节点
                approve_status = WorkFlowStatusEnum.NOTSUBMIT.getCode();
                break;
            case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                break;
            case INVALID://先删除流程再删除单据
                approve_status = WorkFlowStatusEnum.INVALID.getCode();
                break;
            case REJECTED://审批人拒绝，回到第一个节点
                approve_status = WorkFlowStatusEnum.REJECTED_WORK.getCode();
                break;
            case APPROVED:
                approve_status = WorkFlowStatusEnum.APPROVED.getCode();
                break;
            case APPROVING:
                approve_status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
                break;
        }
        overtimeApplicationDAO.updateStatusById(approve_status, Long.valueOf(businessKey));
        return WorkflowResult.success(null);
    }

}
