/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    public static final String formulasReplace = ":rowNo";

    public static void writeResponse(HttpServletResponse response, String fileName, Workbook workbook) {
        try {
            ServletOutputStream servletOutputStream = response.getOutputStream();
            response.setContentType("application/vnd.ms-excel");
            fileName = URLEncoder.encode(fileName, "utf-8");
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + ".xls\"");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
            workbook.write((OutputStream)servletOutputStream);
            bufferedOutputStream.flush();
            servletOutputStream.close();
            bufferedOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
    }

    public static String getCellFormatValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellTypeEnum();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        StringBuffer cellValue = new StringBuffer();
        switch (cellType) {
            case STRING: {
                cellValue = new StringBuffer(cell.getStringCellValue());
                break;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    cellValue = new StringBuffer(df.format(cell.getDateCellValue()));
                    break;
                }
                cellValue = new StringBuffer(NumberToTextConverter.toText((double)cell.getNumericCellValue()));
                break;
            }
            case BLANK: 
            case ERROR: {
                cellValue = new StringBuffer();
                break;
            }
            case BOOLEAN: {
                cellValue = new StringBuffer(String.valueOf(cell.getBooleanCellValue()));
                break;
            }
            case FORMULA: {
                cell.setCellType(CellType.STRING);
                cellValue = new StringBuffer(cell.getStringCellValue());
                if (!"#N/A".equals(cellValue.toString())) break;
                cellValue = new StringBuffer("");
                break;
            }
        }
        return cellValue.toString().trim();
    }

    public Cell setCellValue(Row row, int column, Object value) {
        Cell cell = row.createCell(column);
        if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else {
            cell.setCellValue(value == null ? "" : value.toString());
        }
        return cell;
    }

    public Cell setCellValueAndStyle(Row row, CellStyle style, int column, Object value) {
        Cell cell = row.createCell(column);
        if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else {
            cell.setCellValue(value == null ? "" : value.toString());
        }
        cell.setCellStyle(style);
        return cell;
    }

    public Cell setCellValueNew(Row row, int column, Object value) {
        Cell cell = row.getCell(column);
        if (cell == null) {
            cell = row.createCell(column);
        }
        if (value instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)value).doubleValue());
        } else {
            cell.setCellValue(value == null ? "" : value.toString());
        }
        return cell;
    }

    public String replaceFormulasRowNo(String formulas, int rowNo) {
        return formulas.replaceAll(formulasReplace, "" + rowNo);
    }

    public Cell setCellFormulas(Row row, int column, String formulas) {
        Cell cell = row.createCell(column);
        cell.setCellFormula(this.replaceFormulasRowNo(formulas, row.getRowNum() + 1));
        return cell;
    }

    public void setColumnFormulas(XSSFSheet sheet, int column, String formulas) {
        for (int i = 1; i < 1000; ++i) {
            XSSFRow row = sheet.getRow(i);
            if (row == null) {
                row = sheet.createRow(i);
            }
            Cell cell = row.createCell(column);
            cell.setCellFormula(this.replaceFormulasRowNo(formulas, row.getRowNum() + 1));
        }
    }

    public void generateRangeList(XSSFSheet sheet, int column, int startRow, String validDataSheetName, int validStartRow, String validColStr) {
        String strFormula = validDataSheetName + "!$" + validColStr + "$" + validStartRow + ":$" + validColStr + "$65535";
        XSSFDataValidationConstraint constraint = new XSSFDataValidationConstraint(3, strFormula);
        CellRangeAddressList regions = new CellRangeAddressList(startRow, 65535, column, column);
        XSSFDataValidationHelper help = new XSSFDataValidationHelper(sheet);
        DataValidation validation = help.createValidation((DataValidationConstraint)constraint, regions);
        sheet.addValidationData(validation);
    }

    public void generateRangeMultipleChoice(XSSFSheet sheet, int column, int startRow, String validDataSheetName, int validStartRow, String validColStr) {
        String strFormula = validDataSheetName + "!$" + validColStr + "$" + validStartRow + ":$" + validColStr + "$65535";
        XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(sheet);
        String[] strs = new String[]{"A", "B", "C"};
        XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(strs);
        XSSFDataValidationConstraint constraint = new XSSFDataValidationConstraint(3, strFormula);
        CellRangeAddressList regions = new CellRangeAddressList(startRow, 65535, column, column);
        DataValidation validation = dvHelper.createValidation((DataValidationConstraint)dvConstraint, regions);
        validation.setSuppressDropDownArrow(true);
        validation.setShowErrorBox(true);
        sheet.addValidationData(validation);
    }

    public void insertLOVdata(Sheet lovSheet, List<PrdSystemSelectionVO> data, int columnNum) {
        if (!CollectionUtils.isEmpty(data) && lovSheet != null) {
            int nextRow = 1;
            for (PrdSystemSelectionVO selection : data) {
                String selectionValue = selection.getSelectionValue();
                String selectionName = selection.getSelectionName();
                if (!StringUtils.hasText((String)selectionName) || selectionValue == null) continue;
                Row row = lovSheet.getRow(nextRow);
                if (row == null) {
                    row = lovSheet.createRow(nextRow);
                }
                this.setCellValue(row, columnNum, selectionName);
                this.setCellValue(row, columnNum + 1, selectionValue);
                ++nextRow;
            }
        }
    }

    public void insertListData(Sheet listSheet, List<? extends Object> data, String valueAttributeName, String nameAttributeName, int columnNum) {
        if (!CollectionUtils.isEmpty(data) && listSheet != null) {
            int nextRow = 1;
            for (Object object : data) {
                Object selectionValue = BeanUtil.getAllFieldValueByFieldName(valueAttributeName, object);
                Object selectionName = BeanUtil.getAllFieldValueByFieldName(nameAttributeName, object);
                if (selectionName == null || selectionValue == null) continue;
                Row row = listSheet.getRow(nextRow);
                if (row == null) {
                    row = listSheet.createRow(nextRow);
                }
                this.setCellValue(row, columnNum, selectionName);
                this.setCellValue(row, columnNum + 1, "" + selectionValue);
                ++nextRow;
            }
        }
    }

    public static File workbookToFile(Workbook wb, String name) {
        File toFile = null;
        try {
            toFile = File.createTempFile(name, ".xlsx");
            FileOutputStream os = new FileOutputStream(toFile);
            wb.write((OutputStream)os);
            ((OutputStream)os).close();
            return toFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return toFile;
        }
    }
}

