/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common;

import com.elitesland.tw.tw5.api.common.annotation.Query;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class QueryHelp {
    private static final Logger log = LoggerFactory.getLogger(QueryHelp.class);

    public static <R, Q> Predicate getPredicate(Root<R> root, Q query, CriteriaBuilder cb) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        if (query == null) {
            return cb.and(list.toArray(new Predicate[0]));
        }
        try {
            List<Field> fields = QueryHelp.getAllFields(query.getClass(), new ArrayList<Field>());
            for (Field field : fields) {
                boolean accessible = field.isAccessible();
                field.setAccessible(true);
                Query q = field.getAnnotation(Query.class);
                if (q != null) {
                    String propName = q.propName();
                    String joinName = q.joinName();
                    String blurry = q.blurry();
                    String attributeName = QueryHelp.isBlank(propName) ? field.getName() : propName;
                    Class<?> fieldType = field.getType();
                    Object val = field.get(query);
                    if (ObjectUtils.isEmpty((Object)val)) continue;
                    Join join = null;
                    if (StringUtils.hasText((String)blurry)) {
                        String[] blurrys = blurry.split(",");
                        ArrayList<Predicate> orPredicate = new ArrayList<Predicate>();
                        String[] stringArray = blurrys;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String s = stringArray[i];
                            orPredicate.add(cb.like(root.get(s).as(String.class), "%" + val.toString() + "%"));
                        }
                        Predicate[] p = new Predicate[orPredicate.size()];
                        list.add(cb.or(orPredicate.toArray(p)));
                        continue;
                    }
                    if (StringUtils.hasText((String)joinName)) {
                        String[] joinNames;
                        block24: for (String name : joinNames = joinName.split(">")) {
                            switch (q.join()) {
                                case LEFT: {
                                    if (!ObjectUtils.isEmpty(join) && !ObjectUtils.isEmpty((Object)val)) {
                                        join = join.join(name, JoinType.LEFT);
                                        continue block24;
                                    }
                                    join = root.join(name, JoinType.LEFT);
                                    continue block24;
                                }
                                case RIGHT: {
                                    if (!ObjectUtils.isEmpty(join) && !ObjectUtils.isEmpty((Object)val)) {
                                        join = join.join(name, JoinType.RIGHT);
                                        continue block24;
                                    }
                                    join = root.join(name, JoinType.RIGHT);
                                    continue block24;
                                }
                                case INNER: {
                                    if (!ObjectUtils.isEmpty(join) && !ObjectUtils.isEmpty((Object)val)) {
                                        join = join.join(name, JoinType.INNER);
                                        continue block24;
                                    }
                                    join = root.join(name, JoinType.INNER);
                                    continue block24;
                                }
                            }
                        }
                    }
                    switch (q.type()) {
                        case EQUAL: {
                            list.add(cb.equal(QueryHelp.getExpression(attributeName, join, root).as(fieldType), val));
                            break;
                        }
                        case GREATER_THAN: {
                            list.add(cb.greaterThanOrEqualTo(QueryHelp.getExpression(attributeName, join, root).as(fieldType), (Comparable)val));
                            break;
                        }
                        case LESS_THAN: {
                            list.add(cb.lessThanOrEqualTo(QueryHelp.getExpression(attributeName, join, root).as(fieldType), (Comparable)val));
                            break;
                        }
                        case LESS_THAN_NQ: {
                            list.add(cb.lessThan(QueryHelp.getExpression(attributeName, join, root).as(fieldType), (Comparable)val));
                            break;
                        }
                        case INNER_LIKE: {
                            list.add(cb.like(QueryHelp.getExpression(attributeName, join, root).as(String.class), "%" + val.toString() + "%"));
                            break;
                        }
                        case LEFT_LIKE: {
                            list.add(cb.like(QueryHelp.getExpression(attributeName, join, root).as(String.class), "%" + val.toString()));
                            break;
                        }
                        case RIGHT_LIKE: {
                            list.add(cb.like(QueryHelp.getExpression(attributeName, join, root).as(String.class), val.toString() + "%"));
                            break;
                        }
                        case IN: {
                            if (CollectionUtils.isEmpty((Collection)((Collection)val))) break;
                            list.add(QueryHelp.getExpression(attributeName, join, root).in((Collection)val));
                            break;
                        }
                        case NOT_IN: {
                            if (CollectionUtils.isEmpty((Collection)((Collection)val))) break;
                            list.add(QueryHelp.getExpression(attributeName, join, root).in((Collection)val).not());
                            break;
                        }
                        case NOT_EQUAL: {
                            list.add(cb.notEqual(QueryHelp.getExpression(attributeName, join, root), val));
                            break;
                        }
                        case NOT_NULL: {
                            list.add(cb.isNotNull(QueryHelp.getExpression(attributeName, join, root)));
                            break;
                        }
                        case IS_NULL: {
                            list.add(cb.isNull(QueryHelp.getExpression(attributeName, join, root)));
                            break;
                        }
                        case BETWEEN: {
                            ArrayList between = new ArrayList((List)val);
                            list.add(cb.between(QueryHelp.getExpression(attributeName, join, root).as(between.get(0).getClass()), (Comparable)between.get(0), (Comparable)between.get(1)));
                            break;
                        }
                    }
                }
                field.setAccessible(accessible);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        int size = list.size();
        return cb.and(list.toArray(new Predicate[size]));
    }

    private static <T, R> Expression<T> getExpression(String attributeName, Join join, Root<R> root) {
        if (!ObjectUtils.isEmpty((Object)join)) {
            return join.get(attributeName);
        }
        return root.get(attributeName);
    }

    private static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static List<Field> getAllFields(Class clazz, List<Field> fields) {
        if (clazz != null) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            QueryHelp.getAllFields(clazz.getSuperclass(), fields);
        }
        return fields;
    }
}

