/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.scheduling;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class TimeUtil {
    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    public static String getCron(Date date) {
        String dateFormat = "ss mm HH dd MM ?";
        return TimeUtil.formatDateByPattern(date, dateFormat);
    }

    public static String dateToYmd(LocalDate date) {
        return date == null ? "" : date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static LocalDate dateFromYmd(String ymd) {
        return StringUtils.isEmpty((Object)ymd) ? null : LocalDate.parse(ymd, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String datetime2String(LocalDateTime time) {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (ObjectUtils.isEmpty((Object)time)) {
            time = LocalDateTime.now();
        }
        return format.format(time);
    }
}

