/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.tw.tw5.server.common.util.JavaMailPayload;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class JavaMailUtil {
    private static final Logger log = LoggerFactory.getLogger(JavaMailUtil.class);
    private final MailProperties mailProperties;
    private final JavaMailSender mailSender;
    @Value(value="${tw5.mail.enabled}")
    private Boolean enabled = false;

    private MimeMessageHelper messageHelper(boolean withAttachments, String source) throws MessagingException {
        MimeMessageHelper msg = null;
        msg = new MimeMessageHelper(this.mailSender.createMimeMessage(), withAttachments);
        msg.setSentDate(Calendar.getInstance().getTime());
        String senderMail = this.mailProperties.getUsername();
        msg.setFrom(senderMail);
        msg.setReplyTo(senderMail);
        return msg;
    }

    public void addAttachement(MimeMessageHelper messageHelper, Path attachment) throws MessagingException {
        try (InputStream attachmentStream = Files.newInputStream(attachment, new OpenOption[0]);){
            messageHelper.addAttachment(attachment.getFileName().toString(), (InputStreamSource)new InputStreamResource(attachmentStream));
        }
        catch (IOException var16) {
            throw new MessagingException("[CORE-IO] read attachment FAILED: " + attachment, (Exception)var16);
        }
    }

    public void sendMessage(MimeMessageHelper messageHelper) {
        if (this.enabled.booleanValue()) {
            this.mailSender.send(messageHelper.getMimeMessage());
        } else {
            log.warn("\u90ae\u4ef6\u672a\u53d1\u9001\uff0c\u539f\u56e0\uff1a\u90ae\u4ef6\u670d\u52a1\u5df2\u5173\u95ed\u3002\u8bf7\u8bbe\u7f6e'el.mail.enabled: true' \u6253\u5f00");
        }
    }

    public void sendMessageByFinance(MimeMessageHelper messageHelper) {
        if (!this.enabled.booleanValue()) {
            log.warn("\u90ae\u4ef6\u672a\u53d1\u9001\uff0c\u539f\u56e0\uff1a\u90ae\u4ef6\u670d\u52a1\u5df2\u5173\u95ed\u3002\u8bf7\u8bbe\u7f6e'el.mail.enabled: true' \u6253\u5f00");
        }
    }

    public void sendEmailByAdmin(JavaMailPayload payload) {
        log.info("\u3010MESSAGE-EMAIL\u3011 \u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\uff1a {}...", (Object)payload);
        try {
            MimeMessageHelper helper = this.messageHelper(payload.isFileContentFlag(), payload.getSource());
            ArrayList<String> receiveEmails = new ArrayList<String>();
            if (payload.getReceiveEmails() != null && payload.getReceiveEmails().size() > 0) {
                receiveEmails.addAll(payload.getReceiveEmails());
            }
            if (payload.getReceiveEmail() != null) {
                receiveEmails.add(payload.getReceiveEmail());
            }
            if (receiveEmails.size() < 1) {
                throw new RuntimeException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff0c\u6536\u4ef6\u4eba\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String[] toArray = new String[receiveEmails.size()];
            helper.setTo(receiveEmails.toArray(toArray));
            helper.setSubject(payload.getSubject());
            helper.setText(payload.getText(), payload.isHtmlContentFlag());
            ArrayList<String> ccEmails = new ArrayList<String>();
            if (payload.getCcEmails() != null && payload.getCcEmails().size() > 0) {
                ccEmails.addAll(payload.getCcEmails());
            }
            if (payload.getCcEmail() != null) {
                ccEmails.add(payload.getCcEmail());
            }
            String[] ccArray = new String[ccEmails.size()];
            helper.setCc(ccEmails.toArray(ccArray));
            if (payload.getSource() != null && payload.getSource().equals("finance-admin@elitesland.com")) {
                this.sendMessageByFinance(helper);
            } else {
                this.sendMessage(helper);
            }
            log.info("\u3010MESSAGE-EMAIL\u3011 \u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u3010MESSAGE-EMAIL\u3011 \u90ae\u4ef6\u53d1\u9001\u5931\u8d25", (Throwable)e);
            log.debug("=================================");
            e.printStackTrace();
            log.debug("=================================");
            throw new RuntimeException("\u53d1\u9001\u5230\u3010{" + payload.getReceiveEmail() + "}\u3011\u7684\u90ae\u4ef6\u53d1\u9001\u5931\u8d25!");
        }
    }

    @Async
    public void sendEmailAsyncByAdmin(JavaMailPayload payload) {
        this.sendEmailByAdmin(payload);
    }

    public boolean isNew(Message message) throws MessagingException {
        boolean isNewFlag = false;
        Flags flags = message.getFlags();
        Flags.Flag[] flagsArr = flags.getSystemFlags();
        log.info("\u90ae\u7bb1\u72b6\u6001\uff1a" + JSONObject.toJSONString((Object)flagsArr));
        for (Flags.Flag flag : flagsArr) {
            if (flag != Flags.Flag.SEEN) continue;
            isNewFlag = true;
            log.info("\u5f53\u524d\u90ae\u4ef6\u4e3a\u672a\u8bfb\u72b6\u6001");
            break;
        }
        return isNewFlag;
    }

    public boolean outDays(Message msg) throws MessagingException {
        DateTime date = DateUtil.offsetDay((Date)new Date(), (int)1);
        Date receivedDate = msg.getReceivedDate();
        return receivedDate.getTime() - date.getTime() < 0L;
    }

    public String getMessageContent(Message msg) {
        if (msg == null) {
            return "";
        }
        StringBuilder result = new StringBuilder("");
        try {
            String contentType = msg.getContentType();
            if (contentType.toLowerCase().startsWith("text")) {
                result.append(msg.getContent().toString());
            }
            if (contentType.toLowerCase().startsWith("multipart")) {
                MimeMultipart mimeMultipart = (MimeMultipart)msg.getContent();
                this.parseMultipartText(result, mimeMultipart);
            }
        }
        catch (IOException | MessagingException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private void parseMultipartText(StringBuilder text, MimeMultipart mimeMultipart) throws MessagingException, IOException {
        int count = mimeMultipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            String type = bodyPart.getContentType();
            if ("multipart/mixed".equals(type)) {
                MimeMultipart mimeMultipart1 = (MimeMultipart)bodyPart.getContent();
                this.parseMultipartText(text, mimeMultipart1);
            }
            if (!type.toLowerCase().startsWith("text")) continue;
            text.append(bodyPart.getContent());
        }
    }

    public JavaMailUtil(MailProperties mailProperties, JavaMailSender mailSender) {
        this.mailProperties = mailProperties;
        this.mailSender = mailSender;
    }
}

