/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdeUtil {
    private static final Logger log = LoggerFactory.getLogger(JdeUtil.class);
    private static final String UI_YMD_FMT = "yyyy-M-d";
    private static final String UI_HMS_FMT = "HH:mm:ss";
    public static final String JDE_TODAY = "(TO_CHAR(SYSDATE, 'yyyyddd') - 1900000)";
    private static final int JULIAN_YEAR = 1900;
    private static final int THOUSAND = 1000;
    private static final int TEN_THOUSANDS = 10000;
    private static final int HUNDRED = 100;
    private static final int DEC_PRC = 4;
    private static final int DEC_QTY = 3;
    private static final int DEC_AMT = 2;

    public static BigDecimal dec2zoom(int dec) {
        return BigDecimal.valueOf((long)Math.pow(10.0, dec));
    }

    public static Integer toJdeDateYmd(String ymd) {
        return JdeUtil.toJdeDate(JdeUtil.fromYmd(ymd));
    }

    public static Integer toJdeDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int dayOfYear = cal.get(6);
        return (year - 1900) * 1000 + dayOfYear;
    }

    public static Date fromJdeDate(Integer jdeDate) {
        if (jdeDate == null || jdeDate == 0) {
            return null;
        }
        Calendar cal = JdeUtil.pureDate();
        cal.set(1, 1900 + jdeDate / 1000);
        cal.set(6, jdeDate % 1000);
        return cal.getTime();
    }

    public static Integer toJdeTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11) * 10000 + cal.get(12) * 100 + cal.get(13);
    }

    public static Date fromJdeTime(Integer jdeTime) {
        if (jdeTime == null) {
            return null;
        }
        Calendar cal = JdeUtil.pureDate();
        cal.set(11, jdeTime / 10000);
        cal.set(12, jdeTime % 10000 / 100);
        cal.set(13, jdeTime % 100);
        return cal.getTime();
    }

    public static BigDecimal toIntNumber(BigDecimal num) {
        return num.setScale(0, RoundingMode.HALF_UP);
    }

    public static BigDecimal toJdePrc(BigDecimal prc) {
        return JdeUtil.toIntNumber(prc.movePointRight(4));
    }

    public static BigDecimal fromJdePrc(BigDecimal prc) {
        return prc.movePointLeft(4);
    }

    public static BigDecimal toJdeQty(BigDecimal qty) {
        return JdeUtil.toIntNumber(qty.movePointRight(3));
    }

    public static BigDecimal fromJdeQty(BigDecimal qty) {
        return qty.movePointLeft(3);
    }

    public static BigDecimal toJdeAmt(BigDecimal amt) {
        return JdeUtil.toIntNumber(amt.movePointRight(2));
    }

    public static BigDecimal fromJdeAmt(BigDecimal amt) {
        return amt.movePointLeft(2);
    }

    private JdeUtil() {
    }

    public static Date fromYmd(String ymd) {
        if (StringUtils.isEmpty((CharSequence)ymd)) {
            return null;
        }
        try {
            return new SimpleDateFormat(UI_YMD_FMT).parse(ymd);
        }
        catch (ParseException e) {
            log.debug(String.format("[SMS] Parsing date format(%s) error: %s", UI_YMD_FMT, ymd));
            return null;
        }
    }

    public static Calendar pureDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static String leftPadilling(String src, int length, char filling) {
        if (StringUtils.isEmpty((CharSequence)src)) {
            src = "";
        }
        return JdeUtil.addPad(src, filling, length, 'L');
    }

    public static String leftPad(String src, int length) {
        if (StringUtils.isEmpty((CharSequence)src)) {
            src = "";
        }
        return JdeUtil.addPad(src, ' ', length, 'L');
    }

    public static String rightPad(String src, int length) {
        if (StringUtils.isEmpty((CharSequence)src)) {
            src = "";
        }
        return JdeUtil.addPad(src, ' ', length, 'R');
    }

    private static String addPad(String src, char addStr, int length, char type) {
        if (src == null) {
            src = "";
        }
        if (src.length() >= length) {
            return src;
        }
        StringBuilder sb = new StringBuilder();
        length -= src.length();
        for (int i = 0; i < length; ++i) {
            sb.append(addStr);
        }
        if (type == 'R') {
            return src + sb.toString();
        }
        return sb.toString() + src;
    }

    public static String leftPad(String src, int length, char filling) {
        if (src == null) {
            src = "";
        }
        if (src.length() >= length) {
            return src;
        }
        StringBuilder sb = new StringBuilder();
        length -= src.length();
        for (int i = 0; i < length; ++i) {
            sb.append(filling);
        }
        return sb.toString() + src;
    }

    public static void main(String[] jj) {
        String testStrr = "123";
        String newSttt = JdeUtil.leftPad(testStrr, 4, '0');
        System.out.println(JdeUtil.leftPadilling("123", 4, '0'));
        System.out.println(newSttt);
        System.out.println(newSttt.equals(testStrr));
    }
}

