/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.common.workFlow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.workflow.params.TaskNodeConfigDTO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.workFlow.CommonWorkflowCheck;
import com.elitesland.tw.tw5.server.common.workFlow.CommonWorkflowEvent;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/{procDefKey}/callBack"})
public class CommonWorkflowCallbackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(CommonWorkflowCallbackController.class);
    public static final String SERVICE_NAME_PREFIX = "TW_WORKFLOW_CALLBACK_";
    private final WorkflowService workflowService;
    @Autowired
    private Map<String, WorkflowCallBack> workflowCallBackMap;
    @Autowired
    private Map<String, CommonWorkflowEvent> workflowEventMap;
    @Autowired
    private Map<String, CommonWorkflowCheck> workflowCheckMap;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("taskAssignee:{}", (Object)payload);
        String procDefKey = payload.getProcDefKey();
        WorkflowCallBack workflowCallBack = this.workflowCallBackMap.get(SERVICE_NAME_PREFIX + procDefKey);
        if (workflowCallBack != null) {
            return workflowCallBack.taskAssignee(payload);
        }
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        TaskNodeConfigDTO taskNodeConfigDTO;
        String checkString;
        JSONArray jsonArray;
        List taskNodes;
        log.info("taskCreated:{}", (Object)payload);
        WorkflowResult nodeConfig = this.workflowService.getNodeConfig(payload.getProcDefKey(), payload.getTaskKey());
        if (nodeConfig.isSuccess() && (taskNodes = (List)nodeConfig.getData()) != null && !taskNodes.isEmpty() && (jsonArray = JSON.parseArray((String)(checkString = (taskNodeConfigDTO = (TaskNodeConfigDTO)taskNodes.get(0)).getEs1()))) != null && !jsonArray.isEmpty()) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject checkObject = jsonArray.getJSONObject(i);
                String checkName = checkObject.getString("checkName");
                String checkCode = checkObject.getString("checkCode");
                String checkParams = checkObject.getString("checkParams");
                log.info("\u6267\u884c\u5de5\u4f5c\u6d41\u68c0\u67e5\uff1a\u3010\u540d\u79f0\uff1a{}\u3011\u3010\u53c2\u6570\uff1a{}\u3011", (Object)checkName, (Object)checkCode);
                CommonWorkflowCheck workflowCheck = this.workflowCheckMap.get("TwWorkflowCheck_" + checkCode);
                String[] params = null;
                if (checkParams != null && !checkParams.isEmpty()) {
                    params = checkParams.split(",");
                }
                workflowCheck.setProps(payload, params);
                TwOutputUtil result = workflowCheck.check();
                if (result.isSuccess()) continue;
                return new WorkflowResult(false, result.getMsg(), null);
            }
        }
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        WorkflowCallBack workflowCallBack;
        TaskNodeConfigDTO taskNodeConfigDTO;
        String eventString;
        JSONArray jsonArray;
        List taskNodes;
        log.info("taskCompleted:{}", (Object)payload);
        String procDefKey = payload.getProcDefKey();
        String taskKey = payload.getTaskKey();
        WorkflowResult nodeConfig = this.workflowService.getNodeConfig(procDefKey, taskKey);
        if (nodeConfig.isSuccess() && (taskNodes = (List)nodeConfig.getData()) != null && !taskNodes.isEmpty() && (jsonArray = JSON.parseArray((String)(eventString = (taskNodeConfigDTO = (TaskNodeConfigDTO)taskNodes.get(0)).getEs2()))) != null && !jsonArray.isEmpty()) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject checkObject = jsonArray.getJSONObject(i);
                String eventName = checkObject.getString("eventName");
                String eventCode = checkObject.getString("eventCode");
                String eventParams = checkObject.getString("eventParams");
                log.info("\u6267\u884c\u5de5\u4f5c\u6d41\u4e8b\u4ef6\uff1a\u3010\u540d\u79f0\uff1a{}\u3011\u3010\u53c2\u6570\uff1a{}\u3011", (Object)eventName, (Object)eventParams);
                CommonWorkflowEvent workflowEvent = this.workflowEventMap.get("TwWorkflowEvent_" + eventCode);
                String[] params = null;
                if (eventParams != null && !eventParams.isEmpty()) {
                    params = eventParams.split(",");
                }
                workflowEvent.setProps(payload, params);
                workflowEvent.execute();
            }
        }
        if ((workflowCallBack = this.workflowCallBackMap.get(SERVICE_NAME_PREFIX + procDefKey)) != null) {
            return workflowCallBack.taskCompleted(payload);
        }
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("processStatusChange:{}", (Object)payload);
        String procDefKey = payload.getProcDefKey();
        WorkflowCallBack workflowCallBack = this.workflowCallBackMap.get(SERVICE_NAME_PREFIX + procDefKey);
        if (workflowCallBack != null) {
            return workflowCallBack.processStatusChange(payload);
        }
        return WorkflowResult.success(null);
    }

    public CommonWorkflowCallbackController(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}

