/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.log.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogChannelEnum;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.dto.ApiRequestLogQuery;
import com.elitesland.tw.tw5.server.log.entity.ApiRequestLogDO;
import com.elitesland.tw.tw5.server.log.repo.ApiRequestLogRepo;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class ApiRequestLogServiceImpl
implements ApiRequestLogService {
    private static final Logger log = LoggerFactory.getLogger(ApiRequestLogServiceImpl.class);
    private final ApiRequestLogRepo repo;
    private static final int MAX_LENGTH_PARAM = 3000;
    private static final int MAX_LENGTH_RESULT = 5000;

    @Override
    public void saveLog(ApiRequestLogTypeEnum type, ApiRequestLogChannelEnum channel, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark) {
        ApiRequestLogDO logDO = new ApiRequestLogDO(type, channel, uri, requestMethod, param, header, result, status, remark);
        this.saveLog(logDO);
    }

    @Override
    public void saveLog(ApiRequestLogTypeEnum type, ApiRequestLogChannelEnum channel, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark, String ext1, String ext2, String ext3, String ext4) {
        ApiRequestLogDO logDO = new ApiRequestLogDO(type, channel, uri, requestMethod, param, header, result, status, remark, ext1, ext2, ext3, ext4);
        this.saveLog(logDO);
    }

    @Override
    public void saveLog(ApiRequestLogDO logDO) {
        String result;
        String param = logDO.getParam();
        if (StringUtils.hasText((String)param) && param.length() > 3000) {
            logDO.setParam(param.substring(0, 3000));
        }
        if (StringUtils.hasText((String)(result = logDO.getResult())) && result.length() > 5000) {
            logDO.setResult(result.substring(0, 5000));
        }
        this.repo.save((Object)logDO);
    }

    @Override
    public void saveOutLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status) {
        ApiRequestLogDO logDO = new ApiRequestLogDO(type, ApiRequestLogChannelEnum.OUT, uri, requestMethod, param, header, result, status, "");
        this.saveLog(logDO);
    }

    @Override
    public void saveOutLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status, Long time) {
        ApiRequestLogDO logDO = new ApiRequestLogDO(type, ApiRequestLogChannelEnum.OUT, uri, requestMethod, param, header, result, status, "");
        logDO.setTime(time);
        this.saveLog(logDO);
    }

    @Override
    public void saveOutLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status, Long time, String docId) {
        ApiRequestLogDO logDO = new ApiRequestLogDO(type, ApiRequestLogChannelEnum.OUT, uri, requestMethod, param, header, result, status, "");
        logDO.setTime(time);
        logDO.setExt1(docId);
        this.saveLog(logDO);
    }

    @Override
    public void saveOutLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark) {
        ApiRequestLogDO logDO = new ApiRequestLogDO(type, ApiRequestLogChannelEnum.OUT, uri, requestMethod, param, header, result, status, remark);
        this.saveLog(logDO);
    }

    @Override
    public void saveInLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status) {
        ApiRequestLogDO logDO = new ApiRequestLogDO(type, ApiRequestLogChannelEnum.IN, uri, requestMethod, param, header, result, status, "");
        this.saveLog(logDO);
    }

    @Override
    public void saveInLog(ApiRequestLogTypeEnum type, String uri, RequestMethod requestMethod, String param, String header, String result, String status, String remark) {
        ApiRequestLogDO logDO = new ApiRequestLogDO(type, ApiRequestLogChannelEnum.IN, uri, requestMethod, param, header, result, status, remark);
        this.saveLog(logDO);
    }

    @Override
    public ApiRequestLogDO queryByKey(Long key) {
        ApiRequestLogDO entity = this.repo.findById(key).orElseGet(ApiRequestLogDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u65e5\u5fd7\u4e0d\u5b58\u5728");
        return entity;
    }

    @Override
    public PagingVO<ApiRequestLogDO> paging(ApiRequestLogQuery query) {
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page);
    }

    @Override
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.repo.deleteSoft(keys);
        }
    }

    @Override
    public void delete(List<Long> keys) {
        this.repo.deleteAllById(keys);
    }

    public ApiRequestLogServiceImpl(ApiRequestLogRepo repo) {
        this.repo = repo;
    }
}

