/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.inv.common.InvoiceReimStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/ACC_SPECIAL/callBack"})
@Transactional
public class AccReimSpecialCallbackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(AccReimSpecialCallbackController.class);
    private final AccReimService accReimService;
    private final InvInvoiceService invInvoiceService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        Long reimId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        AccReimPayload accReimPayload = new AccReimPayload();
        accReimPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        AccReimVO accReimVO = this.accReimService.queryOneByKey(Long.valueOf(businessKey));
        if (!ObjectUtils.isEmpty((Object)accReimVO)) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.NOTSUBMIT.name());
                    break;
                }
                case INTERRUPT: {
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    break;
                }
                case INVALID: {
                    accReimPayload.setApprStatus(ProcInstStatus.INVALID.name());
                    accReimPayload.setDeleteFlag(Integer.valueOf(1));
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.NEW.getCode());
                    break;
                }
                case REJECTED: {
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.CREATE.getCode());
                    accReimPayload.setApprStatus(ProcInstStatus.REJECTED.name());
                    break;
                }
                case APPROVED: {
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVED.name());
                    accReimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_CHARGE.getCode());
                    this.invInvoiceService.updateReimStatusByReimId(reimId, InvoiceReimStatusEnum.APPROVED.getCode());
                    break;
                }
                case APPROVING: {
                    accReimPayload.setApprStatus(ProcInstStatus.APPROVING.name());
                }
            }
            this.accReimService.partialUpdate(accReimPayload);
        }
        return WorkflowResult.success(null);
    }

    public AccReimSpecialCallbackController(AccReimService accReimService, InvInvoiceService invInvoiceService) {
        this.accReimService = accReimService;
        this.invInvoiceService = invInvoiceService;
    }

    static enum FlowTaskKey {
        Activity_1hgii9b("Activity_1hgii9b", "\u8d22\u52a1\u7a3d\u6838\u4e13\u5458");

        private String code;
        private String desc;

        private FlowTaskKey(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
}

