/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.adm.controller;

import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/AMD_{procDefKey}/callBack"})
@Transactional
public class AdmWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(AdmWorkflowCallBackController.class);
    private final AdmBusitripApplyService admBusitripApplyService;
    private final AdmFeeApplyService admFeeApplyService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        try {
            if (payload.getProcDefKey().equals(ProcDefKey.AMD_BUSITRIP_APPLY.name)) {
                log.info("\u51fa\u5dee\u7533\u8bf7\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03");
                this.admBusitripApplyService.processStatusChange(payload);
            }
            if (payload.getProcDefKey().equals(ProcDefKey.AMD_FEE_APPLY.name)) {
                log.info("\u7279\u6b8a\u8d39\u7528\u7533\u8bf7\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03");
                this.admFeeApplyService.processStatusChange(payload);
            }
            return WorkflowResult.success(null);
        }
        catch (TwException ex) {
            WorkflowResult result = new WorkflowResult(false, ex.getErrors().toString(), null);
            return result;
        }
    }

    public AdmWorkflowCallBackController(AdmBusitripApplyService admBusitripApplyService, AdmFeeApplyService admFeeApplyService) {
        this.admBusitripApplyService = admBusitripApplyService;
        this.admFeeApplyService = admFeeApplyService;
    }

    static enum ProcDefKey {
        AMD_BUSITRIP_APPLY("AMD_BUSITRIP_APPLY", "\u51fa\u5dee\u7533\u8bf7\u6d41\u7a0b"),
        AMD_FEE_APPLY("AMD_FEE_APPLY", "\u7279\u6b8a\u8d39\u7528\u7533\u8bf7\u6d41\u7a0b");

        private String name;
        private String desc;

        private ProcDefKey(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

