/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.borrow.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowWriteOffPayload;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowMoneyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.query.BorrowWriteOffQuery;
import com.elitesland.tw.tw5.api.prd.borrow.query.TransferApplyQuery;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowMoneyService;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowWriteOffService;
import com.elitesland.tw.tw5.api.prd.borrow.service.TransferApplyService;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowMoneyVO;
import com.elitesland.tw.tw5.api.prd.borrow.vo.BorrowWriteOffVO;
import com.elitesland.tw.tw5.api.prd.borrow.vo.TransferApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.borrow.constant.BorrowStatusEnum;
import com.elitesland.tw.tw5.server.prd.borrow.constant.BorrowWriteOffTypeEnum;
import com.elitesland.tw.tw5.server.prd.borrow.convert.BorrowMoneyConvert;
import com.elitesland.tw.tw5.server.prd.borrow.dao.BorrowMoneyDAO;
import com.elitesland.tw.tw5.server.prd.borrow.entity.BorrowMoneyDO;
import com.elitesland.tw.tw5.server.prd.borrow.repo.BorrowMoneyRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.OrgEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BorrowMoneyServiceImpl
extends BaseServiceImpl
implements BorrowMoneyService {
    private static final Logger log = LoggerFactory.getLogger(BorrowMoneyServiceImpl.class);
    private final BorrowMoneyRepo borrowMoneyRepo;
    private final BorrowMoneyDAO borrowMoneyDAO;
    private final WorkflowUtil workflowUtil;
    private final BorrowWriteOffService borrowWriteOffService;
    private final TransferApplyService transferApplyService;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;
    private final FileUtil fileUtil;

    public PagingVO<BorrowMoneyVO> queryPaging(BorrowMoneyQuery query) {
        PagingVO<BorrowMoneyVO> borrowMoneyVOPagingVO = this.borrowMoneyDAO.queryPaging(query);
        this.transferList(borrowMoneyVOPagingVO.getRecords());
        return borrowMoneyVOPagingVO;
    }

    public List<BorrowMoneyVO> queryListDynamic(BorrowMoneyQuery query) {
        return this.borrowMoneyDAO.queryListDynamic(query);
    }

    public BorrowMoneyVO queryByKey(Long key) {
        BorrowMoneyVO borrowMoneyVO = this.borrowMoneyDAO.queryByKey(key);
        if (borrowMoneyVO != null) {
            this.transfer(Collections.singletonList(borrowMoneyVO));
        }
        return borrowMoneyVO;
    }

    public BorrowMoneyVO insert(BorrowMoneyPayload payload) {
        BorrowMoneyDO save = this.transactionUtilService.executeWithCallable(() -> (BorrowMoneyDO)this.borrowMoneyRepo.save(this.processData(payload)));
        BorrowMoneyVO borrowMoneyVO = BorrowMoneyConvert.INSTANCE.toVo(save);
        this.activeBorrowMoneyProc(borrowMoneyVO);
        return borrowMoneyVO;
    }

    private BorrowMoneyDO processData(BorrowMoneyPayload payload) {
        BorrowMoneyDO entityDo = BorrowMoneyConvert.INSTANCE.toDo(payload);
        entityDo.setRepaymentUserId(entityDo.getApplicantUserId());
        entityDo.setBorrowNo(this.generateSeqNum("BORROW_MONEY_NO", new String[0]));
        entityDo.setAlreadyWriteOffAmt(BigDecimal.ZERO);
        entityDo.setUnwriteOffAmt(entityDo.getBorrowAmt());
        if (entityDo.getBorrowName() == null) {
            String userName = this.cacheUtil.getUserName(entityDo.getApplicantUserId());
            String applyDate = entityDo.getApplicantTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            String businessTypeDesc = this.cacheUtil.transferSystemSelection("BORROW_MONEY:BUSINESS_TYPE", entityDo.getBusinessType());
            BigDecimal borrowAmt = entityDo.getBorrowAmt() == null ? BigDecimal.ZERO : entityDo.getBorrowAmt();
            entityDo.setBorrowName(userName + "-" + applyDate + "-" + borrowAmt + "-" + businessTypeDesc);
        }
        return entityDo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BorrowMoneyVO update(BorrowMoneyPayload payload) {
        BorrowMoneyDO entity = this.borrowMoneyRepo.findById(payload.getId()).orElseGet(BorrowMoneyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BorrowMoneyDO entityDo = BorrowMoneyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BorrowMoneyConvert.INSTANCE.toVo((BorrowMoneyDO)this.borrowMoneyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BorrowMoneyPayload payload) {
        BorrowMoneyDO entity = this.borrowMoneyRepo.findById(payload.getId()).orElseGet(BorrowMoneyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        return this.borrowMoneyDAO.updateByKeyDynamic(payload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.borrowMoneyDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBorrowStatus(List<Long> keys, String status) {
        if (!keys.isEmpty()) {
            this.borrowMoneyDAO.updateBorrowStatus(keys, status);
        }
    }

    private void activeBorrowMoneyProc(BorrowMoneyVO borrowMoneyVO) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("borrowAmt", borrowMoneyVO.getBorrowAmt());
        PrdOrgOrganizationVO org = this.cacheUtil.getOrg(borrowMoneyVO.getApplicantBuId());
        variables.put("buLevel", org.getExtString1());
        if (OrgEnum.BuLevel.BU_LEVEL3.getCode().equals(org.getExtString1())) {
            borrowMoneyVO.setLevel3BuManagerId(org.getManageId());
            List<PrdOrgOrganizationRefVO> allFatherOrg = this.cacheUtil.getAllFatherOrgByOrgId(org.getId());
            Optional<PrdOrgOrganizationRefVO> secondOrgRef = allFatherOrg.stream().filter(vo -> StringUtils.hasText((String)vo.getBuLevel()) && vo.getBuLevel().equals(OrgEnum.BuLevel.BU_LEVEL2.getCode()) && vo.getOrgStatus().equalsIgnoreCase(OrgEnum.OrgStatus.ACTIVE.getCode())).findFirst();
            secondOrgRef.ifPresent(prdOrgOrganizationRefVO -> borrowMoneyVO.setLevel2BuManagerId(prdOrgOrganizationRefVO.getManageId()));
            PrdOrgOrganizationRefVO buLevel1ByOrgId = this.cacheUtil.getBULevel1ByOrgId(org.getId());
            borrowMoneyVO.setLevel1BuManagerId(buLevel1ByOrgId.getManageId());
        } else if (OrgEnum.BuLevel.BU_LEVEL2.getCode().equals(org.getExtString1())) {
            borrowMoneyVO.setLevel2BuManagerId(org.getManageId());
            PrdOrgOrganizationRefVO buLevel1ByOrgId = this.cacheUtil.getBULevel1ByOrgId(org.getId());
            borrowMoneyVO.setLevel1BuManagerId(buLevel1ByOrgId.getManageId());
        } else if (OrgEnum.BuLevel.BU_LEVEL1.getCode().equals(org.getExtString1())) {
            borrowMoneyVO.setLevel1BuManagerId(org.getManageId());
        }
        String procInstName = borrowMoneyVO.getBorrowName() + "-\u501f\u6b3e\u6d41\u7a0b";
        ProcessInfo processInfo = this.workflowUtil.simpleStartProcess(StartProcessPayload.of((String)ProcDefKey.DIB_BORROW_MONEY.name(), (String)procInstName, (String)("" + borrowMoneyVO.getId()), variables), borrowMoneyVO, new Long[0]);
        if (ProcInstStatus.APPROVING.getDesc().equals(processInfo.getProcInstStatus().getDesc())) {
            BorrowMoneyPayload payload = new BorrowMoneyPayload();
            payload.setId(borrowMoneyVO.getId());
            payload.setApprStatus(BorrowStatusEnum.APPROVING.getCode());
            this.borrowMoneyDAO.updateByKeyDynamic(payload);
        }
    }

    private void transfer(List<BorrowMoneyVO> borrowMoneyVOList) {
        if (!CollectionUtils.isEmpty(borrowMoneyVOList)) {
            List idList = borrowMoneyVOList.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            TransferApplyQuery transferApplyQuery = new TransferApplyQuery();
            transferApplyQuery.setBorrowIdList(idList);
            List transferApplyVOS = this.transferApplyService.queryListDynamic(transferApplyQuery);
            Map<Object, Object> transferApplyMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)transferApplyVOS)) {
                transferApplyMap = transferApplyVOS.stream().collect(Collectors.groupingBy(TransferApplyVO::getBorrowId));
            }
            BorrowWriteOffQuery borrowWriteOffQuery = new BorrowWriteOffQuery();
            borrowWriteOffQuery.setBorrowIdList(idList);
            List borrowWriteOffVOS = this.borrowWriteOffService.queryListDynamic(borrowWriteOffQuery);
            Map<Object, Object> borrowWriteOffMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)borrowWriteOffVOS)) {
                borrowWriteOffMap = borrowWriteOffVOS.stream().collect(Collectors.groupingBy(BorrowWriteOffVO::getBorrowId));
            }
            for (BorrowMoneyVO borrowMoneyVO : borrowMoneyVOList) {
                if (transferApplyMap.containsKey(borrowMoneyVO.getId())) {
                    borrowMoneyVO.setTransferApplyList((List)transferApplyMap.get(borrowMoneyVO.getId()));
                }
                if (borrowWriteOffMap.containsKey(borrowMoneyVO.getId())) {
                    borrowMoneyVO.setBorrowWriteOffList((List)borrowWriteOffMap.get(borrowMoneyVO.getId()));
                }
                if (StringUtils.hasText((String)borrowMoneyVO.getFileCodes())) {
                    borrowMoneyVO.setFileData(this.fileUtil.getFileDatas(borrowMoneyVO.getFileCodes()));
                }
                if (borrowMoneyVO.getTransferFlag() == null || !borrowMoneyVO.getTransferFlag().booleanValue()) continue;
                borrowMoneyVO.setApprStatus(BorrowStatusEnum.TRANSFER.getCode());
            }
        }
    }

    private void transferList(List<BorrowMoneyVO> borrowMoneyVOS) {
        borrowMoneyVOS.forEach(borrowMoneyVO -> {
            if (borrowMoneyVO.getTransferFlag() != null && borrowMoneyVO.getTransferFlag().booleanValue()) {
                borrowMoneyVO.setApprStatus(BorrowStatusEnum.TRANSFER.getCode());
            }
        });
    }

    @Transactional
    public void relateBorrowData(Long reimId) {
        List borrowMoneyVOList = this.borrowWriteOffService.queryByReimId(reimId);
        if (!CollectionUtils.isEmpty((Collection)borrowMoneyVOList)) {
            List borrowIdList = borrowMoneyVOList.stream().map(vo -> vo.getId()).collect(Collectors.toList());
            BorrowMoneyQuery borrowMoneyQuery = new BorrowMoneyQuery();
            borrowMoneyQuery.setIds(borrowIdList);
            List<BorrowMoneyVO> borrowMoneyVOS = this.queryListDynamic(borrowMoneyQuery);
            borrowMoneyVOS.stream().forEach(borrowMoneyVO -> {
                BorrowMoneyPayload borrowMoneyPayload = new BorrowMoneyPayload();
                borrowMoneyPayload.setId(borrowMoneyVO.getId());
                if (borrowMoneyVO.getAlreadyWriteOffAmt() == null || borrowMoneyVO.getAlreadyWriteOffAmt().compareTo(BigDecimal.ZERO) == 0) {
                    borrowMoneyPayload.setApprStatus(BorrowStatusEnum.PAID.getCode());
                } else {
                    borrowMoneyPayload.setApprStatus(BorrowStatusEnum.WRITE_OFF_PART.getCode());
                }
                this.updateByKeyDynamic(borrowMoneyPayload);
            });
        }
        this.borrowWriteOffService.deleteByReimId(reimId);
    }

    @Transactional
    public void cashWriteOff(Long key, BigDecimal writeOffAmt) {
        BorrowMoneyVO borrowMoneyVO = this.queryByKey(key);
        if (borrowMoneyVO == null || !BorrowStatusEnum.PAID.getCode().equals(borrowMoneyVO.getApprStatus()) && !BorrowStatusEnum.WRITE_OFF_PART.getCode().equals(borrowMoneyVO.getApprStatus())) {
            throw TwException.error("", "\u53ea\u6709\u5df2\u4ed8\u6b3e/\u90e8\u5206\u6838\u9500\u7684\u5355\u636e\u624d\u80fd\u8fdb\u884c\u6838\u9500\uff01");
        }
        BigDecimal borrowAmt = borrowMoneyVO.getBorrowAmt() == null ? BigDecimal.ZERO : borrowMoneyVO.getBorrowAmt();
        BigDecimal alreadyWriteOffAmt = borrowMoneyVO.getAlreadyWriteOffAmt() == null ? BigDecimal.ZERO : borrowMoneyVO.getAlreadyWriteOffAmt();
        writeOffAmt = writeOffAmt == null ? BigDecimal.ZERO : writeOffAmt;
        BorrowMoneyPayload borrowMoneyPayload = new BorrowMoneyPayload();
        borrowMoneyPayload.setId(borrowMoneyVO.getId());
        borrowMoneyPayload.setAlreadyWriteOffAmt(alreadyWriteOffAmt.add(writeOffAmt));
        borrowMoneyPayload.setUnwriteOffAmt(borrowAmt.subtract(alreadyWriteOffAmt.add(writeOffAmt)));
        int i = alreadyWriteOffAmt.add(writeOffAmt).compareTo(borrowAmt);
        if (i > 0) {
            throw TwException.error("", "\u6838\u9500\u91d1\u989d\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
        }
        if (i == 0) {
            borrowMoneyPayload.setApprStatus(BorrowStatusEnum.WRITTEN_OFF.getCode());
        } else {
            borrowMoneyPayload.setApprStatus(BorrowStatusEnum.WRITE_OFF_PART.getCode());
        }
        this.updateByKeyDynamic(borrowMoneyPayload);
        Long loginUserId = GlobalUtil.getLoginUserId();
        BorrowWriteOffPayload borrowWriteOffPayload = new BorrowWriteOffPayload();
        borrowWriteOffPayload.setBorrowId(borrowMoneyPayload.getId());
        borrowWriteOffPayload.setWriteOffAmt(writeOffAmt);
        borrowWriteOffPayload.setWriteOffDate(LocalDate.now());
        borrowWriteOffPayload.setWriteOffType(BorrowWriteOffTypeEnum.CASH.getCode());
        borrowWriteOffPayload.setWriteOffUserId(loginUserId);
        this.borrowWriteOffService.insert(borrowWriteOffPayload);
    }

    public BorrowMoneyServiceImpl(BorrowMoneyRepo borrowMoneyRepo, BorrowMoneyDAO borrowMoneyDAO, WorkflowUtil workflowUtil, BorrowWriteOffService borrowWriteOffService, TransferApplyService transferApplyService, CacheUtil cacheUtil, TransactionUtilService transactionUtilService, FileUtil fileUtil) {
        this.borrowMoneyRepo = borrowMoneyRepo;
        this.borrowMoneyDAO = borrowMoneyDAO;
        this.workflowUtil = workflowUtil;
        this.borrowWriteOffService = borrowWriteOffService;
        this.transferApplyService = transferApplyService;
        this.cacheUtil = cacheUtil;
        this.transactionUtilService = transactionUtilService;
        this.fileUtil = fileUtil;
    }
}

