/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.borrow.workflow;

import com.elitesland.tw.tw5.api.prd.borrow.payload.BorrowMoneyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.payload.TransferApplyPayload;
import com.elitesland.tw.tw5.api.prd.borrow.service.BorrowMoneyService;
import com.elitesland.tw.tw5.api.prd.borrow.service.TransferApplyService;
import com.elitesland.tw.tw5.api.prd.borrow.vo.TransferApplyVO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TW_WORKFLOW_CALLBACK_TRANSFER_APPLY")
public class TransferApplyWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(TransferApplyWorkflowCallBackController.class);
    @Autowired
    private BorrowMoneyService borrowMoneyService;
    @Autowired
    private TransferApplyService service;

    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        log.info("customer taskAssignee:{}", (Object)payload);
        return WorkflowResult.success(null);
    }

    public WorkflowResult<Void> taskCreated(TaskCreatedPayload payload) {
        log.info("customer taskCreated:{}", (Object)payload);
        return WorkflowResult.success(null);
    }

    public WorkflowResult<Void> taskCompleted(TaskCompletedPayload payload) {
        log.info("customer taskCompleted:{}", (Object)payload);
        return WorkflowResult.success(null);
    }

    public WorkflowResult<Void> processStatusChange(ProcessStatusChangePayload payload) {
        log.info("customer processStatusChange:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        TransferApplyPayload transferApplyPayload = new TransferApplyPayload();
        transferApplyPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        TransferApplyVO transferApplyVO = this.service.queryByKey(Long.valueOf(businessKey));
        if (transferApplyVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    transferApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    BorrowMoneyPayload borrowMoneyPayload = this.updateBorrowTransferFlag(transferApplyVO.getBorrowId());
                    this.borrowMoneyService.updateByKeyDynamic(borrowMoneyPayload);
                    break;
                }
                case INVALID: {
                    transferApplyPayload.setDeleteFlag(Integer.valueOf(1));
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    transferApplyPayload.setApprovedTime(LocalDateTime.now());
                    BorrowMoneyPayload borrowMoneyPayload2 = this.updateBorrowTransferFlag(transferApplyVO.getBorrowId());
                    borrowMoneyPayload2.setId(transferApplyVO.getBorrowId());
                    borrowMoneyPayload2.setReceiveUserId(transferApplyVO.getReceiveUserId());
                    borrowMoneyPayload2.setReceiveBuId(transferApplyVO.getReceiveBuId());
                    borrowMoneyPayload2.setTransferDate(transferApplyVO.getTransferDate());
                    borrowMoneyPayload2.setRepaymentUserId(transferApplyVO.getReceiveUserId());
                    this.borrowMoneyService.updateByKeyDynamic(borrowMoneyPayload2);
                    break;
                }
                case APPROVING: {
                    transferApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                }
            }
            this.service.updateByKeyDynamic(transferApplyPayload);
        }
        return WorkflowResult.success(null);
    }

    private BorrowMoneyPayload updateBorrowTransferFlag(Long borrowId) {
        BorrowMoneyPayload borrowMoneyPayload = new BorrowMoneyPayload();
        borrowMoneyPayload.setId(borrowId);
        borrowMoneyPayload.setTransferFlag(Boolean.valueOf(false));
        return borrowMoneyPayload;
    }
}

