/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.VacationPlayload;
import com.elitesland.tw.tw5.api.prd.my.query.VacationQuery;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/my/vacation"})
public class VacationController {
    private static final Logger log = LoggerFactory.getLogger(VacationController.class);
    private final VacationService vacationService;

    @GetMapping(value={"/workHours"})
    public TwOutputUtil selectWorkHoursByDate(String startDate, String endDate) {
        Double workHours = this.vacationService.selectWorkHoursByDate(TimeUtil.dateFromYmd(startDate), TimeUtil.dateFromYmd(endDate));
        return TwOutputUtil.ok(workHours);
    }

    @GetMapping(value={"/{year}"})
    public TwOutputUtil findVacation(@PathVariable int year) {
        List list = this.vacationService.findListByYear(year);
        ArrayList mapList = new ArrayList();
        list.forEach(twVacationView -> {
            HashMap<String, Float> map = new HashMap<String, Float>();
            map.put(TimeUtil.dateToYmd(twVacationView.getNaturalDate()), twVacationView.getWorkHours());
            mapList.add(map);
        });
        return TwOutputUtil.ok(mapList);
    }

    @GetMapping(value={"/query"})
    public TwOutputUtil getVacation(VacationQuery vacationQuery) {
        List list = this.vacationService.findVacationList(vacationQuery);
        HashMap map = new HashMap();
        list.forEach(twVacationView -> map.put(TimeUtil.dateToYmd(twVacationView.getNaturalDate()), twVacationView.getWorkHours()));
        return TwOutputUtil.ok(map);
    }

    @PostMapping(value={"/save"})
    public TwOutputUtil saveVacation(@RequestBody List<Map<String, Float>> list) {
        ArrayList vacationPlayloadList = new ArrayList();
        list.forEach(o -> {
            Map map = o;
            Set keys = map.keySet();
            keys.forEach(key -> {
                VacationPlayload vacationPlayload = new VacationPlayload();
                vacationPlayload.setNaturalDate(TimeUtil.dateFromYmd(key));
                vacationPlayload.setWorkHours((Float)map.get(key));
                vacationPlayloadList.add(vacationPlayload);
            });
        });
        this.vacationService.saveVacation(vacationPlayloadList);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/saveJde"})
    public TwOutputUtil saveJdeExport(@RequestBody List<Map<String, Byte>> list) {
        ArrayList vacationPlayloadList = new ArrayList();
        list.forEach(o -> {
            Map map = o;
            Set keys = map.keySet();
            keys.forEach(key -> {
                VacationPlayload vacationPlayload = new VacationPlayload();
                vacationPlayload.setNaturalDate(TimeUtil.dateFromYmd(key));
                vacationPlayload.setJdeExportFlag((Byte)map.get(key));
                vacationPlayloadList.add(vacationPlayload);
            });
        });
        this.vacationService.saveJdeExport(vacationPlayloadList);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/findWorkLocalDay"})
    public TwOutputUtil findWorkLocalDay(String startDate, String endDate) {
        List workLocalDayList = this.vacationService.findWorkLocalDay(TimeUtil.dateFromYmd(startDate), TimeUtil.dateFromYmd(endDate));
        ArrayList mapList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)workLocalDayList)) {
            workLocalDayList.forEach(workLocalDay -> {
                HashMap<String, Comparable<ChronoLocalDate>> map = new HashMap<String, Comparable<ChronoLocalDate>>();
                map.put("naturalDate", (Comparable<ChronoLocalDate>)workLocalDay);
                map.put("workHours", Integer.valueOf(8));
                mapList.add(map);
            });
        }
        return TwOutputUtil.ok(mapList);
    }

    public VacationController(VacationService vacationService) {
        this.vacationService = vacationService;
    }
}

