/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyConfigService;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyDetailService;
import com.elitesland.tw.tw5.api.prd.my.service.AbnormalWorkApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyConfigVO;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalRoleResVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.TriggerConditionEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.TsEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.AbnormalWorkApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.AbnormalWorkApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.AbnormalWorkApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.AbnormalWorkApplyRepo;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AbnormalWorkApplyServiceImpl
extends BaseServiceImpl
implements AbnormalWorkApplyService {
    private static final Logger log = LoggerFactory.getLogger(AbnormalWorkApplyServiceImpl.class);
    private final AbnormalWorkApplyRepo abnormalWorkApplyRepo;
    private final AbnormalWorkApplyDAO abnormalWorkApplyDAO;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;
    private final AbnormalWorkApplyDetailService abnormalWorkApplyDetailService;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final AbnormalWorkApplyConfigService abnormalWorkApplyConfigService;

    public PagingVO<AbnormalWorkApplyVO> queryPaging(AbnormalWorkApplyQuery query) {
        return this.abnormalWorkApplyDAO.queryPaging(query);
    }

    public List<AbnormalWorkApplyVO> queryListDynamic(AbnormalWorkApplyQuery query) {
        return this.abnormalWorkApplyDAO.queryListDynamic(query);
    }

    public AbnormalWorkApplyVO queryByKey(Long key) {
        AbnormalWorkApplyDO entity = this.abnormalWorkApplyRepo.findById(key).orElseGet(AbnormalWorkApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AbnormalWorkApplyVO vo = AbnormalWorkApplyConvert.INSTANCE.toVo(entity);
        AbnormalWorkApplyDetailQuery abnormalWorkApplyDetailQuery = new AbnormalWorkApplyDetailQuery();
        abnormalWorkApplyDetailQuery.setApplyId(vo.getId());
        List abnormalWorkApplyDetailVOS = this.abnormalWorkApplyDetailService.queryListDynamic(abnormalWorkApplyDetailQuery);
        vo.setAbnormalWorkApplyDetailVOList(abnormalWorkApplyDetailVOS);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public AbnormalWorkApplyVO insertOrUpdate(AbnormalWorkApplyPayload payload) {
        String procInstId = null;
        if (payload.getId() != null) {
            AbnormalWorkApplyDO entity = this.abnormalWorkApplyRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyDO::new);
            if (entity.getId() == null) {
                throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728");
            }
            procInstId = entity.getProcInstId();
        } else {
            payload.setApplyDate(LocalDate.now());
        }
        AbnormalWorkApplyDO entityDo = AbnormalWorkApplyConvert.INSTANCE.toDo(payload);
        AbnormalWorkApplyDO save = (AbnormalWorkApplyDO)this.abnormalWorkApplyRepo.save(entityDo);
        payload.setId(save.getId());
        payload.setProcInstId(procInstId);
        this.dealDetailData(payload);
        if (payload.getSubmitFlag().booleanValue()) {
            if (!StringUtils.hasText((String)procInstId)) {
                this.startProcess(payload);
            } else {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                this.dealVariables(payload, variables);
                this.workflowUtil.setVariables(SetVariablesPayload.of((String)payload.getProcInstId(), variables));
            }
        }
        return AbnormalWorkApplyConvert.INSTANCE.toVo(save);
    }

    private void dealDetailData(AbnormalWorkApplyPayload payload) {
        if (!CollectionUtils.isEmpty((Collection)payload.getDeleteDetailKeys())) {
            this.abnormalWorkApplyDetailService.deleteSoft(payload.getDeleteDetailKeys());
        }
        if (!CollectionUtils.isEmpty((Collection)payload.getAbnormalWorkApplyDetailPayloadList())) {
            payload.getAbnormalWorkApplyDetailPayloadList().stream().forEach(p -> {
                if (p.getId() != null) {
                    this.abnormalWorkApplyDetailService.update(p);
                } else {
                    p.setApplyId(payload.getId());
                    this.abnormalWorkApplyDetailService.insert(p);
                }
            });
        }
    }

    void startProcess(AbnormalWorkApplyPayload payload) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.dealVariables(payload, variables);
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.cacheUtil.getUserDefaultOrg(payload.getApplyUserId());
        String procInstName = "A37." + ProcDefKey.ABNORMAL_WORK.getDesc() + "-" + prdOrgEmployeeRefVO.getEmployeeName() + "-" + payload.getApplyDate();
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.ABNORMAL_WORK.name(), (String)procInstName, (String)("" + payload.getId()), variables), new Long[0]);
        AbnormalWorkApplyPayload payload0 = new AbnormalWorkApplyPayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus().name());
        payload0.setParentUserId(prdOrgEmployeeRefVO.getParentId());
        this.transactionUtilService.executeWithRunnable(() -> this.abnormalWorkApplyDAO.updateByKeyDynamic(payload0));
    }

    public TsApprovalRoleResVO getApprovePersonData(String reasonType, Long reasonId, Long applyUserId) {
        PrdOrgOrganizationRefVO buLevel1;
        PrdOrgOrganizationVO org;
        TsApprovalRoleResVO roleResVO = new TsApprovalRoleResVO();
        PrdOrgEmployeeRefVO userDefaultOrg = this.cacheUtil.getUserDefaultOrg(applyUserId);
        roleResVO.setApprovalResId13(userDefaultOrg.getParentId());
        Long orgId = this.cacheUtil.getDefaultOrgIdByUserId(applyUserId);
        PrdOrgOrganizationVO buOrg = this.cacheUtil.getOrg(orgId);
        if (buOrg == null || buOrg.getManageId() == null) {
            throw TwException.error("", "\u7533\u8bf7\u4eba\u7684BU\u8d1f\u8d23\u4eba\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        roleResVO.setApprovalResId14(buOrg.getManageId());
        PrdOrgOrganizationRefVO buLevel1ByOrgId = this.cacheUtil.getBULevel1ByOrgId(orgId);
        if (buLevel1ByOrgId == null || buLevel1ByOrgId.getManageId() == null) {
            throw TwException.error("", "\u7533\u8bf7\u4eba\u7684\u4e8b\u4e1a\u90e8\u8d1f\u8d23\u4eba\u672a\u7ef4\u62a4\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        roleResVO.setApprovalResId15(buLevel1ByOrgId.getManageId());
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(reasonId);
            if (pmsProjectVO == null) {
                throw TwException.error("", "\u6240\u9009\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            roleResVO.setApprovalResId1(pmsProjectVO.getPmResId());
            roleResVO.setApprovalResId2(pmsProjectVO.getDeliUserId());
            org = this.cacheUtil.getOrg(pmsProjectVO.getDeliBuId());
            roleResVO.setApprovalResId3(org.getManageId());
            buLevel1 = this.cacheUtil.getBULevel1ByOrgId(pmsProjectVO.getDeliBuId());
            if (buLevel1 != null) {
                roleResVO.setApprovalResId4(buLevel1.getManageId());
            }
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
            PrdOrgOrganizationVO org2;
            PrdOrgOrganizationVO org1;
            CrmOpportunityQuery crmOpportunityQuery = new CrmOpportunityQuery();
            crmOpportunityQuery.setProjectId(reasonId);
            List crmOpportunityListVOS = this.opportunityService.queryListDynamic(crmOpportunityQuery);
            if (ObjectUtils.isEmpty((Object)crmOpportunityListVOS)) {
                throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            CrmOpportunityListVO crmOpportunityListVO = (CrmOpportunityListVO)crmOpportunityListVOS.get(0);
            roleResVO.setApprovalResId2(crmOpportunityListVO.getDeliUserId());
            roleResVO.setApprovalResId7(crmOpportunityListVO.getManageUserId());
            roleResVO.setApprovalResId8(crmOpportunityListVO.getPreSaleUserId());
            PrdOrgOrganizationVO org0 = this.cacheUtil.getOrg(crmOpportunityListVO.getOrgId());
            if (org0 != null) {
                roleResVO.setApprovalResId9(org0.getManageId());
                PrdOrgOrganizationRefVO buLevel12 = this.cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getOrgId());
                if (buLevel12 != null) {
                    roleResVO.setApprovalResId11(buLevel12.getManageId());
                }
            }
            if ((org1 = this.cacheUtil.getOrg(crmOpportunityListVO.getDeliOrgId())) != null) {
                roleResVO.setApprovalResId3(org1.getManageId());
                PrdOrgOrganizationRefVO buLevel13 = this.cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getDeliOrgId());
                if (buLevel13 != null) {
                    roleResVO.setApprovalResId4(buLevel13.getManageId());
                }
            }
            if ((org2 = this.cacheUtil.getOrg(crmOpportunityListVO.getPreSaleOrgId())) != null) {
                roleResVO.setApprovalResId10(org2.getManageId());
                PrdOrgOrganizationRefVO buLevel14 = this.cacheUtil.getBULevel1ByOrgId(crmOpportunityListVO.getPreSaleOrgId());
                if (buLevel14 != null) {
                    roleResVO.setApprovalResId12(buLevel14.getManageId());
                }
            }
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
            BuProjectVO buProjectVO = this.buProjectService.queryByKey(reasonId);
            if (ObjectUtils.isEmpty((Object)buProjectVO)) {
                throw TwException.error("", "\u6240\u9009BU\u9879\u76ee\u4e0d\u5b58\u5728");
            }
            roleResVO.setApprovalResId1(buProjectVO.getPmResId());
            roleResVO.setApprovalResId2(buProjectVO.getDeliUserId());
            org = this.cacheUtil.getOrg(buProjectVO.getDeliBuId());
            roleResVO.setApprovalResId3(org.getManageId());
            buLevel1 = this.cacheUtil.getBULevel1ByOrgId(buProjectVO.getDeliBuId());
            if (buLevel1 != null) {
                roleResVO.setApprovalResId4(buLevel1.getManageId());
            }
        }
        return roleResVO;
    }

    private AbnormalWorkApplyConfigVO getAbnormalWorkApplyConfig(AbnormalWorkApplyPayload payload) {
        AbnormalWorkApplyConfigQuery query = new AbnormalWorkApplyConfigQuery();
        query.setReasonType(payload.getReasonType());
        List abnormalWorkApplyConfigVOS = this.abnormalWorkApplyConfigService.queryListDynamic(query);
        if (CollectionUtils.isEmpty((Collection)abnormalWorkApplyConfigVOS)) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e3a" + payload.getReasonType() + "\u5ba1\u6279\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (AbnormalWorkApplyConfigVO abnormalWorkApplyConfigVO : abnormalWorkApplyConfigVOS) {
            if (TriggerConditionEnum.gt.getCode().equals(abnormalWorkApplyConfigVO.getTriggerCondition()) && payload.getDays().compareTo(abnormalWorkApplyConfigVO.getConditionDays()) > 0) {
                return abnormalWorkApplyConfigVO;
            }
            if (!TriggerConditionEnum.ltoe.getCode().equals(abnormalWorkApplyConfigVO.getTriggerCondition()) || payload.getDays().compareTo(abnormalWorkApplyConfigVO.getConditionDays()) > 0) continue;
            return abnormalWorkApplyConfigVO;
        }
        return null;
    }

    private void dealVariables(AbnormalWorkApplyPayload payload, HashMap<String, Object> variables) {
        TsApprovalRoleResVO tsApprovalRoleResVO = this.getApprovePersonData(payload.getReasonType(), payload.getReasonId(), payload.getApplyUserId());
        AbnormalWorkApplyConfigVO abnormalWorkApplyConfig = this.getAbnormalWorkApplyConfig(payload);
        if (abnormalWorkApplyConfig == null) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e3a" + payload.getReasonType() + "\u5ba1\u6279\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long approalRes1 = this.initApproalRes(tsApprovalRoleResVO, abnormalWorkApplyConfig.getFirstApprovePerson());
        variables.put("Activity_0azqyzb", approalRes1);
        Long approalRes2 = this.initApproalRes(tsApprovalRoleResVO, abnormalWorkApplyConfig.getTwiceApprovePerson());
        variables.put("Activity_0qqprdg", approalRes2);
        Long approalRes3 = this.initApproalRes(tsApprovalRoleResVO, abnormalWorkApplyConfig.getThirdApprovePerson());
        variables.put("Activity_05v4uu0", approalRes3);
        Long approalRes4 = this.initApproalRes(tsApprovalRoleResVO, abnormalWorkApplyConfig.getFourthApprovePerson());
        variables.put("Activity_0gcfltl", approalRes4);
    }

    Long initApproalRes(TsApprovalRoleResVO roleResVO, String approvalSource) {
        TsEnum.TsBussinessRole tsBussinessRole = TsEnum.TsBussinessRole.valueOf(approvalSource);
        Long approvalResId = null;
        switch (tsBussinessRole) {
            case business_role1: {
                approvalResId = roleResVO.getApprovalResId1();
                break;
            }
            case business_role2: {
                approvalResId = roleResVO.getApprovalResId2();
                break;
            }
            case business_role3: {
                approvalResId = roleResVO.getApprovalResId3();
                break;
            }
            case business_role4: {
                approvalResId = roleResVO.getApprovalResId4();
                break;
            }
            case business_role5: {
                approvalResId = roleResVO.getApprovalResId5();
                break;
            }
            case business_role6: {
                approvalResId = roleResVO.getApprovalResId6();
                break;
            }
            case business_role7: {
                approvalResId = roleResVO.getApprovalResId7();
                break;
            }
            case business_role8: {
                approvalResId = roleResVO.getApprovalResId8();
                break;
            }
            case business_role9: {
                approvalResId = roleResVO.getApprovalResId9();
                break;
            }
            case business_role10: {
                approvalResId = roleResVO.getApprovalResId10();
                break;
            }
            case business_role11: {
                approvalResId = roleResVO.getApprovalResId11();
                break;
            }
            case business_role12: {
                approvalResId = roleResVO.getApprovalResId12();
                break;
            }
            case business_role13: {
                approvalResId = roleResVO.getApprovalResId13();
                break;
            }
            case business_role14: {
                approvalResId = roleResVO.getApprovalResId14();
                break;
            }
            case business_role15: {
                approvalResId = roleResVO.getApprovalResId15();
            }
        }
        return approvalResId;
    }

    @Transactional(rollbackFor={Exception.class})
    public AbnormalWorkApplyVO update(AbnormalWorkApplyPayload payload) {
        AbnormalWorkApplyDO entity = this.abnormalWorkApplyRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AbnormalWorkApplyDO entityDo = AbnormalWorkApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AbnormalWorkApplyConvert.INSTANCE.toVo((AbnormalWorkApplyDO)this.abnormalWorkApplyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(AbnormalWorkApplyPayload payload) {
        AbnormalWorkApplyDO entity = this.abnormalWorkApplyRepo.findById(payload.getId()).orElseGet(AbnormalWorkApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.abnormalWorkApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.abnormalWorkApplyDAO.deleteSoft(keys);
        }
    }

    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        AbnormalWorkApplyPayload payload0 = new AbnormalWorkApplyPayload();
        payload0.setId(applyId);
        payload0.setProcInstStatus(procInstStatus.name());
        this.abnormalWorkApplyDAO.updateByKeyDynamic(payload0);
    }

    public AbnormalWorkApplyServiceImpl(AbnormalWorkApplyRepo abnormalWorkApplyRepo, AbnormalWorkApplyDAO abnormalWorkApplyDAO, WorkflowUtil workflowUtil, CacheUtil cacheUtil, TransactionUtilService transactionUtilService, AbnormalWorkApplyDetailService abnormalWorkApplyDetailService, PmsProjectService pmsProjectService, BuProjectService buProjectService, CrmOpportunityService opportunityService, AbnormalWorkApplyConfigService abnormalWorkApplyConfigService) {
        this.abnormalWorkApplyRepo = abnormalWorkApplyRepo;
        this.abnormalWorkApplyDAO = abnormalWorkApplyDAO;
        this.workflowUtil = workflowUtil;
        this.cacheUtil = cacheUtil;
        this.transactionUtilService = transactionUtilService;
        this.abnormalWorkApplyDetailService = abnormalWorkApplyDetailService;
        this.pmsProjectService = pmsProjectService;
        this.buProjectService = buProjectService;
        this.opportunityService = opportunityService;
        this.abnormalWorkApplyConfigService = abnormalWorkApplyConfigService;
    }
}

