/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RestStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.entity.OvertimeApplicationDO;
import com.elitesland.tw.tw5.server.prd.my.entity.ProjectDO;
import com.elitesland.tw.tw5.server.prd.my.query.OvertimeApplicationQuery;
import com.elitesland.tw.tw5.server.prd.my.repo.ProjectRepo;
import com.elitesland.tw.tw5.server.prd.my.vo.ApproveLeaderDTO;
import com.elitesland.tw.tw5.server.prd.my.vo.OvertimeApplicationVO;
import com.elitesland.tw.tw5.server.prd.org.convert.OvertimeApplicationConvert;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRepo;
import com.elitesland.tw.tw5.server.prd.work.dao.OvertimeApplicationDAO;
import com.elitesland.tw.tw5.server.prd.work.repo.OvertimeApplicationRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OvertimeApplicationServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(OvertimeApplicationServiceImpl.class);
    private final WorkflowUtil workflowUtil;
    private final OvertimeApplicationDAO overtimeApplicationDAO;
    private final OvertimeApplicationRepo overtimeApplicationRepo;
    private final ProjectRepo projectRepo;
    private final PrdOrgEmployeeRepo prdOrgEmployeeRepo;

    public Long submitOvertime(OvertimeApplicationVO overtimeApplicationVO) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        overtimeApplicationVO.setUserId(loginUserId);
        LocalDate overtimeWorkDate = overtimeApplicationVO.getOvertimeWorkDate();
        ArrayList<String> approveStatusList = new ArrayList<String>();
        approveStatusList.add(WorkFlowStatusEnum.APPROVED.getCode());
        approveStatusList.add(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        approveStatusList.add(WorkFlowStatusEnum.CREATE_WORK.getCode());
        if (this.overtimeApplicationRepo.existsByOvertimeWorkDateAndUserIdAndApproveStatusIn(overtimeWorkDate, loginUserId, approveStatusList)) {
            throw TwException.error("500", "\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\u7533\u8bf7");
        }
        ApproveLeaderDTO approveLeader = this.overtimeApplicationDAO.getApproveLeader(overtimeApplicationVO);
        if (approveLeader == null) {
            throw TwException.error("500", "\u8be5\u6d41\u7a0b\u5ba1\u6279\u4eba\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!");
        }
        OvertimeApplicationDO overtimeApplicationDO = new OvertimeApplicationDO();
        overtimeApplicationDO.setOvertimeWorkDate(overtimeWorkDate);
        overtimeApplicationDO.setOvertimeWorkDesc(overtimeApplicationVO.getOvertimeWorkDesc());
        overtimeApplicationDO.setOvertimeWorkHour(overtimeApplicationVO.getOvertimeWorkHour());
        overtimeApplicationDO.setProjectId(overtimeApplicationVO.getProjectId());
        overtimeApplicationDO.setUserId(overtimeApplicationVO.getUserId());
        overtimeApplicationDO.setRestStatus(RestStatusEnum.CREATE.getCode());
        overtimeApplicationDO.setApproveStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        OvertimeApplicationDO save = (OvertimeApplicationDO)((Object)this.overtimeApplicationRepo.save((Object)overtimeApplicationDO));
        HashMap<String, ArrayList> variables = new HashMap<String, ArrayList>();
        Long userId = overtimeApplicationVO.getProjectId() == 0L ? approveLeader.getDisterUserId() : approveLeader.getPmUserId();
        variables.put("Activity_0hzxl2f", CollUtil.newArrayList((Object[])new Long[]{userId}));
        variables.put("Activity_19biraq", CollUtil.newArrayList((Object[])new Long[]{approveLeader.getParentUserId()}));
        variables.put("Activity_0ko02kn", CollUtil.newArrayList((Object[])new Long[]{approveLeader.getManageUserId()}));
        log.info("\u52a0\u73ed\u7533\u8bf7\u5ba1\u6279\u4eba------------====" + approveLeader);
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OVERTIME_APPLICATION.name(), (String)(overtimeApplicationVO.getOvertimeWorkDate() + "\u5de5\u4f5c\u8ba1\u5212\u7533\u8bf7\u6d41\u7a0b"), (String)("" + save.getId()), variables), new Long[0]);
        overtimeApplicationDO.setProcessInstanceId(processInfo.getProcInstId());
        this.overtimeApplicationDAO.updateById(overtimeApplicationDO);
        return save.getId();
    }

    public OvertimeApplicationVO findOvertimeApplicationById(Long id) {
        Optional byId = this.overtimeApplicationRepo.findById(id);
        if (byId.isPresent()) {
            OvertimeApplicationDO overtimeApplicationDO = (OvertimeApplicationDO)((Object)byId.get());
            OvertimeApplicationVO overtimeApplicationVO = OvertimeApplicationConvert.INSTANCE.toDo(overtimeApplicationDO);
            Optional<ProjectDO> byProjIdV4 = this.projectRepo.findByProjIdV4(overtimeApplicationVO.getProjectId());
            overtimeApplicationVO.setProjectName(byProjIdV4.get().getProjName());
            String employeeName = this.prdOrgEmployeeRepo.queryEmployeeNameByUserId(overtimeApplicationVO.getUserId());
            overtimeApplicationVO.setUserName(employeeName);
            return overtimeApplicationVO;
        }
        return null;
    }

    public PagingVO<OvertimeApplicationVO> findOvertimeApplicationPage(OvertimeApplicationQuery query) {
        return this.overtimeApplicationDAO.queryPaging(query);
    }

    public List<OvertimeApplicationVO> findAvailableOvertimeApplications() {
        List<OvertimeApplicationVO> list = this.overtimeApplicationDAO.findAvailableOvertimeApplications();
        return list;
    }

    public OvertimeApplicationServiceImpl(WorkflowUtil workflowUtil, OvertimeApplicationDAO overtimeApplicationDAO, OvertimeApplicationRepo overtimeApplicationRepo, ProjectRepo projectRepo, PrdOrgEmployeeRepo prdOrgEmployeeRepo) {
        this.workflowUtil = workflowUtil;
        this.overtimeApplicationDAO = overtimeApplicationDAO;
        this.overtimeApplicationRepo = overtimeApplicationRepo;
        this.projectRepo = projectRepo;
        this.prdOrgEmployeeRepo = prdOrgEmployeeRepo;
    }
}

