/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.RewardLeaveApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveAppliedQuery;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.query.RewardLeaveConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.service.RewardLeaveApplyService;
import com.elitesland.tw.tw5.api.prd.my.service.RewardLeaveConfigService;
import com.elitesland.tw.tw5.api.prd.my.service.UserVacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardAppliedDaysVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveApplyVO;
import com.elitesland.tw.tw5.api.prd.my.vo.RewardLeaveConfigVO;
import com.elitesland.tw.tw5.api.prd.my.vo.UserVacationVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.RewardLeaveApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.convert.RewardLeaveApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.RewardLeaveApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.RewardLeaveApplyDO;
import com.elitesland.tw.tw5.server.prd.my.entity.RewardLeaveApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.my.repo.RewardLeaveApplyRepo;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskSourceTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class RewardLeaveApplyServiceImpl
extends BaseServiceImpl
implements RewardLeaveApplyService {
    private static final Logger log = LoggerFactory.getLogger(RewardLeaveApplyServiceImpl.class);
    private final RewardLeaveApplyRepo rewardLeaveApplyRepo;
    private final RewardLeaveApplyDAO rewardLeaveApplyDAO;
    private final RewardLeaveConfigService rewardLeaveConfigService;
    private final WorkflowUtil workflowUtil;
    private final PmsProjectService pmsProjectService;
    private final CrmOpportunityService crmOpportunityService;
    private final CacheUtil cacheUtil;
    private final RewardLeaveApplyDetailDAO rewardLeaveApplyDetailDAO;
    private final TaskInfoService taskInfoService;
    private final UserVacationService userVacationService;
    private final UdcUtil udcUtil;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;

    public PagingVO<RewardLeaveApplyVO> queryPaging(RewardLeaveApplyQuery query) {
        return this.rewardLeaveApplyDAO.queryPaging(query);
    }

    public List<RewardLeaveApplyVO> queryListDynamic(RewardLeaveApplyQuery query) {
        return this.rewardLeaveApplyDAO.queryListDynamic(query);
    }

    public RewardLeaveApplyVO queryByKey(Long key) {
        RewardLeaveApplyDO entity = this.rewardLeaveApplyRepo.findById(key).orElseGet(RewardLeaveApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        RewardLeaveApplyVO vo = RewardLeaveApplyConvert.INSTANCE.toVo(entity);
        RewardLeaveApplyDetailQuery detailQuery = new RewardLeaveApplyDetailQuery();
        detailQuery.setApplyId(entity.getId());
        List rewardLeaveApplyDetailVOList = this.rewardLeaveApplyDetailDAO.queryListDynamic(detailQuery);
        rewardLeaveApplyDetailVOList = this.udcUtil.translateList(rewardLeaveApplyDetailVOList);
        vo.setDetailVOList(rewardLeaveApplyDetailVOList);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public RewardLeaveApplyVO insert(RewardLeaveApplyPayload payload) {
        RewardLeaveApplyDO entityDo = RewardLeaveApplyConvert.INSTANCE.toDo(payload);
        RewardLeaveApplyVO rewardLeaveApplyVO = RewardLeaveApplyConvert.INSTANCE.toVo((RewardLeaveApplyDO)((Object)this.rewardLeaveApplyRepo.save((Object)entityDo)));
        List rewardLeaveApplyDetailPayloadList = payload.getDetailPayloadList();
        for (RewardLeaveApplyDetailPayload rewardLeaveApplyDetailPayload : rewardLeaveApplyDetailPayloadList) {
            rewardLeaveApplyDetailPayload.setId(null);
            rewardLeaveApplyDetailPayload.setApplyId(rewardLeaveApplyVO.getId());
        }
        List<RewardLeaveApplyDetailDO> detailDOS = RewardLeaveApplyDetailConvert.INSTANCE.toDos(rewardLeaveApplyDetailPayloadList);
        this.rewardLeaveApplyDetailDAO.saveAll(detailDOS);
        return rewardLeaveApplyVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public RewardLeaveApplyVO update(RewardLeaveApplyPayload payload) {
        RewardLeaveApplyDO entity = this.rewardLeaveApplyRepo.findById(payload.getId()).orElseGet(RewardLeaveApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        RewardLeaveApplyDO entityDo = RewardLeaveApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        RewardLeaveApplyVO rewardLeaveApplyVO = RewardLeaveApplyConvert.INSTANCE.toVo((RewardLeaveApplyDO)((Object)this.rewardLeaveApplyRepo.save((Object)entity)));
        RewardLeaveApplyDetailQuery detailQuery = new RewardLeaveApplyDetailQuery();
        detailQuery.setApplyId(entity.getId());
        List<RewardLeaveApplyDetailVO> rewardLeaveApplyDetailVOList = this.rewardLeaveApplyDetailDAO.queryListDynamic(detailQuery);
        List<Long> detailIdList = rewardLeaveApplyDetailVOList.stream().map(e -> e.getId()).collect(Collectors.toList());
        this.rewardLeaveApplyDetailDAO.deleteSoft(detailIdList);
        List rewardLeaveApplyDetailPayloadList = payload.getDetailPayloadList();
        for (RewardLeaveApplyDetailPayload rewardLeaveApplyDetailPayload : rewardLeaveApplyDetailPayloadList) {
            rewardLeaveApplyDetailPayload.setId(null);
            rewardLeaveApplyDetailPayload.setApplyId(rewardLeaveApplyVO.getId());
        }
        List<RewardLeaveApplyDetailDO> detailDOS = RewardLeaveApplyDetailConvert.INSTANCE.toDos(rewardLeaveApplyDetailPayloadList);
        this.rewardLeaveApplyDetailDAO.saveAll(detailDOS);
        TaskPayload taskPayload = new TaskPayload();
        taskPayload.setReasonId(payload.getReasonId());
        taskPayload.setReasonType(payload.getReasonType());
        taskPayload.setSourceType(TaskSourceTypeEnum.REWARD.getCode());
        taskPayload.setReasonName(payload.getReasonName());
        taskPayload.setSourceId(rewardLeaveApplyVO.getId());
        taskPayload.setPlanStartDate(payload.getPlanStartDate());
        taskPayload.setPlanEndDate(payload.getPlanEndDate());
        ArrayList<TaskInfoPayload> taskInfoPayloads = new ArrayList<TaskInfoPayload>();
        for (RewardLeaveApplyDetailPayload rewardLeaveApplyDetailPayload : rewardLeaveApplyDetailPayloadList) {
            TaskInfoPayload taskInfoPayload = new TaskInfoPayload();
            taskInfoPayload.setTaskResId(rewardLeaveApplyDetailPayload.getUserId());
            taskInfoPayload.setPlanEqva(rewardLeaveApplyDetailPayload.getEqva());
            taskInfoPayloads.add(taskInfoPayload);
        }
        taskPayload.setTaskInfoPayloads(taskInfoPayloads);
        this.taskInfoService.taskAutoCreate(taskPayload);
        return rewardLeaveApplyVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(RewardLeaveApplyPayload payload) {
        RewardLeaveApplyDO entity = this.rewardLeaveApplyRepo.findById(payload.getId()).orElseGet(RewardLeaveApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.rewardLeaveApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.rewardLeaveApplyDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public RewardLeaveApplyVO submit(RewardLeaveApplyPayload payload) {
        String setAsString;
        RewardLeaveConfigVO configVO;
        RewardLeaveConfigQuery configQuery = new RewardLeaveConfigQuery();
        List configVOList = new ArrayList();
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            configQuery.setProjectId(payload.getReasonId());
            configQuery.setLeaveYear(Long.valueOf(LocalDate.now().getYear()));
            configVOList = this.rewardLeaveConfigService.queryListDynamic(configQuery);
        }
        if (!ObjectUtils.isEmpty(configVOList)) {
            configVO = (RewardLeaveConfigVO)configVOList.get(0);
        } else {
            RewardLeaveConfigQuery configQueryBU = new RewardLeaveConfigQuery();
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                PmsProjectVO projectVO = this.pmsProjectService.queryByKey(payload.getReasonId());
                Long deliBuId = projectVO.getDeliBuId();
                configQueryBU.setDeliBuId(deliBuId);
            }
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                CrmOpportunityQuery query = new CrmOpportunityQuery();
                query.setProjectId(payload.getReasonId());
                List crmOpportunityListVOS = this.opportunityService.queryListDynamic(query);
                if (!ObjectUtils.isEmpty((Object)crmOpportunityListVOS)) {
                    configQueryBU.setDeliBuId(((CrmOpportunityListVO)crmOpportunityListVOS.get(0)).getPreSaleOrgId());
                } else {
                    throw new BusinessException("\u5546\u673a\u9879\u76ee:" + payload.getReasonName() + "\u4e0d\u5b58\u5728");
                }
            }
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
                BuProjectVO buProjectVO = this.buProjectService.queryByKey(payload.getReasonId());
                configQueryBU.setDeliBuId(buProjectVO.getDeliBuId());
            }
            configQueryBU.setLeaveYear(Long.valueOf(LocalDate.now().getYear()));
            List otConfigVOList = this.rewardLeaveConfigService.queryBuConfig(configQueryBU);
            if (ObjectUtils.isEmpty((Object)otConfigVOList)) {
                throw new BusinessException("\u8be5\u4e8b\u7531\u672a\u914d\u7f6e\u6709\u5173\u5956\u52b1\u5047\u89c4\u5219");
            }
            configVO = (RewardLeaveConfigVO)otConfigVOList.get(0);
        }
        if (!ObjectUtils.isEmpty((Object)configVO.getJobGradeList())) {
            List<String> jobGradeList = Arrays.asList(configVO.getJobGradeList().split(","));
            configVO.setJobGrades(jobGradeList);
        }
        if (!ObjectUtils.isEmpty((Object)configVO.getJobGrade2List())) {
            List<String> jobGrade2List = Arrays.asList(configVO.getJobGrade2List().split(","));
            configVO.setJobGrades2(jobGrade2List);
        }
        List detailPayloadList = payload.getDetailPayloadList();
        HashMap<Long, RewardLeaveApplyDetailPayload> userApplyDaysMap = new HashMap<Long, RewardLeaveApplyDetailPayload>();
        for (RewardLeaveApplyDetailPayload detailPayload : detailPayloadList) {
            RewardLeaveApplyDetailPayload applyDetailPayload;
            RewardLeaveApplyDetailQuery detailQuery = new RewardLeaveApplyDetailQuery();
            detailQuery.setUserId(detailPayload.getUserId());
            detailQuery.setReasonType(payload.getReasonType());
            detailQuery.setReasonId(payload.getReasonId());
            detailQuery.setWorkDate(detailPayload.getWorkDate());
            Object appliedDays = BigDecimal.ZERO;
            if (!ObjectUtils.isEmpty((Object)this.rewardLeaveApplyDAO.countApplyDaysByDate(detailQuery))) {
                appliedDays = this.rewardLeaveApplyDAO.countApplyDaysByDate(detailQuery);
            }
            if (((BigDecimal)appliedDays).add(detailPayload.getDays()).compareTo(BigDecimal.ONE) > 0) {
                throw new BusinessException(this.cacheUtil.getUserName(detailPayload.getUserId()) + " " + detailPayload.getWorkDate() + " \u5956\u52b1\u5047\u7533\u8bf7\u5929\u6570\u8d85\u8fc71\u5929");
            }
            if (userApplyDaysMap.containsKey(detailPayload.getUserId())) {
                applyDetailPayload = (RewardLeaveApplyDetailPayload)userApplyDaysMap.get(detailPayload.getUserId());
                BigDecimal totalApplyDays = detailPayload.getDays().add(applyDetailPayload.getDays());
                applyDetailPayload.setDays(totalApplyDays);
                userApplyDaysMap.put(detailPayload.getUserId(), applyDetailPayload);
                continue;
            }
            applyDetailPayload = new RewardLeaveApplyDetailPayload();
            applyDetailPayload.setDays(detailPayload.getDays());
            applyDetailPayload.setAppliedDays(detailPayload.getAppliedDays());
            applyDetailPayload.setJobGrade(detailPayload.getJobGrade());
            applyDetailPayload.setJobGrade2(detailPayload.getJobGrade2());
            applyDetailPayload.setUserId(detailPayload.getUserId());
            userApplyDaysMap.put(detailPayload.getUserId(), applyDetailPayload);
        }
        HashSet<String> jobGradeUserList = new HashSet<String>();
        HashSet<String> applyDaysUserSet = new HashSet<String>();
        Long loginUserId = GlobalUtil.getLoginUserId();
        for (Long key : userApplyDaysMap.keySet()) {
            RewardLeaveApplyDetailPayload value = (RewardLeaveApplyDetailPayload)userApplyDaysMap.get(key);
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                PmsProjectVO projectVO = this.pmsProjectService.queryByKey(payload.getReasonId());
                Long pmUserId = projectVO.getPmResId();
                Long deliUserId = projectVO.getDeliUserId();
                if (!Objects.equals(loginUserId, deliUserId) && Objects.equals(value.getUserId(), pmUserId)) {
                    throw new BusinessException("\u9879\u76ee\u7ecf\u7406\u7684\u5956\u52b1\u5047\u8bf7\u8054\u7cfb\u4ea4\u4ed8\u8d1f\u8d23\u4eba\u53d1\u8d77");
                }
            }
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                CrmOpportunityQuery query = new CrmOpportunityQuery();
                query.setProjectId(payload.getReasonId());
                List crmOpportunityListVOS = this.opportunityService.queryListDynamic(query);
                if (!ObjectUtils.isEmpty((Object)crmOpportunityListVOS)) {
                    Long preSaleUserId = ((CrmOpportunityListVO)crmOpportunityListVOS.get(0)).getPreSaleUserId();
                    Long preSaleOrgId = ((CrmOpportunityListVO)crmOpportunityListVOS.get(0)).getPreSaleOrgId();
                    PrdOrgOrganizationVO orgOrganizationVO = this.cacheUtil.getOrg(preSaleOrgId);
                    Long manageId = orgOrganizationVO.getManageId();
                    if (!Objects.equals(loginUserId, manageId) && Objects.equals(value.getUserId(), preSaleUserId)) {
                        throw new BusinessException("\u552e\u524d\u8d1f\u8d23\u4eba\u7684\u5956\u52b1\u5047\u8bf7\u8054\u7cfb\u552e\u524dBU Leader\u53d1\u8d77");
                    }
                }
            }
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
                BuProjectVO buProjectVO = this.buProjectService.queryByKey(payload.getReasonId());
                Long buProjectPmUserId = buProjectVO.getPmResId();
                Long buProjectDeliUserId = buProjectVO.getDeliUserId();
                if (!Objects.equals(loginUserId, buProjectDeliUserId) && Objects.equals(value.getUserId(), buProjectPmUserId)) {
                    throw new BusinessException("\u9879\u76ee\u7ecf\u7406\u7684\u5956\u52b1\u5047\u8bf7\u8054\u7cfb\u4ea4\u4ed8\u8d1f\u8d23\u4eba\u53d1\u8d77");
                }
            }
            String userName = this.cacheUtil.getUserName(key);
            BigDecimal appliedDays = BigDecimal.ZERO;
            if (!ObjectUtils.isEmpty((Object)configVO.getJobGrades()) && !configVO.getJobGrades().contains(value.getJobGrade())) {
                jobGradeUserList.add(userName);
            }
            if (!(ObjectUtils.isEmpty((Object)configVO.getJobGrades2()) || ObjectUtils.isEmpty((Object)value.getJobGrade2()) || configVO.getJobGrades2().contains(value.getJobGrade2()))) {
                jobGradeUserList.add(userName);
            }
            if (!ObjectUtils.isEmpty((Object)value.getAppliedDays())) {
                appliedDays = value.getAppliedDays();
            }
            if (appliedDays.add(value.getDays()).compareTo(configVO.getLeaveDaysUp()) <= 0) continue;
            applyDaysUserSet.add(userName);
        }
        if (!ObjectUtils.isEmpty(jobGradeUserList)) {
            setAsString = String.join((CharSequence)", ", jobGradeUserList);
            throw new BusinessException(setAsString + ":\u804c\u7ea7\u4e0d\u5728\u914d\u7f6e\u89c4\u5219\u5185");
        }
        if (!ObjectUtils.isEmpty(applyDaysUserSet)) {
            setAsString = String.join((CharSequence)", ", applyDaysUserSet);
            throw new BusinessException(setAsString + ":\u7533\u8bf7\u5929\u6570\u8d85\u8fc7\u4e0a\u9650");
        }
        if (payload.getId() == null) {
            Long manageId;
            PrdOrgOrganizationVO orgOrganizationVO;
            RewardLeaveApplyVO rewardLeaveApplyVO = this.insert(payload);
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode()) || payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                TaskPayload taskPayload = new TaskPayload();
                taskPayload.setReasonId(payload.getReasonId());
                taskPayload.setReasonType(payload.getReasonType());
                taskPayload.setReasonName(payload.getReasonName());
                taskPayload.setSourceType(TaskSourceTypeEnum.REWARD.getCode());
                taskPayload.setSourceId(rewardLeaveApplyVO.getId());
                taskPayload.setPlanStartDate(payload.getPlanStartDate());
                taskPayload.setPlanEndDate(payload.getPlanEndDate());
                ArrayList<TaskInfoPayload> taskInfoPayloads = new ArrayList<TaskInfoPayload>();
                for (RewardLeaveApplyDetailPayload rewardLeaveApplyDetailPayload : payload.getDetailPayloadList()) {
                    TaskInfoPayload taskInfoPayload = new TaskInfoPayload();
                    taskInfoPayload.setTaskResId(rewardLeaveApplyDetailPayload.getUserId());
                    taskInfoPayload.setPlanEqva(rewardLeaveApplyDetailPayload.getEqva());
                    taskInfoPayloads.add(taskInfoPayload);
                }
                taskPayload.setTaskInfoPayloads(taskInfoPayloads);
                this.taskInfoService.taskAutoCreate(taskPayload);
            }
            HashMap<String, ArrayList> variables = new HashMap<String, ArrayList>();
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                PmsProjectVO projectVO = this.pmsProjectService.queryByKey(payload.getReasonId());
                Long deliBuId = projectVO.getDeliBuId();
                orgOrganizationVO = this.cacheUtil.getOrg(deliBuId);
                manageId = orgOrganizationVO.getManageId();
                variables.put("Activity_0utz02i", CollUtil.newArrayList((Object[])new Long[]{manageId}));
            }
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                CrmOpportunityVO crmOpportunityVO = this.crmOpportunityService.queryByKey(payload.getReasonId());
                Long preSaleOrgId = crmOpportunityVO.getPreSaleOrgId();
                orgOrganizationVO = this.cacheUtil.getOrg(preSaleOrgId);
                manageId = orgOrganizationVO.getManageId();
                variables.put("Activity_0utz02i", CollUtil.newArrayList((Object[])new Long[]{manageId}));
            }
            if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
                BuProjectVO buProjectVO = this.buProjectService.queryByKey(payload.getReasonId());
                PrdOrgOrganizationVO orgOrganizationVO2 = this.cacheUtil.getOrg(buProjectVO.getBuId());
                variables.put("Activity_0utz02i", CollUtil.newArrayList((Object[])new Long[]{orgOrganizationVO2.getManageId()}));
            }
            ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.REWARD_LEAVE_APPLY.name(), (String)("\u5956\u52b1\u5047\u7533\u8bf7\u6d41\u7a0b-" + payload.getReasonName()), (String)("" + rewardLeaveApplyVO.getId()), variables), new Long[0]);
            RewardLeaveApplyPayload procInstUpdate = new RewardLeaveApplyPayload();
            procInstUpdate.setId(rewardLeaveApplyVO.getId());
            procInstUpdate.setProcInstStatus(ProcInstStatus.APPROVING);
            procInstUpdate.setProcInstId(processInfo.getProcInstId());
            this.updateByKeyDynamic(procInstUpdate);
            return rewardLeaveApplyVO;
        }
        return this.update(payload);
    }

    public List<RewardLeaveApplyDetailVO> queryAll(RewardLeaveApplyDetailQuery query) {
        return this.rewardLeaveApplyDAO.queryAll(query);
    }

    public List<RewardLeaveApplyDetailVO> queryRewardDetailByVacationId(Long vacationId) {
        UserVacationVO userVacationVO = this.userVacationService.queryById(vacationId);
        RewardLeaveApplyDetailQuery query = new RewardLeaveApplyDetailQuery();
        query.setUserId(userVacationVO.getUserId());
        query.setReasonId(userVacationVO.getReasonId());
        query.setReasonType(userVacationVO.getReasonType());
        List<RewardLeaveApplyDetailVO> rewardLeaveApplyDetailVOList = this.queryAll(query);
        for (RewardLeaveApplyDetailVO rewardLeaveApplyDetailVO : rewardLeaveApplyDetailVOList) {
            PrdOrgEmployeeVO employeeVO = this.cacheUtil.getEmployee(userVacationVO.getUserId());
            rewardLeaveApplyDetailVO.setExtString5(employeeVO.getExtString5());
        }
        return rewardLeaveApplyDetailVOList;
    }

    public List<RewardAppliedDaysVO> countDaysByUserAndReason(RewardLeaveAppliedQuery query) {
        ArrayList<RewardAppliedDaysVO> rewardAppliedDaysVOList = new ArrayList<RewardAppliedDaysVO>();
        for (Long userId : query.getUserIdList()) {
            RewardLeaveApplyDetailQuery detailQuery = new RewardLeaveApplyDetailQuery();
            detailQuery.setUserId(userId);
            detailQuery.setReasonType(query.getReasonType());
            detailQuery.setReasonId(query.getReasonId());
            BigDecimal appliedDays = this.rewardLeaveApplyDAO.queryAppliedDays(detailQuery);
            RewardAppliedDaysVO rewardAppliedDaysVO = new RewardAppliedDaysVO();
            rewardAppliedDaysVO.setUserId(userId);
            rewardAppliedDaysVO.setAppliedDays(appliedDays);
            rewardAppliedDaysVOList.add(rewardAppliedDaysVO);
        }
        return rewardAppliedDaysVOList;
    }

    public RewardLeaveApplyServiceImpl(RewardLeaveApplyRepo rewardLeaveApplyRepo, RewardLeaveApplyDAO rewardLeaveApplyDAO, RewardLeaveConfigService rewardLeaveConfigService, WorkflowUtil workflowUtil, PmsProjectService pmsProjectService, CrmOpportunityService crmOpportunityService, CacheUtil cacheUtil, RewardLeaveApplyDetailDAO rewardLeaveApplyDetailDAO, TaskInfoService taskInfoService, UserVacationService userVacationService, UdcUtil udcUtil, BuProjectService buProjectService, CrmOpportunityService opportunityService) {
        this.rewardLeaveApplyRepo = rewardLeaveApplyRepo;
        this.rewardLeaveApplyDAO = rewardLeaveApplyDAO;
        this.rewardLeaveConfigService = rewardLeaveConfigService;
        this.workflowUtil = workflowUtil;
        this.pmsProjectService = pmsProjectService;
        this.crmOpportunityService = crmOpportunityService;
        this.cacheUtil = cacheUtil;
        this.rewardLeaveApplyDetailDAO = rewardLeaveApplyDetailDAO;
        this.taskInfoService = taskInfoService;
        this.userVacationService = userVacationService;
        this.udcUtil = udcUtil;
        this.buProjectService = buProjectService;
        this.opportunityService = opportunityService;
    }
}

