/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TPermissionApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TPermissionApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TPermissionApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TPermissionApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TPermissionApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TPermissionApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TPermissionApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TPermissionApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class TPermissionApplyServiceImpl
implements TPermissionApplyService {
    private static final Logger log = LoggerFactory.getLogger(TPermissionApplyServiceImpl.class);
    private final TPermissionApplyRepo tPermissionApplyRepo;
    private final TPermissionApplyDAO tPermissionApplyDAO;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdSystemRoleDAO systemRoleDAO;

    public PagingVO<TPermissionApplyVO> queryPaging(TPermissionApplyQuery query) {
        return this.tPermissionApplyDAO.queryPaging(query);
    }

    public List<TPermissionApplyVO> queryListDynamic(TPermissionApplyQuery query) {
        return this.tPermissionApplyDAO.queryListDynamic(query);
    }

    public TPermissionApplyVO queryByKey(Long key) {
        TPermissionApplyDO entity = this.tPermissionApplyRepo.findById(key).orElseGet(TPermissionApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TPermissionApplyVO vo = TPermissionApplyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TPermissionApplyVO insert(TPermissionApplyPayload payload) {
        TPermissionApplyDO entityDo = TPermissionApplyConvert.INSTANCE.toDo(payload);
        TPermissionApplyDO save = (TPermissionApplyDO)this.tPermissionApplyRepo.save(entityDo);
        this.permissionApplyProc(save);
        return TPermissionApplyConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public TPermissionApplyVO update(TPermissionApplyPayload payload) {
        TPermissionApplyDO entity = this.tPermissionApplyRepo.findById(payload.getId()).orElseGet(TPermissionApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TPermissionApplyDO entityDo = TPermissionApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TPermissionApplyConvert.INSTANCE.toVo((TPermissionApplyDO)this.tPermissionApplyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(TPermissionApplyPayload payload) {
        TPermissionApplyDO entity = this.tPermissionApplyRepo.findById(payload.getId()).orElseGet(TPermissionApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.tPermissionApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.tPermissionApplyDAO.deleteSoft(keys);
        }
    }

    private void permissionApplyProc(TPermissionApplyDO permissionApplyDO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.CREATE_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            Long applyResId = permissionApplyDO.getApplyResId();
            String applyResName = this.cacheUtil.getUserName(applyResId);
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(applyResId);
            if (ObjectUtils.isEmpty((Object)prdOrgEmployeeRefVO)) {
                throw TwException.error("", "\u7533\u8bf7\u4eba\u6ca1\u6709\u4e0a\u7ea7\uff0c\u8bf7\u5b8c\u5584\u7533\u8bf7\u4eba\u4fe1\u606f\u540e\u63d0\u4ea4\uff01");
            }
            Long parentId = prdOrgEmployeeRefVO.getParentId();
            variables.put("Activity_1uj6v31", parentId);
            List<Long> messageToUserIds = this.systemRoleDAO.queryUserIdByRoleCode(RoleEnum.OPS.getCode());
            variables.put("Activity_0pulfoc", messageToUserIds);
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.PERMISSION_APPLY.name(), (String)(applyResName + "-\u6743\u9650\u7533\u8bf7\u6d41\u7a0b"), (String)("" + permissionApplyDO.getId()), variables), new Long[0]);
        }
        TPermissionApplyPayload payload = new TPermissionApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(permissionApplyDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        this.transactionUtilService.executeWithRunnable(() -> this.tPermissionApplyDAO.updateByKeyDynamic(payload));
    }

    public TPermissionApplyServiceImpl(TPermissionApplyRepo tPermissionApplyRepo, TPermissionApplyDAO tPermissionApplyDAO, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, CacheUtil cacheUtil, PrdOrgEmployeeDAO employeeDAO, PrdSystemRoleDAO systemRoleDAO) {
        this.tPermissionApplyRepo = tPermissionApplyRepo;
        this.tPermissionApplyDAO = tPermissionApplyDAO;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.cacheUtil = cacheUtil;
        this.employeeDAO = employeeDAO;
        this.systemRoleDAO = systemRoleDAO;
    }
}

