/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.common.service;

import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookInvoicePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookInvoiceService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BookInvoiceConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookInvoiceDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookInvoiceDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookInvoiceRepo;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BookInvoiceServiceImpl
extends BaseServiceImpl
implements BookInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(BookInvoiceServiceImpl.class);
    private final BookInvoiceRepo bookInvoiceRepo;
    private final BookInvoiceDAO bookInvoiceDAO;
    private final PrdSystemLogService logService;
    private final ChangeFieldLogUtil changeFieldLogUtil;

    public PagingVO<BookInvoiceVO> queryPaging(BookInvoiceQuery query) {
        return this.bookInvoiceDAO.queryPaging(query);
    }

    public List<BookInvoiceVO> queryListDynamic(BookInvoiceQuery query) {
        return this.bookInvoiceDAO.queryListDynamic(query);
    }

    public BookInvoiceVO queryByKey(Long key) {
        BookInvoiceDO entity = this.bookInvoiceRepo.findById(key).orElseGet(BookInvoiceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BookInvoiceVO vo = BookInvoiceConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public BookInvoiceVO queryDefaultByBookId(Long bookId) {
        return this.bookInvoiceDAO.queryDefaultByBookId(bookId);
    }

    @Transactional(rollbackFor={Exception.class})
    public BookInvoiceVO insert(BookInvoicePayload payload, Boolean logFlag) {
        List<BookInvoiceDO> defaultDOs;
        if (payload != null && payload.getIsDefault().booleanValue() && !CollectionUtils.isEmpty(defaultDOs = this.bookInvoiceRepo.findByBookIdAndIsDefault(payload.getBookId(), true))) {
            for (BookInvoiceDO defaultDO : defaultDOs) {
                defaultDO.setIsDefault(false);
                this.bookInvoiceRepo.save(defaultDO);
            }
        }
        BookInvoiceDO entityDo = BookInvoiceConvert.INSTANCE.toDo(payload);
        if (logFlag.booleanValue() && payload.getPartnerId() != null) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u65b0\u589e\u4e86\u4e00\u6761\u5f00\u7968\u4fe1\u606f");
        }
        BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(payload.getBookId()));
        return BookInvoiceConvert.INSTANCE.toVo((BookInvoiceDO)this.bookInvoiceRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(List<BookInvoiceVO> voList) {
        if (!CollectionUtils.isEmpty(voList)) {
            List collect = voList.stream().filter(p -> p.getIsDefault() != null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                voList.get(0).setIsDefault(Boolean.valueOf(true));
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u63d0\u4ea4\u591a\u6761\u9ed8\u8ba4\u7684\u6570\u636e");
                }
                List collectFalse = voList.stream().filter(p -> p.getIsDefault() == null || p.getIsDefault() == false).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(Boolean.valueOf(false)));
                }
            }
            List bookInvoiceDOS = BookInvoiceConvert.INSTANCE.toEntity(voList);
            this.bookInvoiceRepo.saveAll(bookInvoiceDOS);
            BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(voList.get(0).getBookId()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BookInvoiceVO update(BookInvoicePayload payload, Boolean logFlag) {
        List<BookInvoiceDO> defaultDOs;
        BookInvoiceDO entity = this.bookInvoiceRepo.findById(payload.getId()).orElseGet(BookInvoiceDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (payload != null && payload.getIsDefault().booleanValue() && !CollectionUtils.isEmpty(defaultDOs = this.bookInvoiceRepo.findByBookIdAndIsDefault(payload.getBookId(), true))) {
            for (BookInvoiceDO defaultDO : defaultDOs) {
                defaultDO.setIsDefault(false);
                this.bookInvoiceRepo.save(defaultDO);
            }
        }
        BookInvoiceDO entityDo = BookInvoiceConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        if (logFlag.booleanValue() && null != payload.getPartnerId()) {
            this.logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u4fee\u6539\u4e86\u4e00\u6761\u5f00\u7968\u4fe1\u606f");
        }
        BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(entity.getBookId()));
        return BookInvoiceConvert.INSTANCE.toVo((BookInvoiceDO)this.bookInvoiceRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, Long bookId, Long partnerId, Boolean logFlag) {
        if (!keys.isEmpty()) {
            BookInvoiceVO bookInvoiceVO = this.bookInvoiceDAO.queryByKey(keys.get(0));
            Long boookId = bookInvoiceVO.getBookId();
            this.bookInvoiceDAO.deleteSoft(keys);
            List<BookInvoiceDO> dos = this.bookInvoiceDAO.queryByBookId(boookId);
            if (dos != null && dos.size() == 1) {
                BookInvoiceDO bookInvoiceDO = dos.get(0);
                bookInvoiceDO.setIsDefault(true);
                this.bookInvoiceRepo.save(bookInvoiceDO);
            }
            if (logFlag.booleanValue()) {
                this.logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u5220\u9664\u4e86 " + keys.size() + " \u6761\u5f00\u7968\u4fe1\u606f");
            }
            BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftBykeys(List<Long> keys, Long bookId, Long partnerId) {
        if (!keys.isEmpty()) {
            this.bookInvoiceDAO.deleteSoft(keys);
            this.logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "\u5220\u9664\u4e86 " + keys.size() + " \u6761\u5f00\u7968\u4fe1\u606f");
            BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }

    public Long count(BookInvoiceQuery query) {
        return this.bookInvoiceDAO.count(query);
    }

    @Transactional
    public void deleteByBookId(Long bookId) {
        this.bookInvoiceDAO.deleteByBookId(bookId);
        BusinessPartnerService businessPartnerService = (BusinessPartnerService)SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
    }

    @Transactional
    public void saveAll(List<BookInvoiceVO> bookInvoiceVOList) {
        this.bookInvoiceDAO.saveAll(BookInvoiceConvert.INSTANCE.toEntity(bookInvoiceVOList));
    }

    public BookInvoiceServiceImpl(BookInvoiceRepo bookInvoiceRepo, BookInvoiceDAO bookInvoiceDAO, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil) {
        this.bookInvoiceRepo = bookInvoiceRepo;
        this.bookInvoiceDAO = bookInvoiceDAO;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
    }
}

