/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.personplan.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanVersionPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanVersionQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PersonPlanVersionService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVersionVO;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.personplan.convert.PersonPlanVersionConvert;
import com.elitesland.tw.tw5.server.prd.personplan.dao.PersonPlanVersionDAO;
import com.elitesland.tw.tw5.server.prd.personplan.entity.PersonPlanVersionDO;
import com.elitesland.tw.tw5.server.prd.personplan.repo.PersonPlanVersionRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PersonPlanVersionServiceImpl
extends BaseServiceImpl
implements PersonPlanVersionService {
    private static final Logger log = LoggerFactory.getLogger(PersonPlanVersionServiceImpl.class);
    private final PersonPlanVersionRepo personPlanVersionRepo;
    private final PersonPlanVersionDAO personPlanVersionDAO;
    private final FileUtil fileUtil;

    public PagingVO<PersonPlanVersionVO> queryPaging(PersonPlanVersionQuery query) {
        return this.personPlanVersionDAO.queryPaging(query);
    }

    public List<PersonPlanVersionVO> queryListDynamic(PersonPlanVersionQuery query) {
        return this.personPlanVersionDAO.queryListDynamic(query);
    }

    public PersonPlanVersionVO queryByKey(Long key) {
        PersonPlanVersionDO entity = this.personPlanVersionRepo.findById(key).orElseGet(PersonPlanVersionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PersonPlanVersionVO vo = PersonPlanVersionConvert.INSTANCE.toVo(entity);
        PersonPlanVO personPlanVO = (PersonPlanVO)JSONObject.parseObject((String)vo.getChangeContent(), PersonPlanVO.class);
        if (personPlanVO != null && StringUtils.hasText((String)personPlanVO.getFileCodes())) {
            personPlanVO.setFileDatas(this.fileUtil.getFileDatas(personPlanVO.getFileCodes()));
        }
        vo.setPersonPlanVO(personPlanVO);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long save(PersonPlanVersionPayload payload) {
        String planType = payload.getPlanType();
        Long objId = payload.getObjId();
        PersonPlanVersionQuery query = new PersonPlanVersionQuery();
        query.setObjId(objId);
        query.setPlanId(payload.getPlanId());
        query.setPlanType(planType);
        List<PersonPlanVersionVO> personPlanVersionVOS = this.queryListDynamic(query);
        PersonPlanVersionDO personPlanVersionDO = PersonPlanVersionConvert.INSTANCE.toDo(payload);
        if (CollectionUtils.isEmpty(personPlanVersionVOS)) {
            personPlanVersionDO.setVersionNo(0);
        } else {
            personPlanVersionDO.setVersionNo(personPlanVersionVOS.size());
        }
        PersonPlanVersionDO save = (PersonPlanVersionDO)this.personPlanVersionRepo.save(personPlanVersionDO);
        if (save == null) {
            return -1L;
        }
        return save.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public PersonPlanVersionVO update(PersonPlanVersionPayload payload) {
        PersonPlanVersionDO entity = this.personPlanVersionRepo.findById(payload.getId()).orElseGet(PersonPlanVersionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PersonPlanVersionDO entityDo = PersonPlanVersionConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PersonPlanVersionConvert.INSTANCE.toVo((PersonPlanVersionDO)this.personPlanVersionRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PersonPlanVersionPayload payload) {
        PersonPlanVersionDO entity = this.personPlanVersionRepo.findById(payload.getId()).orElseGet(PersonPlanVersionDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.personPlanVersionDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.personPlanVersionDAO.deleteSoft(keys);
        }
    }

    public PersonPlanVersionServiceImpl(PersonPlanVersionRepo personPlanVersionRepo, PersonPlanVersionDAO personPlanVersionDAO, FileUtil fileUtil) {
        this.personPlanVersionRepo = personPlanVersionRepo;
        this.personPlanVersionDAO = personPlanVersionDAO;
        this.fileUtil = fileUtil;
    }
}

