/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsResourcePlanDaysPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsResourcePlanDaysQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsResourcePlanDaysVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsResourcePlanDaysDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsResourcePlanDaysDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsResourcePlanDaysRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsResourcePlanDaysDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsResourcePlanDaysRepo repo;
    private final QPmsResourcePlanDaysDO qdo = QPmsResourcePlanDaysDO.pmsResourcePlanDaysDO;

    private JPAQuery<PmsResourcePlanDaysVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PmsResourcePlanDaysVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.planId, this.qdo.roleDetailId, this.qdo.days, this.qdo.startDate})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsResourcePlanDaysVO> getJpaQueryWhere(PmsResourcePlanDaysQuery query) {
        JPAQuery<PmsResourcePlanDaysVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsResourcePlanDaysQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsResourcePlanDaysQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPlanId())) {
            list.add(this.qdo.planId.eq((Object)query.getPlanId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRoleDetailId())) {
            list.add(this.qdo.roleDetailId.eq((Object)query.getRoleDetailId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getRoleDetailIds())) {
            list.add(this.qdo.roleDetailId.in((Collection)query.getRoleDetailIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getYearWeek())) {
            list.add(this.qdo.yearWeek.eq((Object)query.getYearWeek()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDays())) {
            list.add(this.qdo.days.eq((Object)query.getDays()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLargeDays())) {
            list.add(this.qdo.days.gt((Number)query.getLargeDays()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getNotNullPlanIdFlag())) {
            list.add(this.qdo.planId.isNotNull());
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsResourcePlanDaysVO queryByKey(Long id) {
        JPAQuery<PmsResourcePlanDaysVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PmsResourcePlanDaysVO)jpaQuery.fetchFirst();
    }

    public List<PmsResourcePlanDaysVO> queryListDynamic(PmsResourcePlanDaysQuery query) {
        JPAQuery<PmsResourcePlanDaysVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PmsResourcePlanDaysVO> queryPaging(PmsResourcePlanDaysQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsResourcePlanDaysVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PmsResourcePlanDaysDO save(PmsResourcePlanDaysDO ado) {
        return (PmsResourcePlanDaysDO)this.repo.save(ado);
    }

    public List<PmsResourcePlanDaysDO> saveAll(List<PmsResourcePlanDaysDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsResourcePlanDaysPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getPlanId() != null) {
            update.set(this.qdo.planId, (Object)payload.getPlanId());
        }
        if (payload.getRoleDetailId() != null) {
            update.set(this.qdo.roleDetailId, (Object)payload.getRoleDetailId());
        }
        if (payload.getStartDate() != null) {
            update.set(this.qdo.startDate, (Object)payload.getStartDate());
        }
        if (payload.getDays() != null) {
            update.set(this.qdo.days, (Object)payload.getDays());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("planId")) {
                update.setNull(this.qdo.planId);
            }
            if (nullFields.contains("roleDetailId")) {
                update.setNull(this.qdo.roleDetailId);
            }
            if (nullFields.contains("yearWeek")) {
                update.setNull((Path)this.qdo.yearWeek);
            }
            if (nullFields.contains("days")) {
                update.setNull(this.qdo.days);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByPlanIdAndStartDate(Long planId, Set<LocalDate> startDates) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.planId.eq((Object)planId)}).where(new Predicate[]{this.qdo.startDate.in(startDates)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByRoleDetailId(Long roleDetailId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.roleDetailId.eq((Object)roleDetailId)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsResourcePlanDaysDAO(JPAQueryFactory jpaQueryFactory, PmsResourcePlanDaysRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

