/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectEventLogPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectEventLogQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectEventLogService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectEventLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.DataUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectEventLogConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectEventLogDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectEventLogDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectEventLogRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PmsProjectEventLogServiceImpl
extends BaseServiceImpl
implements PmsProjectEventLogService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectEventLogServiceImpl.class);
    private final PmsProjectEventLogRepo pmsProjectEventLogRepo;
    private final PmsProjectEventLogDAO pmsProjectEventLogDAO;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;
    private final PrdOrgOrganizationService service;
    private final ExcelUtil excelUtil;
    private final UdcUtil udcUtil;

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectEventLogVO insertOrUpdate(PmsProjectEventLogPayload payload) {
        DataUtil.checkDataLength(payload, null);
        if (payload.getId() != null) {
            PmsProjectEventLogVO projectEventLogVO = this.pmsProjectEventLogDAO.queryByKey(payload.getId());
            if (!ObjectUtils.isEmpty((Object)projectEventLogVO)) {
                if (projectEventLogVO.getStatus().equals("COMPLETED")) {
                    throw TwException.error("", "\u5df2\u5b8c\u6210\u72b6\u6001\u4e0d\u53ef\u4fee\u6539");
                }
            } else {
                throw TwException.error("", "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
            }
        }
        if (payload.getStatus().equals("COMPLETED")) {
            payload.setFinishTime(LocalDateTime.now());
        }
        PmsProjectEventLogDO entityDo = PmsProjectEventLogConvert.INSTANCE.toDo(payload);
        return PmsProjectEventLogConvert.INSTANCE.toVo((PmsProjectEventLogDO)this.pmsProjectEventLogRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateStatus(Long id) {
        PmsProjectEventLogPayload payload = new PmsProjectEventLogPayload();
        payload.setId(id);
        payload.setStatus("COMPLETED");
        payload.setFinishTime(LocalDateTime.now());
        return this.pmsProjectEventLogDAO.updateByKeyDynamic(payload);
    }

    public PagingVO<PmsProjectEventLogVO> queryPaging(PmsProjectEventLogQuery query) {
        PagingVO<PmsProjectEventLogVO> pmsProjectEventLogVOPagingVO = this.pmsProjectEventLogDAO.queryPaging(query);
        if (pmsProjectEventLogVOPagingVO.getTotal() > 0L) {
            pmsProjectEventLogVOPagingVO.getRecords().forEach(this::tranData);
        }
        return pmsProjectEventLogVOPagingVO;
    }

    void tranData(PmsProjectEventLogVO vo) {
        if (vo != null) {
            vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        }
    }

    public PagingVO<PmsProjectEventLogVO> queryPushPaging(PmsProjectEventLogQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List orgIds = this.service.queryByManageIdOrgIds(loginUserId);
        query.setLoginUserId(loginUserId);
        query.setHeadOrgIds(orgIds);
        query.setProjectStatus("ACTIVE");
        PagingVO<PmsProjectEventLogVO> pmsProjectEventLogVOPagingVO = this.pmsProjectEventLogDAO.queryPushPaging(query);
        if (pmsProjectEventLogVOPagingVO.getTotal() > 0L) {
            List identified0;
            List records = pmsProjectEventLogVOPagingVO.getRecords();
            LocalDate localDate = LocalDate.now();
            ArrayList ids = new ArrayList();
            List<PmsProjectEventLogVO> identified = records.stream().filter(record -> record.getStatus().equals("IDENTIFIED") && record.getExpectedEndDate() != null && localDate.toEpochDay() - record.getExpectedEndDate().toEpochDay() > 0L).collect(Collectors.toList());
            int hour = LocalDateTime.now().getHour();
            if (hour >= 12 && !ObjectUtils.isEmpty(identified0 = records.stream().filter(record -> record.getStatus().equals("IDENTIFIED") && record.getExpectedEndDate() != null && localDate.toEpochDay() - record.getExpectedEndDate().toEpochDay() == 0L).collect(Collectors.toList()))) {
                if (ObjectUtils.isEmpty(identified)) {
                    identified = new ArrayList();
                }
                identified.addAll(identified0);
            }
            identified.forEach(eventLogVO -> {
                eventLogVO.setStatus("EXTENDED");
                eventLogVO.setRiskLevel("9");
                ids.add(eventLogVO.getId());
            });
            records.forEach(eventLogVO -> {
                Object remark = "\u5df2\u8bc6\u522b\u5f85\u5904\u7406";
                long delayDay = 0L;
                if (eventLogVO.getStatus().equals("EXTENDED")) {
                    delayDay = localDate.toEpochDay() - eventLogVO.getExpectedEndDate().toEpochDay();
                    remark = delayDay <= 7L ? "\u5df2\u5ef6\u671f" + delayDay + "\u5929" : "\u4e25\u91cd\u5ef6\u671f\u672a\u5904\u7406";
                }
                eventLogVO.setRemark((String)remark);
                eventLogVO.setDelayDay(delayDay);
            });
            if (ids.size() > 0) {
                this.transactionUtilService.executeWithRunnable(() -> this.pmsProjectEventLogDAO.updateStatus(ids, "EXTENDED", "9"));
            }
        }
        return pmsProjectEventLogVOPagingVO;
    }

    public PmsProjectEventLogVO queryByKey(Long key) {
        PmsProjectEventLogVO pmsProjectEventLogVO = this.pmsProjectEventLogDAO.queryByKey(key);
        this.tranData(pmsProjectEventLogVO);
        return pmsProjectEventLogVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List identified;
            List<PmsProjectEventLogVO> pmsProjectEventLogVOs = this.pmsProjectEventLogDAO.queryByKeys(keys);
            if (!ObjectUtils.isEmpty(pmsProjectEventLogVOs) && !ObjectUtils.isEmpty(identified = pmsProjectEventLogVOs.stream().filter(vo -> !vo.getStatus().equals("IDENTIFIED")).collect(Collectors.toList()))) {
                throw TwException.error("", "\u53ea\u6709\u5df2\u8bc6\u522b\u72b6\u6001\u7684\u4e8b\u4ef6\u65e5\u5fd7\u53ef\u4ee5\u5220\u9664");
            }
            this.pmsProjectEventLogDAO.deleteSoft(keys);
        }
    }

    public void downloadPlus(HttpServletResponse response) {
        ClassPathResource classPathResource = new ClassPathResource("template/projectEventLog.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            String fileName = "\u9879\u76ee\u4e8b\u4ef6\u65e5\u5fd7\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exportExcel(PmsProjectEventLogQuery query, HttpServletResponse response) {
        ClassPathResource classPathResource = new ClassPathResource("template/projectEventLogExport.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u9879\u76ee\u4e8b\u4ef6\u65e5\u5fd7");
            String fileName = "\u9879\u76ee\u4e8b\u4ef6\u65e5\u5fd7-" + LocalDate.now();
            List pmsProjectEventLogVOS = this.pmsProjectEventLogDAO.queryListDynamic(query);
            if (!ObjectUtils.isEmpty(pmsProjectEventLogVOS)) {
                pmsProjectEventLogVOS = this.udcUtil.translateList(pmsProjectEventLogVOS);
                int nextRow = 1;
                for (PmsProjectEventLogVO eventLogVO : pmsProjectEventLogVOS) {
                    this.tranData(eventLogVO);
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, nextRow);
                    this.excelUtil.setCellValue((Row)row, 1, eventLogVO.getProjNo());
                    this.excelUtil.setCellValue((Row)row, 2, eventLogVO.getProjName());
                    this.excelUtil.setCellValue((Row)row, 3, eventLogVO.getDeliBuName());
                    this.excelUtil.setCellValue((Row)row, 4, eventLogVO.getPmResName());
                    this.excelUtil.setCellValue((Row)row, 5, eventLogVO.getEventContentSource());
                    this.excelUtil.setCellValue((Row)row, 6, eventLogVO.getPossibleImpacts());
                    this.excelUtil.setCellValue((Row)row, 7, eventLogVO.getHeadResName());
                    this.excelUtil.setCellValue((Row)row, 8, eventLogVO.getTypeDesc());
                    this.excelUtil.setCellValue((Row)row, 9, eventLogVO.getSeverityDesc());
                    this.excelUtil.setCellValue((Row)row, 10, eventLogVO.getProbabilityOfOccurrenceDesc());
                    this.excelUtil.setCellValue((Row)row, 11, eventLogVO.getRiskLevelDesc());
                    this.excelUtil.setCellValue((Row)row, 12, eventLogVO.getCopingStrategy());
                    this.excelUtil.setCellValue((Row)row, 13, eventLogVO.getExpectedEndDate());
                    this.excelUtil.setCellValue((Row)row, 14, eventLogVO.getStatusDesc());
                    this.excelUtil.setCellValue((Row)row, 15, eventLogVO.getCreator());
                    this.excelUtil.setCellValue((Row)row, 16, eventLogVO.getCreateTime());
                    this.excelUtil.setCellValue((Row)row, 17, eventLogVO.getFinishTime());
                    ++nextRow;
                }
            }
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean importEmployees(MultipartFile file, Long projectId) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u9879\u76ee\u4e8b\u4ef6\u65e5\u5fd7");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 2;
        ArrayList<PmsProjectEventLogDO> eventLogDos = new ArrayList<PmsProjectEventLogDO>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            String status;
            String riskLevel;
            Row row = sheet.getRow(i);
            String eventContentSource = ExcelUtil.getCellFormatValue(row.getCell(1));
            if (!StringUtils.hasText((String)eventContentSource)) {
                throw TwException.error("", "\u4e8b\u4ef6\u5185\u5bb9\u53ca\u6765\u6e90\u4e0d\u53ef\u4e3a\u7a7a");
            }
            String possibleImpacts = ExcelUtil.getCellFormatValue(row.getCell(2));
            String type = ExcelUtil.getCellFormatValue(row.getCell(3));
            if (StringUtils.hasText((String)type)) {
                if (!StringUtils.hasText((String)(type = this.cacheUtil.getSystemSelectionValueByName("PMS_PROJECT_EVENT_TYPE", type)))) {
                    throw TwException.error("", "\u6240\u5c5e\u7c7b\u578b\u4e0d\u5b58\u5728");
                }
            } else {
                throw TwException.error("", "\u6240\u5c5e\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
            }
            String severity = ExcelUtil.getCellFormatValue(row.getCell(4));
            if (StringUtils.hasText((String)severity)) {
                if (!StringUtils.hasText((String)(severity = this.cacheUtil.getSystemSelectionValueByName("PMS:PROJECT:EVENT:SEVERITY", severity)))) {
                    throw TwException.error("", "\u4e25\u91cd\u7a0b\u5ea6\u4e0d\u5b58\u5728");
                }
            } else {
                throw TwException.error("", "\u4e25\u91cd\u7a0b\u5ea6\u4e0d\u53ef\u4e3a\u7a7a");
            }
            String probabilityOfOccurrence = ExcelUtil.getCellFormatValue(row.getCell(5));
            if (StringUtils.hasText((String)probabilityOfOccurrence)) {
                probabilityOfOccurrence = this.cacheUtil.getSystemSelectionValueByName("PMS:PROJECT:EVENT:ODDS", probabilityOfOccurrence);
            }
            if (StringUtils.hasText((String)(riskLevel = ExcelUtil.getCellFormatValue(row.getCell(6))))) {
                riskLevel = this.cacheUtil.getSystemSelectionValueByName("PMS:PROJECT:RISK", riskLevel);
            }
            String copingStrategy = ExcelUtil.getCellFormatValue(row.getCell(7));
            String expectedStr = ExcelUtil.getCellFormatValue(row.getCell(8));
            LocalDate expectedEndDate = null;
            if (StringUtils.hasText((String)expectedStr)) {
                expectedEndDate = DateUtil.strToLocalDate(expectedStr);
            }
            if (StringUtils.hasText((String)(status = ExcelUtil.getCellFormatValue(row.getCell(9))))) {
                if (!StringUtils.hasText((String)(status = this.cacheUtil.getSystemSelectionValueByName("PMS_PROJECT_EVENT_STATUS", status)))) {
                    throw TwException.error("", "\u72b6\u6001\u4e0d\u5b58\u5728");
                }
            } else {
                throw TwException.error("", "\u72b6\u6001\u4e0d\u53ef\u4e3a\u7a7a");
            }
            PmsProjectEventLogDO eventLogDO = new PmsProjectEventLogDO();
            eventLogDO.setCopingStrategy(copingStrategy);
            eventLogDO.setEventContentSource(eventContentSource);
            eventLogDO.setExpectedEndDate(expectedEndDate);
            eventLogDO.setPossibleImpacts(possibleImpacts);
            eventLogDO.setProbabilityOfOccurrence(probabilityOfOccurrence);
            eventLogDO.setRiskLevel(riskLevel);
            eventLogDO.setStatus(status);
            eventLogDO.setType(type);
            eventLogDO.setProjectId(projectId);
            eventLogDO.setSeverity(severity);
            if (status.equals("COMPLETED")) {
                eventLogDO.setFinishTime(LocalDateTime.now());
            }
            eventLogDos.add(eventLogDO);
        }
        DataUtil.checkDataLength(eventLogDos, null);
        this.pmsProjectEventLogDAO.saveAll(eventLogDos);
        return true;
    }

    public PmsProjectEventLogServiceImpl(PmsProjectEventLogRepo pmsProjectEventLogRepo, PmsProjectEventLogDAO pmsProjectEventLogDAO, CacheUtil cacheUtil, TransactionUtilService transactionUtilService, PrdOrgOrganizationService service, ExcelUtil excelUtil, UdcUtil udcUtil) {
        this.pmsProjectEventLogRepo = pmsProjectEventLogRepo;
        this.pmsProjectEventLogDAO = pmsProjectEventLogDAO;
        this.cacheUtil = cacheUtil;
        this.transactionUtilService = transactionUtilService;
        this.service = service;
        this.excelUtil = excelUtil;
        this.udcUtil = udcUtil;
    }
}

