/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractManagerPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractManagerQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractManagerService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractManagerVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91c7\u8d2d\u5408\u540c\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/purchaseContractManager"})
@PermissionDomain(domain=PermissionDomainEnum.PCN_PURCHAS)
public class PurchaseContractManagerController {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractManagerController.class);
    private final PurchaseContractManagerService purchaseContractManagerService;

    @PostMapping
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody PurchaseContractManagerPayload payload) {
        return TwOutputUtil.ok(this.purchaseContractManagerService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody PurchaseContractManagerPayload payload) {
        return TwOutputUtil.ok(this.purchaseContractManagerService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u4e3b\u952e\u67e5\u8be2\u8be6\u7ec6\u9875\u9762")
    public TwOutputUtil<PurchaseContractManagerVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.purchaseContractManagerService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u5206\u9875")
    public TwOutputUtil<PagingVO<PurchaseContractManagerVO>> paging(PurchaseContractManagerQuery query) {
        return TwOutputUtil.ok(this.purchaseContractManagerService.queryPaging(query));
    }

    @PostMapping(value={"/permissionPaging"})
    @UdcNameClass
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u6743\u9650\u5206\u9875")
    @PermissionFunction(functions={@FunctionDetail(functionCode=FunctionCodeEnum.PCN_PURCHAS_LIST_DATA_POWER, type=FunctionTypeEnum.TAB)}, fieldPermission=true, permissionType=PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<PurchaseContractManagerVO>> permissionPaging(@RequestBody PurchaseContractManagerQuery query) {
        return TwOutputUtil.ok(this.purchaseContractManagerService.queryPermissionPaging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<PurchaseContractManagerVO>> queryList(PurchaseContractManagerQuery query) {
        return TwOutputUtil.ok(this.purchaseContractManagerService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.purchaseContractManagerService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/log/list/{key}"})
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u64cd\u4f5c\u65e5\u5fd7")
    public TwOutputUtil<List<PrdSystemLogVO>> queryLogList(@PathVariable Long key) {
        return TwOutputUtil.ok(this.purchaseContractManagerService.queryLogList(key));
    }

    @PatchMapping(value={"/active"})
    @ApiOperation(value="\u6fc0\u6d3b/\u63d0\u4ea4\u5ba1\u6279")
    public TwOutputUtil active(Long[] keys) {
        this.purchaseContractManagerService.active(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/filing/{ids}"})
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u6279\u91cf\u5408\u540c\u5f52\u6863\u5408\u540c")
    public TwOutputUtil contractFilingByIds(@PathVariable Long[] ids) {
        this.purchaseContractManagerService.contractFilingByIds(Arrays.asList(ids));
        return TwOutputUtil.ok();
    }

    @PatchMapping(value={"/closeContract"})
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u91c7\u8d2d\u5408\u540c\u7684\u5173\u95ed")
    public TwOutputUtil closeContract(@RequestParam List<Long> ids, @RequestParam String closeReason) {
        this.purchaseContractManagerService.closeContract(ids, closeReason);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/downloadPurCon"})
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u5bfc\u51faexcel")
    public void downloadPurCon(HttpServletResponse response, PurchaseContractManagerQuery query) {
        this.purchaseContractManagerService.downloadPurCon(response, query);
    }

    @PostMapping(value={"/permissionDownloadPurCon"})
    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u7ba1\u7406-\u6743\u9650-\u5bfc\u51faexcel")
    public void permissionDownloadPurCon(HttpServletResponse response, @RequestBody PurchaseContractManagerQuery query) {
        this.purchaseContractManagerService.permissionDownloadPurCon(response, query);
    }

    @ApiOperation(value="\u6839\u636e\u91c7\u8d2d\u5408\u540c\u7ec8\u6b62ID\u67e5\u8be2\u91c7\u8d2d\u5408\u540c\u4fe1\u606f")
    @GetMapping(value={"/over/purchase/{overId}"})
    public TwOutputUtil<PurchaseContractManagerVO> selectPurchaseContractByOverId(@PathVariable long overId) {
        PurchaseContractManagerVO purchaseContractVO = this.purchaseContractManagerService.selectPurchaseContractByOverId(Long.valueOf(overId));
        return TwOutputUtil.ok(purchaseContractVO);
    }

    @ApiOperation(value="\u91c7\u8d2d\u5408\u540c\u5408\u540c\u5f52\u6863")
    @GetMapping(value={"/contractArchiving/{purConId}"})
    public TwOutputUtil purContractArchiving(@PathVariable Long purConId, String stampFileCodes) {
        this.purchaseContractManagerService.purContractArchiving(purConId, stampFileCodes);
        return TwOutputUtil.ok();
    }

    public PurchaseContractManagerController(PurchaseContractManagerService purchaseContractManagerService) {
        this.purchaseContractManagerService = purchaseContractManagerService;
    }
}

