/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseContractManagerPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseContractDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.PurchaseContractDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurConOrAgreementDetailsSimpleVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseContractDetailsVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseContractDetailsConvert;
import com.elitesland.tw.tw5.server.prd.purchase.convert.PurchaseContractManagerConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractDetailsRepo;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchaseContractManagerRepo;
import com.elitesland.tw.tw5.server.prd.purchase.service.PurchaseContractManagerServiceImpl;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class PurchaseContractDetailsServiceImpl
extends BaseServiceImpl
implements PurchaseContractDetailsService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseContractDetailsServiceImpl.class);
    private final PurchaseContractDetailsRepo purchaseContractDetailsRepo;
    private final PurchaseContractManagerRepo purchaseContractManagerRepo;
    private final PurchaseContractDetailsDAO purchaseContractDetailsDAO;
    private final PrdSystemLogService logService;
    @Autowired
    private PurchaseContractManagerServiceImpl purchaseContractManagerService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CacheUtil cacheUtil;

    public PagingVO<PurchaseContractDetailsVO> queryPaging(PurchaseContractDetailsQuery query) {
        return this.purchaseContractDetailsDAO.queryPaging(query);
    }

    public List<PurchaseContractDetailsVO> queryListDynamic(PurchaseContractDetailsQuery query) {
        List<PurchaseContractDetailsVO> purchaseContractDetailsVOS = this.purchaseContractDetailsDAO.queryListDynamic(query);
        return purchaseContractDetailsVOS;
    }

    public PurchaseContractDetailsVO queryByKey(Long key) {
        PurchaseContractDetailsDO entity = this.purchaseContractDetailsRepo.findById(key).orElseGet(PurchaseContractDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchaseContractDetailsVO vo = PurchaseContractDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseContractDetailsVO insert(PurchaseContractDetailsPayload payload) {
        PurchaseContractDetailsDO entity = PurchaseContractDetailsConvert.INSTANCE.toDo(payload);
        PurchaseContractDetailsDO save = (PurchaseContractDetailsDO)this.purchaseContractDetailsRepo.save(entity);
        String fieldsCreateLog = this.changeFieldLogUtil.getFieldsCreateLog(entity);
        this.logService.saveNewLog(save.getId(), PrdSystemObjectEnum.PROCUREMENT_CONTRACT_DETAIL.getCode(), fieldsCreateLog);
        PurchaseContractDetailsQuery purchaseContractDetailsQuery = new PurchaseContractDetailsQuery();
        purchaseContractDetailsQuery.setPurchaseContractId(payload.getPurchaseContractId());
        List<PurchaseContractDetailsVO> vos = this.queryListDynamic(purchaseContractDetailsQuery);
        PurchaseContractManagerPayload purchaseContractManagerPayload = PurchaseContractManagerConvert.INSTANCE.toPayload(this.purchaseContractManagerService.queryByKey(payload.getPurchaseContractId()));
        PurchaseContractManagerDO purchaseContractManagerDO = PurchaseContractManagerConvert.INSTANCE.toDo(purchaseContractManagerPayload);
        this.purchaseContractManagerService.countTax(vos, purchaseContractManagerDO);
        this.purchaseContractManagerRepo.save(purchaseContractManagerDO);
        return PurchaseContractDetailsConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public PurchaseContractDetailsVO update(PurchaseContractDetailsPayload payload) {
        PurchaseContractDetailsDO entity = this.purchaseContractDetailsRepo.findById(payload.getId()).orElseGet(PurchaseContractDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PurchaseContractManagerDO entityLog = new PurchaseContractManagerDO();
        BeanUtils.copyProperties((Object)entity, (Object)entityLog);
        PurchaseContractDetailsDO entityDo = PurchaseContractDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, entity);
        PurchaseContractDetailsDO save = (PurchaseContractDetailsDO)this.purchaseContractDetailsRepo.save(entity);
        fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
        if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.PROCUREMENT_CONTRACT.getCode(), fieldsUpdateLog.toString());
        }
        PurchaseContractDetailsQuery purchaseContractDetailsQuery = new PurchaseContractDetailsQuery();
        purchaseContractDetailsQuery.setPurchaseContractId(payload.getPurchaseContractId());
        List<PurchaseContractDetailsVO> vos = this.queryListDynamic(purchaseContractDetailsQuery);
        PurchaseContractManagerPayload purchaseContractManagerPayload = PurchaseContractManagerConvert.INSTANCE.toPayload(this.purchaseContractManagerService.queryByKey(payload.getPurchaseContractId()));
        PurchaseContractManagerDO purchaseContractManagerDO = PurchaseContractManagerConvert.INSTANCE.toDo(purchaseContractManagerPayload);
        this.purchaseContractManagerService.countTax(vos, purchaseContractManagerDO);
        this.purchaseContractManagerRepo.save(purchaseContractManagerDO);
        return PurchaseContractDetailsConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (keys.isEmpty()) {
            return;
        }
        PurchaseContractDetailsVO purchaseContractDetailsVO = this.purchaseContractDetailsDAO.queryByKey(keys.get(0));
        Long purchaseContractId = purchaseContractDetailsVO.getPurchaseContractId();
        this.purchaseContractDetailsDAO.deleteSoft(keys);
        PurchaseContractDetailsQuery purchaseContractDetailsQuery = new PurchaseContractDetailsQuery();
        purchaseContractDetailsQuery.setPurchaseContractId(purchaseContractId);
        List<PurchaseContractDetailsVO> vos = this.queryListDynamic(purchaseContractDetailsQuery);
        PurchaseContractManagerPayload purchaseContractManagerPayload = PurchaseContractManagerConvert.INSTANCE.toPayload(this.purchaseContractManagerService.queryByKey(purchaseContractId));
        PurchaseContractManagerDO purchaseContractManagerDO = PurchaseContractManagerConvert.INSTANCE.toDo(purchaseContractManagerPayload);
        this.purchaseContractManagerService.countTax(vos, purchaseContractManagerDO);
        this.purchaseContractManagerRepo.save(purchaseContractManagerDO);
    }

    public List<PurConOrAgreementDetailsSimpleVO> queryByPurConId(Long purConId) {
        return this.purchaseContractDetailsDAO.queryByPurConId(purConId);
    }

    public PurchaseContractDetailsServiceImpl(PurchaseContractDetailsRepo purchaseContractDetailsRepo, PurchaseContractManagerRepo purchaseContractManagerRepo, PurchaseContractDetailsDAO purchaseContractDetailsDAO, PrdSystemLogService logService, ChangeFieldLogUtil changeFieldLogUtil, CacheUtil cacheUtil) {
        this.purchaseContractDetailsRepo = purchaseContractDetailsRepo;
        this.purchaseContractManagerRepo = purchaseContractManagerRepo;
        this.purchaseContractDetailsDAO = purchaseContractDetailsDAO;
        this.logService = logService;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.cacheUtil = cacheUtil;
    }
}

