/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.SettleApplyDetailsPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.SettleApplyDetailsQuery;
import com.elitesland.tw.tw5.api.prd.purchase.service.SettleApplyDetailsService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.SettleApplyDetailsVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.purchase.convert.SettleApplyDetailsConvert;
import com.elitesland.tw.tw5.server.prd.purchase.dao.SettleApplyDetailsDAO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.SettleApplyDetailsDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.SettleApplyCoopWayEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.SettleApplyDetailsRepo;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SettleApplyDetailsServiceImpl
extends BaseServiceImpl
implements SettleApplyDetailsService {
    private static final Logger log = LoggerFactory.getLogger(SettleApplyDetailsServiceImpl.class);
    private final SettleApplyDetailsRepo settleApplyDetailsRepo;
    private final SettleApplyDetailsDAO settleApplyDetailsDAO;

    public PagingVO<SettleApplyDetailsVO> queryPaging(SettleApplyDetailsQuery query) {
        return this.settleApplyDetailsDAO.queryPaging(query);
    }

    public List<SettleApplyDetailsVO> queryListDynamic(SettleApplyDetailsQuery query) {
        return this.settleApplyDetailsDAO.queryListDynamic(query);
    }

    public SettleApplyDetailsVO queryByKey(Long key) {
        SettleApplyDetailsDO entity = this.settleApplyDetailsRepo.findById(key).orElseGet(SettleApplyDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SettleApplyDetailsVO vo = SettleApplyDetailsConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public SettleApplyDetailsVO insert(SettleApplyDetailsPayload payload) {
        SettleApplyDetailsDO entityDo = SettleApplyDetailsConvert.INSTANCE.toDo(payload);
        return SettleApplyDetailsConvert.INSTANCE.toVo((SettleApplyDetailsDO)this.settleApplyDetailsRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public SettleApplyDetailsVO update(SettleApplyDetailsPayload payload) {
        SettleApplyDetailsDO entity = this.settleApplyDetailsRepo.findById(payload.getId()).orElseGet(SettleApplyDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        SettleApplyDetailsDO entityDo = SettleApplyDetailsConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SettleApplyDetailsConvert.INSTANCE.toVo((SettleApplyDetailsDO)this.settleApplyDetailsRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(SettleApplyDetailsPayload payload) {
        SettleApplyDetailsDO entity = this.settleApplyDetailsRepo.findById(payload.getId()).orElseGet(SettleApplyDetailsDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.settleApplyDetailsDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.settleApplyDetailsDAO.deleteSoft(keys);
        }
    }

    public PurchaseAgreementResVO queryAssocationResoure(Long userId, LocalDate settleStartDate, LocalDate settleEndDate) {
        PurchaseAgreementResVO purchaseAgreementResVO = this.settleApplyDetailsDAO.queryAssocationResoure(userId, settleStartDate, settleEndDate);
        if (purchaseAgreementResVO == null) {
            throw TwException.error("", "\u5f53\u524d\u7ed3\u7b97\u8d44\u6e90\u7ed3\u7b97\u65e5\u671f\u4e0d\u5728\u7ed3\u7b97\u8303\u56f4\u65e5\u671f\u5185\uff01");
        }
        String cooperationWay = purchaseAgreementResVO.getCooperationWay();
        SettleApplyDetailsQuery query = new SettleApplyDetailsQuery();
        query.setCoopWay(cooperationWay);
        query.setPurchaseAgreementId(purchaseAgreementResVO.getDocumentId());
        query.setSettleResId(userId);
        query.setPurchaseAgreementResId(purchaseAgreementResVO.getId());
        List<SettleApplyDetailsVO> settleApplyDetailsVOS = this.settleApplyDetailsDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(settleApplyDetailsVOS)) {
            if (SettleApplyCoopWayEnum.demand_settlement.getCode().equals(cooperationWay)) {
                settleApplyDetailsVOS.stream().forEach(p -> {
                    Boolean flag = this.hasOverlap(settleStartDate, settleEndDate, p.getStartDate(), p.getEndDate());
                    if (flag.booleanValue()) {
                        throw TwException.error("", "\u5f53\u524d\u8d44\u6e90\u7ed3\u7b97\u5468\u671f\u5df2\u53d1\u8d77\u8fc7\u7ed3\u7b97\u7533\u8bf7\u5355\uff0c\u5355\u53f7:" + p.getSettleNo());
                    }
                });
            } else {
                throw TwException.error("", "\u5f53\u524d\u7ed3\u7b97\u8d44\u6e90\u5c5e\u4e8e\u6253\u5305\u7ed3\u7b97\uff0c\u5df2\u53d1\u8d77\u8fc7\u7ed3\u7b97\u7533\u8bf7\u5355\uff0c\u5355\u53f7:" + settleApplyDetailsVOS.get(0).getSettleNo());
            }
        }
        return purchaseAgreementResVO;
    }

    public void queryAssocationByResId(Long userId) {
        PurchaseAgreementResVO purchaseAgreementResVO = this.settleApplyDetailsDAO.queryAssocationResoure(userId, null, null);
        if (purchaseAgreementResVO == null) {
            throw TwException.error("", "\u8be5\u8d44\u6e90\u672a\u5173\u8054\u91c7\u8d2d\u534f\u8bae");
        }
    }

    public boolean hasOverlap(LocalDate start1, LocalDate end1, LocalDate start2, LocalDate end2) {
        if (start1.isBefore(end2) && end1.isAfter(start2)) {
            return true;
        }
        return start2.isBefore(end1) && end2.isAfter(start1);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void importBatchPro(MultipartFile file, Boolean force) throws IOException {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet("\u7ed3\u7b97\u7533\u8bf7");
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        int dataStartRow = 1;
        ArrayList<SettleApplyDetailsPayload> detailsPayloadList = new ArrayList<SettleApplyDetailsPayload>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            SettleApplyDetailsPayload detailsPayload = new SettleApplyDetailsPayload();
            String id = ExcelUtil.getCellFormatValue(row.getCell(0));
            if (!StringUtils.hasText((String)id)) {
                throw TwException.error("", "\u7b2c" + i + "\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            detailsPayload.setId(Long.valueOf(id));
            String payTime = ExcelUtil.getCellFormatValue(row.getCell(20));
            String paymentAmt = ExcelUtil.getCellFormatValue(row.getCell(21));
            String paymentStatus = ExcelUtil.getCellFormatValue(row.getCell(22));
            if (!StringUtils.hasText((String)payTime) && !StringUtils.hasText((String)paymentStatus) && !StringUtils.hasText((String)paymentAmt)) continue;
            if (StringUtils.hasText((String)payTime)) {
                try {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                    LocalDate parse = LocalDate.parse(payTime, formatter);
                    detailsPayload.setPayTime(parse);
                }
                catch (Exception e) {
                    throw TwException.error("", "\u7b2c" + i + "\u884c\u4ed8\u6b3e\u65f6\u95f4\u683c\u5f0f\u9519\u8bef,\u5e94\u4e3a2020-01-01");
                }
            }
            detailsPayload.setPayStatus(paymentStatus);
            if (StringUtils.hasText((String)paymentAmt)) {
                try {
                    detailsPayload.setPayAmt(new BigDecimal(paymentAmt));
                }
                catch (Exception e) {
                    throw TwException.error("", "\u7b2c" + i + "\u884c\u4ed8\u6b3e\u91d1\u989d\u683c\u5f0f\u9519\u8bef");
                }
            }
            detailsPayloadList.add(detailsPayload);
        }
        detailsPayloadList.stream().forEach(p -> this.updateByKeyDynamic((SettleApplyDetailsPayload)p));
    }

    public SettleApplyDetailsServiceImpl(SettleApplyDetailsRepo settleApplyDetailsRepo, SettleApplyDetailsDAO settleApplyDetailsDAO) {
        this.settleApplyDetailsRepo = settleApplyDetailsRepo;
        this.settleApplyDetailsDAO = settleApplyDetailsDAO;
    }
}

