/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwChannelCostConDEntity;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwChannelCostConEntity;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConEpibolyCostConConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConEpibolyCostConDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConEpibolyCostConDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConEpibolyCostConDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConEpibolyCostConDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConEpibolyCostConDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConEpibolyCostConRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.xxl.job.core.log.XxlJobLogger;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ConEpibolyCostConServiceImpl
extends BaseServiceImpl
implements ConEpibolyCostConService {
    private static final Logger log = LoggerFactory.getLogger(ConEpibolyCostConServiceImpl.class);
    private final ConEpibolyCostConRepo conEpibolyCostConRepo;
    private final ConEpibolyCostConDAO conEpibolyCostConDAO;
    private final ConEpibolyCostConDDAO conEpibolyCostConDDAO;
    private final ConEpibolyCostConDRepo conEpibolyCostConDRepo;
    private final SaleConContractRepo saleConContractRepo;
    @Autowired
    private ConEpibolyCostConDService conEpibolyCostConDService;
    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;
    @Value(value="${tw4.sale.contractCost}")
    private String contractCost;

    public PagingVO<ConEpibolyCostConVO> queryPaging(ConEpibolyCostConQuery query) {
        return this.conEpibolyCostConDAO.queryPaging(query);
    }

    public List<ConEpibolyCostConVO> queryListDynamic(ConEpibolyCostConQuery query) {
        return this.conEpibolyCostConDAO.queryListDynamic(query);
    }

    public ConEpibolyCostConVO queryByKey(Long key) {
        ConEpibolyCostConVO vo = this.conEpibolyCostConDAO.queryByKey(key);
        return vo;
    }

    public ConEpibolyCostConVO queryOneByCostDId(Long key) {
        ConEpibolyCostConVO vo = new ConEpibolyCostConVO();
        ConEpibolyCostConDVO epibolyCostConDVO = this.conEpibolyCostConDService.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)epibolyCostConDVO)) {
            return vo;
        }
        List childrenList = this.conEpibolyCostConDService.queryByParentId(epibolyCostConDVO.getId());
        epibolyCostConDVO.setChildrenList(childrenList);
        epibolyCostConDVO.setSortNo("1");
        epibolyCostConDVO.setChildrenList(childrenList);
        int sortNo = 1;
        for (ConEpibolyCostConDVO children : childrenList) {
            children.setSortNo("1." + sortNo++);
        }
        vo = this.queryByKey(epibolyCostConDVO.getEpibolyCostConId());
        if (ObjectUtils.isEmpty((Object)vo)) {
            return vo;
        }
        vo.setConEpibolyCostConDVOS(Collections.singletonList(epibolyCostConDVO));
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConEpibolyCostConVO insert(ConEpibolyCostConPayload payload) {
        ConEpibolyCostConDO entityDo = ConEpibolyCostConConvert.INSTANCE.toDo(payload);
        String code = this.generateSeqNum("CON_QD", new String[0]);
        entityDo.setEpibolyCostNo(code);
        ConEpibolyCostConDO save = (ConEpibolyCostConDO)this.conEpibolyCostConRepo.save(entityDo);
        payload.setId(save.getId());
        this.insertOrUpdate(payload);
        return ConEpibolyCostConConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public ConEpibolyCostConVO update(ConEpibolyCostConPayload payload) {
        ConEpibolyCostConDO entity = this.conEpibolyCostConRepo.findById(payload.getId()).orElseGet(ConEpibolyCostConDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConEpibolyCostConDO entityDo = ConEpibolyCostConConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        this.insertOrUpdate(payload);
        return ConEpibolyCostConConvert.INSTANCE.toVo((ConEpibolyCostConDO)this.conEpibolyCostConRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conEpibolyCostConDAO.deleteSoft(keys);
        }
    }

    public ConEpibolyCostConVO queryByContractId(Long contractId) {
        ConEpibolyCostConVO vo = this.conEpibolyCostConDAO.queryByContractId(contractId);
        if (vo == null) {
            return new ConEpibolyCostConVO();
        }
        List<ConEpibolyCostConDVO> dvos = this.conEpibolyCostConDDAO.queryByepibolyCostConId(vo.getId());
        for (ConEpibolyCostConDVO dvo : dvos) {
            List childrenList = this.conEpibolyCostConDService.queryByParentId(dvo.getId());
            dvo.setSortNo("1");
            dvo.setChildrenList(childrenList);
            int sortNo = 1;
            for (ConEpibolyCostConDVO children : childrenList) {
                children.setSortNo("1." + sortNo++);
            }
        }
        vo.setConEpibolyCostConDVOS(dvos);
        return vo;
    }

    public void syncCostConTo4(String param) {
        LocalDateTime syncTime;
        String syncType = "cost_con_to4";
        syncTime = StringUtils.hasText((String)param) ? LocalDateTime.parse(param) : ((syncTime = this.daoLog.queryOrgSyncLog(syncType)) == null ? LocalDateTime.of(2023, 7, 1, 0, 0) : syncTime.minusSeconds(120L));
        XxlJobLogger.log((String)"\u5916\u5305\u8d39\u7528\u540c\u6b65\u52304.0\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("syncCostConTo4 localDateTime\uff1a" + syncTime), (Object[])new Object[0]);
        String format = DateUtil.format((LocalDateTime)syncTime, (String)"yyyy-MM-dd HH:mm:ss");
        List<ConEpibolyCostConDO> querySyncDatas = this.conEpibolyCostConRepo.findByModifyTimeStart(format);
        Object syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(querySyncDatas)) {
            Object date;
            Map<Long, Long> v4AndV5UserIds = this.employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            Map<Long, Long> v4AndV5OrgIds = this.orgService.getV4AndV5OrgIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            ArrayList<TwChannelCostConEntity> copy = new ArrayList<TwChannelCostConEntity>();
            for (ConEpibolyCostConDO tempDo : querySyncDatas) {
                TwChannelCostConEntity e = new TwChannelCostConEntity();
                List<ConEpibolyCostConDDO> conEpibolyCostConDVOS = this.conEpibolyCostConDRepo.findCostConDDOByID(tempDo.getId());
                if (!ObjectUtils.isEmpty(conEpibolyCostConDVOS)) {
                    ArrayList<TwChannelCostConDEntity> detail = new ArrayList<TwChannelCostConDEntity>();
                    conEpibolyCostConDVOS.stream().forEach(item -> {
                        TwChannelCostConDEntity view = new TwChannelCostConDEntity();
                        view.setCostConDIdV5(item.getId());
                        view.setWorkType(item.getWorkType());
                        view.setReason(item.getReason());
                        view.setCoopType(item.getPartnerType());
                        view.setBase(item.getBase());
                        view.setChannelCostRem(item.getCollaborator());
                        if (item.getProportion() != null) {
                            view.setProportion((long)item.getProportion());
                        }
                        view.setAmt(item.getAmt());
                        if (item.getTaxRate() != null) {
                            BigDecimal multiply = item.getTaxRate().multiply(new BigDecimal("100")).setScale(0, 1);
                            view.setTaxRate(Long.valueOf("" + multiply));
                        }
                        view.setTaxCost(item.getTaxCost());
                        view.setReimExp(item.getTaxPayer());
                        view.setCostCondIdv4(item.getCostCondIdV4());
                        view.setNetPay(item.getNetPay());
                        view.setSalaryMethod(item.getPaymentMethod());
                        view.setContractStatus(item.getContractStatus());
                        view.setContactName(item.getLiaisonName());
                        view.setContactPhone(item.getLiaisonPhone());
                        view.setApplyStatus(item.getDetailedStatus());
                        view.setDelFlag(item.getDeleteFlag().equals(1));
                        if (item.getProcInstStatus() != null) {
                            if (ProcInstStatus.NOTSUBMIT.getDesc().equals(item.getProcInstStatus().getDesc())) {
                                view.setApprStatus("NOTSUBMIT");
                            } else if (ProcInstStatus.APPROVING.getDesc().equals(item.getProcInstStatus().getDesc())) {
                                view.setApprStatus("APPROVING");
                            } else if (ProcInstStatus.APPROVED.getDesc().equals(item.getProcInstStatus().getDesc())) {
                                view.setApprStatus("APPROVED");
                            } else if (ProcInstStatus.REJECTED.getDesc().equals(item.getProcInstStatus().getDesc())) {
                                view.setApprStatus("REJECTED");
                            }
                        }
                        view.setMinChannelCostConId(item.getParentId());
                        if (StringUtils.hasText((String)item.getReceStage()) && item.getReceStage().matches("[0-9]+")) {
                            view.setReceivingNode(Long.valueOf(item.getReceStage()));
                        }
                        view.setDelFlag(item.getDeleteFlag() != 0);
                        detail.add(view);
                    });
                    e.setChannelCostConDEntities(detail);
                }
                e.setContractId(tempDo.getContractId());
                e.setChannelCostNo(tempDo.getEpibolyCostNo());
                e.setApplyResId(v4AndV5UserIds.get(tempDo.getApplyUserId()));
                e.setApplyBuId(v4AndV5OrgIds.get(tempDo.getApplyBuId()));
                if (tempDo.getApplyDate() != null) {
                    date = tempDo.getApplyDate();
                    Instant instant = ((LocalDate)date).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
                    e.setApplyDate(DateUtil.format((Date)Date.from(instant), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                e.setChannelCostRem(tempDo.getRemark());
                e.setCostConIdV5(tempDo.getId());
                e.setCostConIdV4(tempDo.getCostConIdV4());
                e.setDelFlag(tempDo.getDeleteFlag() != 0);
                copy.add(e);
            }
            if (!ObjectUtils.isEmpty(copy)) {
                int failNum = 0;
                for (TwChannelCostConEntity temDo : copy) {
                    LocalDateTime syncStartTime = LocalDateTime.now();
                    try {
                        date = BeanUtil.beanToMap(temDo);
                    }
                    catch (Exception e) {
                        XxlJobLogger.log((String)("\u5916\u5305\u8d39\u7528" + temDo.getCostConIdV5() + "\u540c\u6b65\u5f02\u5e38......" + e), (Object[])new Object[0]);
                        LocalDateTime syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "\u5916\u5305\u8d39\u7528id" + temDo.getCostConIdV5() + "\u540c\u6b65\u5f02\u5e38\uff0c" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "\u8be6\u60c5\uff1a" + e, null);
                        ++failNum;
                        this.conEpibolyCostConRepo.updateRemark(temDo.getCostConIdV5());
                    }
                }
                syncData = "\u66f4\u65b0\u4e86" + (copy.size() - failNum) + "\u6570\u636e,\u6709" + failNum + "\u6761\u6570\u636e\u66f4\u65b0\u5931\u8d25\uff01";
            } else {
                syncData = "\u5916\u5305\u8d39\u7528\u6570\u636e\u672a\u53d8\u5316";
            }
        } else {
            syncData = "\u5916\u5305\u8d39\u7528\u6570\u636e\u672a\u53d8\u5316";
        }
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, (String)syncData, syncNow);
        XxlJobLogger.log((String)("\u540c\u6b65\u5916\u5305\u8d39\u7528\u7ed3\u675f..." + logDO), (Object[])new Object[0]);
    }

    public void unbindReim(String reimNo) {
        this.conEpibolyCostConDDAO.unbindReim(reimNo);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        this.daoLog.save(logDO);
        return logDO;
    }

    private List<ConEpibolyCostConDVO> insertOrUpdate(ConEpibolyCostConPayload payload) {
        List conEpibolyCostConDPayloadList = payload.getConEpibolyCostConDPayloads();
        ArrayList<ConEpibolyCostConDVO> conEpibolyCostConDVOS = new ArrayList<ConEpibolyCostConDVO>();
        Optional.ofNullable(conEpibolyCostConDPayloadList).ifPresent(list -> {
            for (ConEpibolyCostConDPayload conEpibolyCostConDPayload : list) {
                conEpibolyCostConDPayload.setEpibolyCostConId(payload.getId());
                if (ObjectUtils.isEmpty((Object)conEpibolyCostConDPayload.getId()) || conEpibolyCostConDPayload.getId() < 0L) {
                    ConEpibolyCostConDVO insert = this.conEpibolyCostConDService.insert(conEpibolyCostConDPayload);
                    conEpibolyCostConDVOS.add(insert);
                    continue;
                }
                ConEpibolyCostConDVO update = this.conEpibolyCostConDService.update(conEpibolyCostConDPayload);
                conEpibolyCostConDVOS.add(update);
            }
        });
        return conEpibolyCostConDVOS;
    }

    public ConEpibolyCostConServiceImpl(ConEpibolyCostConRepo conEpibolyCostConRepo, ConEpibolyCostConDAO conEpibolyCostConDAO, ConEpibolyCostConDDAO conEpibolyCostConDDAO, ConEpibolyCostConDRepo conEpibolyCostConDRepo, SaleConContractRepo saleConContractRepo, HttpUtil httpUtil, PrdOrgSyncLogDAO daoLog, PrdOrgEmployeeService employeeService, PrdOrgOrganizationService orgService) {
        this.conEpibolyCostConRepo = conEpibolyCostConRepo;
        this.conEpibolyCostConDAO = conEpibolyCostConDAO;
        this.conEpibolyCostConDDAO = conEpibolyCostConDDAO;
        this.conEpibolyCostConDRepo = conEpibolyCostConDRepo;
        this.saleConContractRepo = saleConContractRepo;
        this.httpUtil = httpUtil;
        this.daoLog = daoLog;
        this.employeeService = employeeService;
        this.orgService = orgService;
    }
}

