/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConReceivablePlanConfirmPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConRecvplanChangeLogPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanConfirmQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConReceivablePlanQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConRecvplanChangeLogQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanConfirmService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanConfirmVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConRecvplanChangeLogVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemSettingService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSettingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConReceivablePlanConfirmConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanConfirmDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConRecvplanChangeLogDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConReceivablePlanConfirmDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanConfirmRepo;
import com.elitesland.tw.tw5.server.prd.salecon.saleConEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.SystemSettingsItemEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.xxl.job.core.log.XxlJobLogger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ConReceivablePlanConfirmServiceImpl
extends BaseServiceImpl
implements ConReceivablePlanConfirmService {
    private static final Logger log = LoggerFactory.getLogger(ConReceivablePlanConfirmServiceImpl.class);
    private final ConReceivablePlanConfirmRepo conReceivablePlanConfirmRepo;
    private final ConReceivablePlanConfirmDAO conReceivablePlanConfirmDAO;
    private final ConReceivablePlanDAO conReceivablePlanDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final ConRecvplanChangeLogDAO conRecvplanChangeLogDAO;
    @Value(value="${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    private final PrdOrgOrganizationDAO daoOrg;
    private final TransactionUtilService transactionUtilService;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final PrdSystemSettingService prdSystemSettingService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;
    private final ConReceivablePlanService conReceivablePlanService;

    public PagingVO<ConReceivablePlanConfirmVO> queryPaging(ConReceivablePlanConfirmQuery query) {
        return this.conReceivablePlanConfirmDAO.queryPaging(query);
    }

    public List<ConReceivablePlanConfirmVO> queryListDynamic(ConReceivablePlanConfirmQuery query) {
        return this.conReceivablePlanConfirmDAO.queryListDynamic(query);
    }

    public ConReceivablePlanConfirmVO queryByKey(Long key) {
        ConReceivablePlanConfirmDO entity = this.conReceivablePlanConfirmRepo.findById(key).orElseGet(ConReceivablePlanConfirmDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConReceivablePlanConfirmVO vo = ConReceivablePlanConfirmConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConReceivablePlanConfirmVO insert(ConReceivablePlanConfirmPayload payload) {
        ConReceivablePlanConfirmDO entityDo = ConReceivablePlanConfirmConvert.INSTANCE.toDo(payload);
        return ConReceivablePlanConfirmConvert.INSTANCE.toVo((ConReceivablePlanConfirmDO)this.conReceivablePlanConfirmRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConReceivablePlanConfirmVO update(ConReceivablePlanConfirmPayload payload) {
        ConReceivablePlanConfirmDO entity = this.conReceivablePlanConfirmRepo.findById(payload.getId()).orElseGet(ConReceivablePlanConfirmDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConReceivablePlanConfirmDO entityDo = ConReceivablePlanConfirmConvert.INSTANCE.toDo(payload);
        ConReceivablePlanConfirmDO save = this.conReceivablePlanConfirmDAO.save(entityDo);
        if (StringUtils.hasText((String)payload.getProcInstId())) {
            SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
            setVariablesPayload.setProcInstId(payload.getProcInstId());
            HashMap<String, Object> variables = new HashMap<String, Object>();
            ConReceivablePlanVO planVO = this.conReceivablePlanDAO.queryByKey(save.getRecePlanId());
            this.getProcessApproval(save, planVO, variables);
            setVariablesPayload.setVariables(variables);
            this.workflowUtil.setVaribales(setVariablesPayload);
        }
        return ConReceivablePlanConfirmConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(ConReceivablePlanConfirmPayload payload) {
        ConReceivablePlanConfirmDO entity = this.conReceivablePlanConfirmRepo.findById(payload.getId()).orElseGet(ConReceivablePlanConfirmDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.conReceivablePlanConfirmDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conReceivablePlanConfirmDAO.deleteSoft(keys);
        }
    }

    @Transactional(propagation=Propagation.NOT_SUPPORTED)
    public int autoCreateFlow(Long signBuId) {
        int sysWarmRecvDtLt = this.getSysWarmRecvDtLt();
        int maxSizeChangeLog = this.getMaxSizeChangeLog();
        int maxRecvDtDelaydays = this.getMaxRecvDtDelaydays();
        int maxRecvDtDelaydays2 = this.getMaxRecvDtDelaydays2();
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        LocalDate now = LocalDate.now();
        LocalDate endDate = now.plusDays(sysWarmRecvDtLt);
        query.setExpectRecvDateEnd(endDate);
        query.setSignBuId(signBuId);
        List<ConReceivablePlanVO> conReceivablePlanVOS = this.conReceivablePlanDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(conReceivablePlanVOS)) {
            ArrayList rcvpConfirmEntityList = new ArrayList();
            conReceivablePlanVOS.forEach(recvPlan -> {
                PrdOrgEmployeeDO prdOrgEmployeeDO;
                XxlJobLogger.log((String)("\u5904\u7406\u6536\u6b3e\u8ba1\u5212\uff1a " + recvPlan.getReceNo()), (Object[])new Object[0]);
                String contractRemark = recvPlan.getContractRemark();
                if (StringUtils.hasText((String)contractRemark) && contractRemark.trim().equals("\u9879\u76ee\u5f02\u5e38")) {
                    XxlJobLogger.log((String)("\u5b50\u5408\u540c\u5907\u6ce8\u3010\u9879\u76ee\u5f02\u5e38\u3011\uff1b\u8df3\u8fc7\u6536\u6b3e\u8ba1\u5212\uff1a " + recvPlan.getReceNo() + "; \u5b50\u5408\u540c\u7f16\u53f7\uff1a" + recvPlan.getSaleConCode()), (Object[])new Object[0]);
                    return;
                }
                if ("1".equals(recvPlan.getReceStatus())) {
                    XxlJobLogger.log((String)("\u6682\u65f6\u4e0d\u5bf9\u672a\u5f00\u7968\u7684\u6536\u6b3e\u8ba1\u5212\u89e6\u53d1\u6d41\u7a0b\uff0c\u89e6\u53d1\u903b\u8f91\u7684\u4ee3\u7801\u4fdd\u7559\uff0c\u4ec5\u76ee\u524d\u4e0d\u505a\u89e6\u53d1\uff1b\u8df3\u8fc7\u6536\u6b3e\u8ba1\u5212\uff1a " + recvPlan.getReceNo() + "; \u5b50\u5408\u540c\u7f16\u53f7\uff1a" + recvPlan.getSaleConCode()), (Object[])new Object[0]);
                    return;
                }
                LocalDate expectRecvDate = recvPlan.getExpectReceDate();
                Long recvPlanId = recvPlan.getId();
                ConReceivablePlanConfirmDO conReceivablePlanConfirmDO = new ConReceivablePlanConfirmDO();
                conReceivablePlanConfirmDO.setContractId(recvPlan.getSaleConId() != null ? recvPlan.getSaleConId() : null);
                conReceivablePlanConfirmDO.setRecePlanId(recvPlanId != null ? recvPlanId : null);
                conReceivablePlanConfirmDO.setReceNo(recvPlan.getReceNo());
                conReceivablePlanConfirmDO.setExpectReceDate(expectRecvDate);
                if (recvPlan.getSaleManUserId() == null) {
                    if (null != recvPlan.getCoSignUserId()) {
                        recvPlan.setSaleManUserId(recvPlan.getCoSignUserId());
                    } else {
                        log.error("\u672a\u5f00\u7968\u6536\u6b3e\u786e\u8ba4\u7edf\u8ba1\u5f02\u5e38,\u5408\u540c\u672a\u8bbe\u7f6e\u9500\u552e\u4eba\u5458or\u526f\u7b7e\u5355\u8d1f\u8d23\u4eba! \u5408\u540c\u4e3b\u952e\uff1a{};\u5408\u540c\u7f16\u53f7\uff1a{}", (Object)recvPlan.getSaleConId(), (Object)recvPlan.getSaleConCode());
                        return;
                    }
                }
                if ("4".equals((prdOrgEmployeeDO = this.employeeDAO.queryByUserId(recvPlan.getSaleManUserId())).getResourceStatus()) || "6".equals(prdOrgEmployeeDO.getResourceStatus())) {
                    if (null != recvPlan.getCoSignUserId()) {
                        PrdOrgEmployeeDO resStatusCoUserId = this.employeeDAO.queryByUserId(recvPlan.getCoSignUserId());
                        if ("4".equals(resStatusCoUserId.getResourceStatus()) || "6".equals(prdOrgEmployeeDO.getResourceStatus())) {
                            Long approvalResId = this.getApprovalResId(recvPlan.getReceNo());
                            if (null != approvalResId) {
                                recvPlan.setSaleManUserId(approvalResId);
                            }
                        } else {
                            recvPlan.setSaleManUserId(recvPlan.getDeliUserId());
                        }
                    } else {
                        Long approvalResId = this.getApprovalResId(recvPlan.getReceNo());
                        if (null != approvalResId) {
                            recvPlan.setSaleManUserId(approvalResId);
                        }
                    }
                }
                conReceivablePlanConfirmDO.setApplyUserId(recvPlan.getSaleManUserId());
                if ("1".equals(recvPlan.getReceStatus())) {
                    if (expectRecvDate.isAfter(now)) {
                        conReceivablePlanConfirmDO.setTipsType(SaleConEnum.RcvpConfirmTipsType.NO_INVOICE_WARN.getCode());
                        conReceivablePlanConfirmDO.setTips(maxRecvDtDelaydays + "," + maxSizeChangeLog);
                    } else if (expectRecvDate.isBefore(now) || expectRecvDate.isEqual(now)) {
                        conReceivablePlanConfirmDO.setTipsType(SaleConEnum.RcvpConfirmTipsType.NO_INVOICE_OVERDUE.getCode());
                        conReceivablePlanConfirmDO.setTips(maxRecvDtDelaydays + "," + maxSizeChangeLog);
                    } else {
                        log.error("\u672a\u5f00\u7968\u6536\u6b3e\u786e\u8ba4\u7edf\u8ba1\u5f02\u5e38\uff1a");
                        log.error("\u6536\u6b3e\u65e5\u671f\u8303\u56f4\u5f02\u5e38\uff1a\u8fd0\u884c\u65f6\u95f4\uff1a{},\u6536\u6b3e\u65e5\u671f\uff1a{},\u6536\u6b3e\u53f7\uff1a{}", new Object[]{now, expectRecvDate, recvPlan.getReceNo()});
                    }
                } else if ("4".equals(recvPlan.getReceStatus()) && expectRecvDate.isBefore(now) || expectRecvDate.isEqual(now)) {
                    conReceivablePlanConfirmDO.setTipsType(SaleConEnum.RcvpConfirmTipsType.OK_INVOICE_OVERDUE_NULL_PAYMENT.getCode());
                    conReceivablePlanConfirmDO.setTips(maxRecvDtDelaydays2 + "," + maxSizeChangeLog);
                } else if ("2".equals(recvPlan.getReceStatus()) && (expectRecvDate.isBefore(now) || expectRecvDate.isBefore(now))) {
                    conReceivablePlanConfirmDO.setTipsType(SaleConEnum.RcvpConfirmTipsType.OK_INVOICE_OVERDUE_PART_PAYMENT.getCode());
                    conReceivablePlanConfirmDO.setTips(maxRecvDtDelaydays2 + "," + maxSizeChangeLog);
                } else {
                    log.error("\u6536\u6b3e\u786e\u8ba4\u7edf\u8ba1\u5f02\u5e38\uff1a\u6536\u6b3e\u72b6\u6001\uff1a{}", (Object)recvPlan.getReceStatus());
                    log.error("\u6536\u6b3e\u65e5\u671f\u8303\u56f4\u5f02\u5e38\uff1a\u8fd0\u884c\u65f6\u95f4\uff1a{},\u6536\u6b3e\u65e5\u671f\uff1a{},\u6536\u6b3e\u53f7\uff1a{}", new Object[]{now, expectRecvDate, recvPlan.getReceNo()});
                    XxlJobLogger.log((String)("\u6536\u6b3e\u786e\u8ba4\u7edf\u8ba1\u5f02\u5e38\uff1a\u6536\u6b3e\u53f7\uff1a{" + recvPlan.getReceNo() + "}\uff1b\u6536\u6b3e\u72b6\u6001\uff1a " + recvPlan.getReceStatus() + "; \u5b50\u5408\u540c\u7f16\u53f7\uff1a" + recvPlan.getSaleConCode()), (Object[])new Object[0]);
                    XxlJobLogger.log((String)("\u6536\u6b3e\u65e5\u671f\u8303\u56f4\u5f02\u5e38\uff1a\u8fd0\u884c\u65f6\u95f4\uff1a{" + now + "},\u6536\u6b3e\u65e5\u671f\uff1a{" + expectRecvDate + "},\u6536\u6b3e\u53f7\uff1a{" + recvPlan.getReceNo() + "}"), (Object[])new Object[0]);
                    return;
                }
                if (StringUtils.hasText((String)conReceivablePlanConfirmDO.getTipsType())) {
                    rcvpConfirmEntityList.add(conReceivablePlanConfirmDO);
                }
            });
            rcvpConfirmEntityList.forEach(entity -> this.saveAndStartProcess((ConReceivablePlanConfirmDO)entity));
            return rcvpConfirmEntityList.size();
        }
        return 0;
    }

    private Long getApprovalResId(String recvNo) {
        ConReceivablePlanQuery query = new ConReceivablePlanQuery();
        query.setReceNo(recvNo);
        List<ConReceivablePlanVO> contractRecvplan = this.conReceivablePlanDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(contractRecvplan)) {
            ConReceivablePlanVO twContractRecvplanListView = contractRecvplan.get(0);
            Long pmResId = twContractRecvplanListView.getPmUserId();
            if (null != pmResId) {
                return pmResId;
            }
            Long deliUserId = twContractRecvplanListView.getDeliUserId();
            return deliUserId;
        }
        return null;
    }

    @Transactional
    public int saveAndStartProcess(ConReceivablePlanConfirmDO confirmDO) {
        int result = 0;
        ConReceivablePlanConfirmVO vo = ConReceivablePlanConfirmConvert.INSTANCE.toVo(this.conReceivablePlanConfirmDAO.save(confirmDO));
        if (ObjectUtils.isEmpty((Object)vo.getId())) {
            log.error("SysAltRcvpConfirmEntity\u4fdd\u5b58\u5931\u8d25");
        }
        this.finish(vo);
        return result;
    }

    private void finish(ConReceivablePlanConfirmVO view) {
        if (view.getFinanceConfirm() != null && view.getFinanceConfirm() == 1 || view.getReceDateConfirm() != null && view.getReceDateConfirm() == 1) {
            log.debug("\u5df2\u4ed8\u6b3e\u9700\u8d22\u52a1\u786e\u8ba4");
            log.debug("\u9884\u8ba1\u6536\u6b3e\u65e5\u671f\u65e0\u8bef");
        } else {
            ConRecvplanChangeLogPayload logEntity = new ConRecvplanChangeLogPayload();
            logEntity.setRcvpConfirmId(view.getId());
            logEntity.setFlag1(Boolean.valueOf(view.getSendPaymentRequest() == 1));
            logEntity.setRecvplanId(view.getRecePlanId());
            logEntity.setOldRecvOrInvDate(view.getExpectReceDate());
            logEntity.setRecvOrInvDate(view.getAdjExpectReceDate());
            logEntity.setType("RECV");
            logEntity.setApplyUserId(view.getApplyUserId());
            if (null != view.getPmConfirm() && view.getPmConfirm() == 1) {
                logEntity.setReason(view.getPmRemark());
            } else {
                logEntity.setReason(view.getSalesRemark());
            }
            this.conReceivablePlanService.updateRecvOrInvDate(logEntity);
        }
    }

    public int saveAndStartProcessWithWorkFlow(ConReceivablePlanConfirmDO confirmDO) {
        int result = 0;
        ConReceivablePlanConfirmDO save = this.conReceivablePlanConfirmDAO.save(confirmDO);
        if (!ObjectUtils.isEmpty((Object)save.getId())) {
            this.startProcess(confirmDO);
            ++result;
        } else {
            log.error("SysAltRcvpConfirmEntity\u4fdd\u5b58\u5931\u8d25");
        }
        return result;
    }

    private void startProcess(ConReceivablePlanConfirmDO confirmDO) {
        ProcessInfo processInfo = new ProcessInfo();
        ConReceivablePlanVO planVO = this.conReceivablePlanDAO.queryByKey(confirmDO.getRecePlanId());
        if (this.workflow_enabled.booleanValue()) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            this.getProcessApproval(confirmDO, planVO, variables);
            String applyUserName = this.cacheUtil.getUserName(confirmDO.getApplyUserId());
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.CON_PROMPT.name(), (String)(planVO.getSaleConName() + "-" + planVO.getReceStage() + "-\u6536\u6b3e\u8ba1\u5212\u786e\u8ba4" + planVO.getReceAmt() + "-" + applyUserName), (String)("" + confirmDO.getId()), variables), confirmDO.getApplyUserId());
        }
        ConReceivablePlanConfirmPayload payload = new ConReceivablePlanConfirmPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(confirmDO.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        this.transactionUtilService.executeWithRunnable(() -> this.conReceivablePlanConfirmDAO.updateByKeyDynamic(payload));
    }

    private void getProcessApproval(ConReceivablePlanConfirmDO confirmDO, ConReceivablePlanVO planVO, HashMap<String, Object> variables) {
        variables.put("Activity_01h68it", confirmDO.getApplyUserId());
        Long pmUserId = this.getApprovalResId(confirmDO.getReceNo());
        variables.put("Activity_02unqub", pmUserId);
        boolean financeConfirm = confirmDO.getFinanceConfirm() != null && confirmDO.getFinanceConfirm() == 1;
        variables.put("financeConfirm", financeConfirm);
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.FINANCE_MEMBER.getCode()));
        if (ObjectUtils.isEmpty(userIdsByRole)) {
            throw TwException.error("", "\u51fa\u7eb3\u5ba1\u6279\u89d2\u8272\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        variables.put("Activity_1qoee9k", userIdsByRole);
        boolean second = false;
        if (!financeConfirm) {
            int maxSizeChangeLog = this.getMaxSizeChangeLog();
            ConRecvplanChangeLogQuery logQuery = new ConRecvplanChangeLogQuery();
            logQuery.setRecvplanId(confirmDO.getRecePlanId());
            List<ConRecvplanChangeLogVO> list = this.conRecvplanChangeLogDAO.queryListDynamic(logQuery);
            if (!CollectionUtils.isEmpty(list) && list.size() > maxSizeChangeLog) {
                second = true;
            }
            if (second) {
                this.visitNotice(confirmDO, planVO);
            }
        }
        variables.put("second", second);
        variables.put("financeConfirm", financeConfirm);
        boolean sendPaymentRequest = confirmDO.getSendPaymentRequest() != null && confirmDO.getSendPaymentRequest() == 1;
        variables.put("sendPaymentRequest", sendPaymentRequest);
        Long buId = ObjectUtils.isEmpty((Object)planVO.getCoSignBuId()) ? planVO.getSignBuId() : planVO.getCoSignBuId();
        Long buIdManager = this.daoOrg.queryManageIdById(buId);
        variables.put("Activity_1f73s5s", buIdManager);
        Long deliUserId = planVO.getDeliUserId();
        variables.put("Activity_1aypjz1", deliUserId);
        Long pmoUserId = planVO.getPmoUserId();
        variables.put("Activity_0b6mbas", pmoUserId);
    }

    public void visitNotice(ConReceivablePlanConfirmDO confirmDO, ConReceivablePlanVO planVO) {
        PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20231226000001");
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("contractName", planVO.getSaleConName());
        result.put("receNo", planVO.getReceNo());
        List noticeSourceList = new ArrayList();
        noticeSourceList = this.roleService.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.PLAT_FIN_MANAGER.getCode(), RoleEnum.PLAT_FIN_PIC.getCode()));
        String noticeSourceListStr = String.join((CharSequence)",", noticeSourceList.stream().map(String::valueOf).collect(Collectors.toList()));
        this.messageConfigService.sendMessageConfig(configVO, result, "appoint_people", noticeSourceListStr);
    }

    private int getSysWarmRecvDtLt() {
        int sysWarmRecvDtLt = 14;
        PrdSystemSettingVO systemSettingByKey = this.prdSystemSettingService.getSystemSettingByKey(SystemSettingsItemEnum.SYS_WARM_RECV_DT_LT.getCode());
        if (systemSettingByKey != null) {
            String settingValue = systemSettingByKey.getSettingValue();
            try {
                sysWarmRecvDtLt = Integer.parseInt(settingValue);
            }
            catch (NumberFormatException ignored) {
                log.error("\u7cfb\u7edf\u8bbe\u7f6e\u9879-\u3010SYS_WARM_RECV_DT_LT\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        return sysWarmRecvDtLt;
    }

    private int getMaxRecvDtDelaydays() {
        int maxRecvDtDelaydays = 14;
        PrdSystemSettingVO systemSettingByKey = this.prdSystemSettingService.getSystemSettingByKey(SystemSettingsItemEnum.MAX_RECV_DT_DELAYDAYS.getCode());
        if (systemSettingByKey != null) {
            String settingValue = systemSettingByKey.getSettingValue();
            try {
                maxRecvDtDelaydays = Integer.parseInt(settingValue);
            }
            catch (NumberFormatException ignored) {
                log.error("\u7cfb\u7edf\u8bbe\u7f6e\u9879-\u3010MAX_RECV_DT_DELAYDAYS\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        return maxRecvDtDelaydays;
    }

    private int getMaxRecvDtDelaydays2() {
        int maxRecvDtDelaydays2 = 30;
        PrdSystemSettingVO systemSettingByKey = this.prdSystemSettingService.getSystemSettingByKey(SystemSettingsItemEnum.MAX_RECV_DT_DELAYDAYS_2.getCode());
        if (null != systemSettingByKey) {
            String settingValue = systemSettingByKey.getSettingValue();
            try {
                maxRecvDtDelaydays2 = Integer.parseInt(settingValue);
            }
            catch (NumberFormatException ignored) {
                log.error("\u7cfb\u7edf\u8bbe\u7f6e\u9879-\u3010MAX_RECV_DT_DELAYDAYS_2\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        return maxRecvDtDelaydays2;
    }

    public int getMaxSizeChangeLog() {
        int maxSizeChangeLog = 2;
        PrdSystemSettingVO systemSettingByKey = this.prdSystemSettingService.getSystemSettingByKey(SystemSettingsItemEnum.MAX_CHAGE_RECE_DATE.getCode());
        if (null != systemSettingByKey) {
            String settingValue = systemSettingByKey.getSettingValue();
            try {
                maxSizeChangeLog = Integer.parseInt(settingValue);
            }
            catch (NumberFormatException ignored) {
                log.error("\u7cfb\u7edf\u8bbe\u7f6e\u9879-\u3010MAX_CHAGE_RECE_DATE\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        return maxSizeChangeLog;
    }

    public ConReceivablePlanConfirmServiceImpl(ConReceivablePlanConfirmRepo conReceivablePlanConfirmRepo, ConReceivablePlanConfirmDAO conReceivablePlanConfirmDAO, ConReceivablePlanDAO conReceivablePlanDAO, PrdOrgEmployeeDAO employeeDAO, ConRecvplanChangeLogDAO conRecvplanChangeLogDAO, PrdOrgOrganizationDAO daoOrg, TransactionUtilService transactionUtilService, WorkflowUtil workflowUtil, CacheUtil cacheUtil, PrdSystemSettingService prdSystemSettingService, PrdSystemRoleDAO systemRoleDAO, PrdMessageConfigService messageConfigService, PrdSystemRoleService roleService, ConReceivablePlanService conReceivablePlanService) {
        this.conReceivablePlanConfirmRepo = conReceivablePlanConfirmRepo;
        this.conReceivablePlanConfirmDAO = conReceivablePlanConfirmDAO;
        this.conReceivablePlanDAO = conReceivablePlanDAO;
        this.employeeDAO = employeeDAO;
        this.conRecvplanChangeLogDAO = conRecvplanChangeLogDAO;
        this.daoOrg = daoOrg;
        this.transactionUtilService = transactionUtilService;
        this.workflowUtil = workflowUtil;
        this.cacheUtil = cacheUtil;
        this.prdSystemSettingService = prdSystemSettingService;
        this.systemRoleDAO = systemRoleDAO;
        this.messageConfigService = messageConfigService;
        this.roleService = roleService;
        this.conReceivablePlanService = conReceivablePlanService;
    }
}

