/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.partner.identity.payload.BusinessCustomerInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStatusEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.dao.BusinessCustomerInfoDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/CUSTOMER_ACTIVE/callBack"})
@Transactional
public class BusinessCustomerCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(BusinessCustomerCallBackController.class);
    private final BusinessCustomerInfoService service;
    private final BusinessCustomerInfoDAO dao;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        BusinessCustomerInfoPayload businessCustomerInfoPayload = new BusinessCustomerInfoPayload();
        businessCustomerInfoPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        BusinessCustomerInfoVO businessCustomerInfoVO = this.service.queryByKey(Long.valueOf(businessKey));
        if (businessCustomerInfoVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    businessCustomerInfoPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    break;
                }
                case INTERRUPT: {
                    businessCustomerInfoPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    businessCustomerInfoPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.CREATE.getCode());
                    break;
                }
                case REJECTED: {
                    businessCustomerInfoPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    businessCustomerInfoPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    businessCustomerInfoPayload.setApprovedTime(LocalDateTime.now());
                    businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.ACTIVE.getCode());
                    break;
                }
                case APPROVING: {
                    businessCustomerInfoPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    businessCustomerInfoPayload.setCustomerStatus(BusinessPartnerStatusEnum.APPROVING.getCode());
                }
            }
            this.dao.updateByKeyDynamic(businessCustomerInfoPayload);
        }
        return WorkflowResult.success(null);
    }

    public BusinessCustomerCallBackController(BusinessCustomerInfoService service, BusinessCustomerInfoDAO dao) {
        this.service = service;
        this.dao = dao;
    }
}

