/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.salecon.service.ConEpibolyCostConDServiceImpl;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/SALE_CON_EC/callBack"})
@Transactional
public class ConEpibolyCostConWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(ConEpibolyCostConWorkflowCallBackController.class);
    private final ConEpibolyCostConDServiceImpl conEpibolyCostConDService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ConEpibolyCostConDPayload epibolyCostConDPayload = new ConEpibolyCostConDPayload();
        epibolyCostConDPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        ConEpibolyCostConDVO epibolyCostConDVO = this.conEpibolyCostConDService.queryByKey(Long.valueOf(businessKey));
        if (epibolyCostConDVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    epibolyCostConDPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    epibolyCostConDPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.INVALID.getCode());
                    epibolyCostConDPayload.setDeleteFlag(Integer.valueOf(1));
                    epibolyCostConDPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    epibolyCostConDPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    epibolyCostConDPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    epibolyCostConDPayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    epibolyCostConDPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.conEpibolyCostConDService.updateByKeyDynamic(epibolyCostConDPayload);
        }
        return WorkflowResult.success(null);
    }

    public ConEpibolyCostConWorkflowCallBackController(ConEpibolyCostConDServiceImpl conEpibolyCostConDService) {
        this.conEpibolyCostConDService = conEpibolyCostConDService;
    }
}

