package com.elitesland.tw.tw5.server.common;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Component;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zoey
 * @Description:bean和map互转
 * @date 2022/4/21 - 23:20
 */
@Component
public class BeanMapTool {


    /**
     * Bean对象转换Map方式一（基于JDK实现）
     * @param obj
     * @return
     */
    public static Map<String, Object> beanToMap(Object obj){
        Map<String, Object> map = new HashMap<String, Object>();
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        for (Field field : fields) {
            Object o=new Object();
            try {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
                Method getMethod = pd.getReadMethod();
                o = getMethod.invoke(obj);
            }catch (Exception e){
                e.printStackTrace();
            }
            map.put(field.getName(), o);
        }
        return map;
    }


    /**
     * 将map转换为bean
     *
     * @param clazz
     * @param map
     * @param <T>
     * @return
     */
    public static <T> T mapToBean(Class<T> clazz, Map<String, Object> map) {
        T bean = null;
        try {
            bean = clazz.getDeclaredConstructor().newInstance();
            for (Map.Entry<String, Object> stringObjectEntry : map.entrySet()) {
                String key = stringObjectEntry.getKey();
                Object value = stringObjectEntry.getValue();
                // 去这个类及其父类递归找到这个属性
                Field field = getClassField(clazz, key);
                if (field != null) {
                    // 获取属性的set方法
                    String methodName = "set" + key.substring(0, 1).toUpperCase() + key.substring(1);
                    Method method = clazz.getMethod(methodName, field.getType());
                    method.invoke(bean, value);
                }
            }
        } catch (NoSuchMethodException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return bean;
    }


    private static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] declaredFields = clazz.getDeclaredFields();
        for (Field declaredField : declaredFields) {
            if (declaredField.getName().equals(fieldName)) {
                return declaredField;
            }
        }
        // 如果找不到对应属性。递归去父类找
        Class<?> superclass = clazz.getSuperclass();
        if (null != superclass) {
            return getClassField(superclass, fieldName);
        }
        return null;
    }


}

