package com.elitesland.tw.tw5.server.common.constants;

import lombok.Getter;

/**
 * 项目wbs状态枚举
 *
 * @author carl
 */
public enum ProjectWbsStatusEnum {

    NOSETTING("noSetting", "未设置"),
    NOSTART("noStart", "未开始"),
    NOGIONG("nogoing", "进行中"),
    FINISHED("finished", "已完成"),
    UN_FINISHED("unFinished", "未完成"),
    CANCEL("cancel", "已取消"),

    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    ProjectWbsStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ProjectWbsStatusEnum getByCode(String code) {
        for (ProjectWbsStatusEnum value : ProjectWbsStatusEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
