package com.elitesland.tw.tw5.server.common.funConfig.support;

import com.elitesland.tw.tw5.server.common.TwException;

import java.util.List;

/**
 * 通用文档-文档类型检查权限
 *
 * @author duwh
 * @date 2023-12-09
 */
public interface BusinessDocTypeCheckAuthorityService {


    /**
     * 检查权限
     * <p>
     * 只需要关心跟业务关联性强的字段的校验逻辑 如 项目交付负责人、...
     * 通过角色控制能否操作的，这里不需要处理；通用文档中会校验；
     *
     * @param docId   文档id
     * @return {@link TwException}
     */
    TwException checkAuthority(Long docId);

    /**
     * 检查权限
     * <p>
     * 只需要关心跟业务关联性强的字段的校验逻辑 如 项目交付负责人、...
     * 通过角色控制能否操作的，这里不需要处理；通用文档中会校验；
     *
     * @param docId   文档id
     * @param docType 单据类型
     * @return {@link TwException}
     */
    TwException checkAuthority(Long docId, String docType);

    /**
     * 检查权限
     * <p>
     * 只需要关心跟业务关联性强的字段的校验逻辑 如 项目交付负责人、...
     * 通过角色控制能否操作的，这里不需要处理；通用文档中会校验；
     *
     * @param userId           用户id
     * @param orgId            组织id
     * @param roleList         角色列表
     * @param docId            文档id
     * @param docType          单据类型
     * @param configId         配置id
     * @return {@link TwException}
     */
    TwException checkAuthority(Long userId, Long orgId, List<String> roleList, Long docId, String docType, Long configId);

}
