package com.elitesland.tw.tw5.server.common.workFlow.checks;

import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonResService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonResVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.workFlow.CommonWorkflowCheck;
import com.elitesland.tw.tw5.server.common.workFlow.TwWorkflowCheckAnnotation;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import lombok.RequiredArgsConstructor;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@TwWorkflowCheckAnnotation(
        name = "员工状态检查",
        code = "EmployeeStatusCheck",
        scope = "COMMON",
        tableName = "",
        params = "",
        description = "用作员工状态检查，如果员工离职，不可操作流程",
        enabled = true)
@Slf4j
@ToString(callSuper = true)
@RequiredArgsConstructor
@Component(CommonWorkflowCheck.SERVICE_NAME_PREFIX + "EmployeeStatusCheck")
public class EmployeeStatusCheck extends CommonWorkflowCheck {

    private final PersonResService personResService;

    @Override
    public TwOutputUtil check() {
        log.info("check:::{}", payload);
        Long userId = GlobalUtil.getLoginUserId();
        PersonResVO personResVO = personResService.queryByUserId(userId);
        String resourceStatus = personResVO.getPrdOrgEmployeeVO().getResourceStatus();
        if (resourceStatus.equals("1")) {
            return TwOutputUtil.error("您当前状态为离职，不可进行流程操作");
        }
        return super.check();
    }
}
