package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 报销逾期配置
 *
 * @author zoey
 * @date 2024-04-08
 */
@Entity
@Table(name = "acc_reim_setting_overdue", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_setting_overdue", comment = "报销逾期配置")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimSettingOverdueDO extends BaseModel implements Serializable  {

    /** 逾期开始日期 */
    @Comment("逾期开始日期")
    @Column()
    private String overdueStartDate;

    public void copy(AccReimSettingOverdueDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
