package com.elitesland.tw.tw5.server.prd.adm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmBusitripApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.adm.entity.QAdmBusitripApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmBusitripApplyDetailRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 出差申请明细管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Repository
@RequiredArgsConstructor
public class AdmBusitripApplyDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AdmBusitripApplyDetailRepo repo;
    private final QAdmBusitripApplyDetailDO qdo = QAdmBusitripApplyDetailDO.admBusitripApplyDetailDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AdmBusitripApplyDetailVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AdmBusitripApplyDetailVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 申请id
                qdo.applyId,
                // 出差人资源id
                qdo.tripResId,
                // 出发地
                qdo.fromPlace,
                // 目的地
                qdo.toPlace,
                // 交通工具
                qdo.vehicle,
                // 出发日期
                qdo.beginDate,
                // 结束日期
                qdo.endDate,
                // 出发时间段
                qdo.beginTimespan,
                // 结束时间段
                qdo.endTimespan
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AdmBusitripApplyDetailVO> getJpaQueryWhere(AdmBusitripApplyDetailQuery query) {
        JPAQuery<AdmBusitripApplyDetailVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AdmBusitripApplyDetailQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AdmBusitripApplyDetailQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 申请id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyId())) {
            list.add(qdo.applyId.eq(query.getApplyId()));
        }
        /** 出差人资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getTripResId())) {
            list.add(qdo.tripResId.eq(query.getTripResId()));
        }
        /** 出发地 精确 */
        if (!ObjectUtils.isEmpty(query.getFromPlace())) {
            list.add(qdo.fromPlace.eq(query.getFromPlace()));
        }
        /** 目的地 精确 */
        if (!ObjectUtils.isEmpty(query.getToPlace())) {
            list.add(qdo.toPlace.eq(query.getToPlace()));
        }
        /** 交通工具 精确 */
        if (!ObjectUtils.isEmpty(query.getVehicle())) {
            list.add(qdo.vehicle.eq(query.getVehicle()));
        }
        /** 出发日期 精确 */
        if (!ObjectUtils.isEmpty(query.getBeginDate())) {
            list.add(qdo.beginDate.eq(query.getBeginDate()));
        }
        /** 结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.endDate.eq(query.getEndDate()));
        }
        /** 出发时间段 大于等于 */
        if (!ObjectUtils.isEmpty(query.getBeginTimespan())) {
            list.add(qdo.beginTimespan.goe(query.getBeginTimespan()));
        }
        /** 结束时间段 小于等于 */
        if (!ObjectUtils.isEmpty(query.getEndTimespan())) {
            list.add(qdo.endTimespan.loe(query.getEndTimespan()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AdmBusitripApplyDetailVO queryByKey(Long id) {
        JPAQuery<AdmBusitripApplyDetailVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AdmBusitripApplyDetailVO> queryListDynamic(AdmBusitripApplyDetailQuery query) {
        JPAQuery<AdmBusitripApplyDetailVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AdmBusitripApplyDetailVO> queryPaging(AdmBusitripApplyDetailQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AdmBusitripApplyDetailVO> jpaQuery = getJpaQueryWhere(query);
        List<AdmBusitripApplyDetailVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AdmBusitripApplyDetailVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AdmBusitripApplyDetailDO save(AdmBusitripApplyDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AdmBusitripApplyDetailDO> saveAll(List<AdmBusitripApplyDetailDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AdmBusitripApplyDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 申请id
        if (payload.getApplyId() != null) {
            update.set(qdo.applyId, payload.getApplyId());
        }
        // 出差人资源id
        if (payload.getTripResId() != null) {
            update.set(qdo.tripResId, payload.getTripResId());
        }
        // 出发地
        if (payload.getFromPlace() != null) {
            update.set(qdo.fromPlace, payload.getFromPlace());
        }
        // 目的地
        if (payload.getToPlace() != null) {
            update.set(qdo.toPlace, payload.getToPlace());
        }
        // 交通工具
        if (payload.getVehicle() != null) {
            update.set(qdo.vehicle, payload.getVehicle());
        }
        // 出发日期
        if (payload.getBeginDate() != null) {
            update.set(qdo.beginDate, payload.getBeginDate());
        }
        // 结束日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 出发时间段
        if (payload.getBeginTimespan() != null) {
            update.set(qdo.beginTimespan, payload.getBeginTimespan());
        }
        // 结束时间段
        if (payload.getEndTimespan() != null) {
            update.set(qdo.endTimespan, payload.getEndTimespan());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 申请id
            if (nullFields.contains("applyId")) {
                update.setNull(qdo.applyId);
            }
            // 出差人资源id
            if (nullFields.contains("tripResId")) {
                update.setNull(qdo.tripResId);
            }
            // 出发地
            if (nullFields.contains("fromPlace")) {
                update.setNull(qdo.fromPlace);
            }
            // 目的地
            if (nullFields.contains("toPlace")) {
                update.setNull(qdo.toPlace);
            }
            // 交通工具
            if (nullFields.contains("vehicle")) {
                update.setNull(qdo.vehicle);
            }
            // 出发日期
            if (nullFields.contains("beginDate")) {
                update.setNull(qdo.beginDate);
            }
            // 结束日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 出发时间段
            if (nullFields.contains("beginTimespan")) {
                update.setNull(qdo.beginTimespan);
            }
            // 结束时间段
            if (nullFields.contains("endTimespan")) {
                update.setNull(qdo.endTimespan);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据出差id逻辑删除
     *
     * @param applyIds 出差id
     * @return 删除的行数
     */
    public long deleteSoftByBusitripId(List<Long> applyIds) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.applyId.in(applyIds));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

