package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsCustomerVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmLeadsCustomerRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/20 - 9:17
 */
@Repository
@RequiredArgsConstructor
public class CrmLeadsCustomerDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmLeadsCustomerRepo repo;
    private final QCrmLeadsCustomerDO qdo = QCrmLeadsCustomerDO.crmLeadsCustomerDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmLeadsCustomerDO save(CrmLeadsCustomerDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmLeadsCustomerDO> saveAll(List<CrmLeadsCustomerDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结果
     */
    public CrmLeadsCustomerVO queryByKey(Long id){
        JPAQuery<CrmLeadsCustomerVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        return jpaQuery.fetchFirst();
    }




    /**
     * 拼装查询字段
     * @return  jpaQuery对象
     */
    private JPAQuery<CrmLeadsCustomerVO> getJpaQuerySelect() {
        JPAQuery<CrmLeadsCustomerVO> jpaQuery=jpaQueryFactory.select(Projections.bean(CrmLeadsCustomerVO.class,
                qdo.id,
//                qdo.leadsId,
                qdo.customerName,
                qdo.customerIndustry,
                qdo.customerContacts,
                qdo.contactsDepartment,
                qdo.contactsPosition,
                qdo.contactsPhone
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * 拼装查询条件
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmLeadsCustomerVO> getJpaQueryWhere(CrmLeadsCustomerQuery query) {
        JPAQuery<CrmLeadsCustomerVO> jpaQuery = getJpaQuerySelect();

//        if (!ObjectUtils.isEmpty(query.getLeadsId())) {
//            jpaQuery.where(qdo.leadsId.eq(query.getLeadsId()));
//        }
        if (!ObjectUtils.isEmpty(query.getCustomerName())) {
            jpaQuery.where(qdo.customerName.like(SqlUtil.toSqlLikeString(query.getCustomerName())));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerIndustry())) {
            jpaQuery.where(qdo.customerIndustry.eq(query.getCustomerIndustry()));
        }
        if (!ObjectUtils.isEmpty(query.getContactsDepartment())) {
            jpaQuery.where(qdo.contactsDepartment.eq(query.getContactsDepartment()));
        }
        if (!ObjectUtils.isEmpty(query.getCustomerContacts())) {
            jpaQuery.where(qdo.customerContacts.like(SqlUtil.toSqlLikeString(query.getCustomerContacts())));
        }
        if (!ObjectUtils.isEmpty(query.getContactsPosition())) {
            jpaQuery.where(qdo.contactsPosition.like(SqlUtil.toSqlLikeString(query.getContactsPosition())));
        }
        if (!ObjectUtils.isEmpty(query.getContactsPhone())) {
            jpaQuery.where(qdo.contactsPhone.like(SqlUtil.toSqlLikeString(query.getContactsPhone())));
        }
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery,qdo._super,query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 动态查询集合(不分页查询)
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CrmLeadsCustomerVO> queryListDynamic(CrmLeadsCustomerQuery query) {
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.asc("createTime");
        query.setOrders(Arrays.asList(orderItem));
        JPAQuery<CrmLeadsCustomerVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }



    /**
     * 分页查询
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmLeadsCustomerVO> queryPaging(CrmLeadsCustomerQuery query){
        JPAQuery<CrmLeadsCustomerVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<CrmLeadsCustomerVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.<CrmLeadsCustomerVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    public long updateByKeyDynamic(CrmLeadsCustomerPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
//        if (payload.getLeadsId() != null) {
//            update.set(qdo.leadsId, payload.getLeadsId());
//        }
        if (payload.getCustomerName() != null) {
            update.set(qdo.customerName, payload.getCustomerName());
        }
        if (payload.getCustomerIndustry() != null) {
            update.set(qdo.customerIndustry, payload.getCustomerIndustry());
        }
        if (payload.getCustomerContacts() != null) {
            update.set(qdo.customerContacts, payload.getCustomerContacts());
        }
        if (payload.getContactsDepartment() != null) {
            update.set(qdo.contactsDepartment, payload.getContactsDepartment());
        }
        if (payload.getContactsPosition() != null) {
            update.set(qdo.contactsPosition, payload.getContactsPosition());
        }
        if (payload.getContactsPhone() != null) {
            update.set(qdo.contactsPhone, payload.getContactsPhone());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("customerIndustry")) {
                update.setNull(qdo.customerIndustry);
            }
            if (nullFields.contains("contactsDepartment")) {
                update.setNull(qdo.contactsDepartment);
            }
            if (nullFields.contains("contactsPosition")) {
                update.setNull(qdo.contactsPosition);
            }
        }
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }
}
