package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.math.BigDecimal;

/**
 * 商机成单率计算指标详情
 *
 * @author likunpeng
 * @date 2023-11-03
 */
@Entity
@Table(name = "crm_opportunity_measure_d", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_measure_d", comment = "商机成单率计算指标详情")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityMeasureDDO extends BaseModel implements Serializable  {
    /** 指标类型 */
    @Comment("指标类型")
    @Column()
    private String indicatorType;
    /** 计算指标主表id */
    @Comment("计算指标主表id")
    @Column()
    private Long measureId;
    /** 字段选项value */
    @Comment("字段选项value")
    @Column()
    private String fieldOptionValue;
    /** 字段选项value */
    @Comment("字段选项value")
    @Column()
    private String fieldOptionValueDesc;
    /** 数值区间min */
    @Comment("数值区间min")
    @Column()
    private BigDecimal numericalValueMin;
    /** 数值区间max */
    @Comment("数值区间max")
    @Column()
    private BigDecimal numericalValueMax;
    /** 对应分值 */
    @Comment("对应分值")
    @Column()
    private BigDecimal score;

    public void copy(CrmOpportunityMeasureDDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
