package com.elitesland.tw.tw5.server.prd.crm.visit.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 销售拜访任务管理
 *
 * @author duwh
 * @date 2023-03-13
 */
@Entity
@Table(name = "crm_visit_task", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_visit_task", comment = "销售拜访任务管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class VisitTaskDO extends BaseModel implements Serializable  {
    /** 拜访计划主键 */
    @Comment("拜访计划主键")
    @Column()
    private Long planId;
    /** 任务名称 */
    @Comment("任务名称")
    @Column()
    private String taskName;
    /** 任务编号 */
    @Comment("任务编号")
    @Column()
    private String taskNo;
    /** 拜访计划名称（冗余） */
    @Comment("拜访计划名称（冗余）")
    @Column()
    private String planName;
    /** 拜访计划类型（冗余） */
    @Comment("拜访计划类型（冗余）")
    @Column()
    private String planType;
    /** 拜访客户主键 crm_customer.id see partnerId */
    @Comment("拜访客户主键 crm_customer.id see partnerId")
    @Column()
    @Deprecated
    private Long customerId;
    /** 业务伙伴主键（客户主表） business_partner.id */
    @Comment("业务伙伴主键（客户主表） business_partner.id")
    @Column()
    private Long partnerId;
    /** 拜访客户名称（冗余）crm_customer.customer_name */
    @Comment("拜访客户名称（冗余）crm_customer.customer_name")
    @Column()
    private String customerName;
    /** 客户地址 */
    @Comment("客户地址")
    @Column()
    private String customAdress;
    /** 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标 */
    @Comment("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标")
    @Column()
    private String longitudeLatitude;
    /** 任务状态 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW) */
    @Comment("任务状态 udc[crm:visit:task_status](已完成OK、待提交READY、未开始NEW)")
    @Column()
    private String status;

    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 拜访成员 */
    @Comment("拜访成员")
    @Column()
    private Long visitMemberId;
    /**
     * 拜访成员 直属上级 （冗余）
     */
    @Comment("拜访成员 直属上级（冗余）")
    @Column()
    private Long visitMemberParentId;
    /** 拜访成员姓名 */
    @Comment("拜访成员姓名")
    @Column()
    private String visitMemberName;
    /** 协防人员 多个英文逗号隔开 */
    @Comment("协防人员 多个英文逗号隔开")
    @Column(
        name = "team_member_ids",
        columnDefinition = "text comment '协防人员 多个英文逗号隔开' "
    )
    private String teamMemberIds;
    /** 拜访开始时间 */
    @Comment("拜访开始时间")
    @Column()
    private LocalDate startTime;
    /** 拜访结束时间 */
    @Comment("拜访结束时间")
    @Column()
    private LocalDate endTime;
    /** 关联信息类型（线索、商机OPPO、经营计划、销售目标） */
    @Comment("关联信息类型（线索、商机OPPO、经营计划、销售目标）")
    @Column()
    private String objType;
    /** 关联信息主键（关联主键) */
    @Comment("关联信息主键（关联主键)")
    @Column()
    private Long objId;
    /** 关联信息名称（冗余） */
    @Comment("关联信息名称（冗余）")
    @Column()
//    @Column(
//        name = "obj_name",
//        columnDefinition = "varchar(255) comment '关联信息名称（冗余）' "
//    )
    private String objName;
    /** 计划创建人 */
    @Comment("计划创建人")
    @Column()
    private Long planCreateUserId;
    /** 评价状态 NEW待评价 OK已评价 */
    @Comment("评价状态 NEW待评价 OK已评价")
    @Column()
    private String evalStatus;
    /** 领导评分 */
    @Comment("领导评分")
    @Column()
    private Integer leaderGradle;
    /** 下次拜访行动部署 */
    @Comment("下次拜访行动部署")
    @Column(
        name = "next_plan",
        columnDefinition = "text comment '下次拜访行动部署' "
    )
    private String nextPlan;
    /** 客户评分 */
    @Comment("客户评分")
    @Column()
    private Integer customerGradle;
    /** 客户建议 */
    @Comment("客户建议")
    @Column()
    private String customerAdvise;

    /** 经度和纬度用","分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标。 */
    @Comment("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标。")
    @Column()
    private String customerLocations;
    /** 是否打卡范围，0：否，1：是 */
    @Comment("是否打卡范围，0：否，1：是")
    @Column()
    private Integer signRangeFlag;
    /** 附件（录音）多个文件，英文逗号分隔 */
    @Comment("附件（录音）多个文件，英文逗号分隔")
    @Column()
    private String fileCodes;
    /** 客户情况说明 */
    @Comment("客户情况说明")
    @Column()
    private String customerDesc;
    /** 拜访进展与结果 */
    @Comment("拜访进展与结果")
    @Column()
    private String result;
    /** 下次拜访时间 */
    @Comment("下次拜访时间")
    @Column()
    private LocalDateTime nextVisitTime;

    @Comment("客户意愿 udc[crm:follow:cust_aspiration]")
    @Column()
    private String customerWillingness;

    @Comment("重大销售线索")
    @Column()
    private String leads;

    @Comment("市场感知反馈")
    @Column()
    private String marketFeedback;

    @Comment("产品反馈")
    @Column()
    private String productFeedback;

    @Comment("活动参与反馈")
    @Column()
    private String activityFeedback;

    @Comment("其他需求反馈")
    @Column()
    private String otherFeedback;


    /** 签到坐标（最新） */
    @Comment("签到坐标（最新）")
    @Column()
    private String signLocations;
    /** 签到地点（最新） */
    @Comment("签到地点（最新）")
    @Column()
    private String signAddress;
    /** 签到时间（最新） */
    @Comment("签到时间（最新）")
    @Column()
    private LocalDateTime signTime;
    /** 签到图片（最新） */
    @Comment("签到图片（最新）")
    @Column()
    private String signFileCodes;
    /** 签退坐标（最新） */
    @Comment("签退坐标（最新）")
    @Column()
    private String signOutLocations;
    /** 签退地点（最新） */
    @Comment("签退地点（最新）")
    @Column()
    private String signOutAddress;
    /** 签退时间（最新） */
    @Comment("签退时间（最新）")
    @Column()
    private LocalDateTime signOutTime;
    /** 签退图片（最新） */
    @Comment("签退图片（最新）")
    @Column()
    private String signOutFileCodes;

    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;
    /** 拓展字段4 */
    @Comment("拓展字段4")
    @Column()
    private String ext4;
    /** 拓展字段5 */
    @Comment("拓展字段5")
    @Column()
    private String ext5;

    /** 拓展字段6 */
    @Comment("拓展字段6")
    @Column()
    private String ext6;
    /** 拓展字段7 */
    @Comment("拓展字段7")
    @Column()
    private String ext7;
    /** 拓展字段8 */
    @Comment("拓展字段8")
    @Column()
    private String ext8;
    /** 拓展字段9 */
    @Comment("拓展字段9")
    @Column()
    private String ext9;
    /** 拓展字段10 */
    @Comment("拓展字段10")
    @Column()
    private String ext10;
    /** 拓展字段11 */
    @Comment("拓展字段11")
    @Column()
    private String ext11;
    /** 拓展字段12 */
    @Comment("拓展字段12")
    @Column()
    private String ext12;
    /** 拓展字段13 */
    @Comment("拓展字段13")
    @Column()
    private String ext13;
    /** 拓展字段14 */
    @Comment("拓展字段14")
    @Column()
    private String ext14;
    /** 拓展字段15 */
    @Comment("拓展字段15")
    @Column()
    private String ext15;
    /** 拓展字段16 */
    @Comment("拓展字段16")
    @Column()
    private String ext16;
    /** 拓展字段17 */
    @Comment("拓展字段17")
    @Column()
    private String ext17;
    /** 拓展字段18 */
    @Comment("拓展字段18")
    @Column()
    private String ext18;
    /** 拓展字段19 */
    @Comment("拓展字段19")
    @Column()
    private String ext19;
    /** 拓展字段20 */
    @Comment("拓展字段20")
    @Column()
    private String ext20;

    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 发送短信标记 */
    @Comment("发送短信标记")
    @Column()
    private Integer sendFlag;

    /** 拜访任务类型 udc[crm:visit:task_type] */
    @Comment("拜访任务类型")
    @Column()
    private String taskType;

    @Comment("页面配置主键 prd_business_page.id")
    @Column()
    private Long pageId;

    public void copy(VisitTaskDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
